/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.builder.renderer;

import com.intellij.openapi.graph.builder.renderer.BasicNodeCellRenderer;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.ui.CellRendererPanel;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;

public abstract class AbstractColoredNodeCellRenderer
extends BasicNodeCellRenderer {
    private static final Color BORDER_COLOR = Color.LIGHT_GRAY;
    private static final Color SHADOW_BORDER_COLOR = Color.GRAY;
    public static final String GRAPH_NODE_SELECTED = "GRAPH_NODE_SELECTED";

    protected AbstractColoredNodeCellRenderer(ModificationTracker modificationTracker) {
        super(modificationTracker);
    }

    @Override
    protected JComponent getRendererComponent(Graph2DView view, NodeRealizer realizer, Object object, boolean sel) {
        CellRendererPanel.SuperPreferredSize innerPanel = new CellRendererPanel.SuperPreferredSize();
        innerPanel.setLayout(new BorderLayout());
        CellRendererPanel.SuperPreferredSize outerPanel = new CellRendererPanel.SuperPreferredSize();
        outerPanel.setLayout(new BorderLayout());
        outerPanel.add((Component)innerPanel, "Center");
        if (GraphViewUtil.isPrintMode()) {
            outerPanel.setBorder(new LineBorder((Color)Gray._168, 2));
            innerPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
        } else if (!UIUtil.isUnderDarcula()) {
            outerPanel.setBorder(sel ? new LineBorder(this.getSelectionColor(), this.getSelectionBorderWidth(), true) : new ShadowedLineBorder());
            innerPanel.setBorder(sel ? new LineBorder(this.getSelectionColor(), this.getSelectionBorderWidth(), false) : new LineBorder(BORDER_COLOR));
        } else {
            outerPanel.setBorder(new LineBorder(sel ? this.getSelectionColor() : Gray._120));
            innerPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
        }
        outerPanel.setFocusable(false);
        innerPanel.setFocusable(false);
        innerPanel.putClientProperty(GRAPH_NODE_SELECTED, sel);
        this.tuneNode(realizer, innerPanel);
        return outerPanel;
    }

    public abstract void tuneNode(NodeRealizer var1, JPanel var2);

    protected int getSelectionBorderWidth() {
        return 1;
    }

    protected Color getSelectionColor() {
        return new JBColor(Color.ORANGE, (Color)JBColor.blue);
    }

    public class ShadowedLineBorder
    extends LineBorder {
        public ShadowedLineBorder() {
            super(BORDER_COLOR, AbstractColoredNodeCellRenderer.this.getSelectionBorderWidth());
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Color oldColor = g.getColor();
            g.setColor((Color)new JBColor(Color.GRAY, (Color)Gray._120));
            int w = AbstractColoredNodeCellRenderer.this.getSelectionBorderWidth();
            g.fillRect(x + 2 * w, y + height - w, width - 2 * w, w);
            g.fillRect(x + width - w, y + 2 * w, w, height - 2 * w);
            g.setColor(oldColor);
        }
    }
}

