/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.InspectionEP;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.deadCode.UnusedDeclarationInspection;
import com.intellij.codeInspection.deadCode.UnusedDeclarationInspectionBase;
import com.intellij.codeInspection.deadCode.UnusedDeclarationPresentation;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionManagerEx;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.reference.EntryPoint;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.PathManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.testFramework.IdeaTestUtil;
import com.intellij.testFramework.InspectionTestUtil;
import com.intellij.testFramework.InspectionsKt;
import com.intellij.testFramework.PsiTestCase;
import com.intellij.testFramework.PsiTestUtil;
import com.intellij.testFramework.fixtures.impl.GlobalInspectionContextForTests;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class InspectionTestCase
extends PsiTestCase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.testFramework.InspectionTestCase");
    private EntryPoint myUnusedCodeExtension;
    private VirtualFile ext_src;

    public static GlobalInspectionToolWrapper getUnusedDeclarationWrapper() {
        InspectionEP ep = new InspectionEP();
        ep.presentation = UnusedDeclarationPresentation.class.getName();
        ep.implementationClass = UnusedDeclarationInspection.class.getName();
        ep.shortName = "unused";
        ep.displayName = UnusedDeclarationInspectionBase.DISPLAY_NAME;
        return new GlobalInspectionToolWrapper(ep);
    }

    public InspectionManagerEx getManager() {
        return (InspectionManagerEx)InspectionManager.getInstance(this.myProject);
    }

    public void doTest(@NonNls @NotNull String folderName, @NotNull LocalInspectionTool tool) {
        if (folderName == null) {
            InspectionTestCase.$$$reportNull$$$0(0);
        }
        if (tool == null) {
            InspectionTestCase.$$$reportNull$$$0(1);
        }
        this.doTest(folderName, (InspectionToolWrapper)new LocalInspectionToolWrapper(tool));
    }

    public void doTest(@NonNls @NotNull String folderName, @NotNull GlobalInspectionTool tool) {
        if (folderName == null) {
            InspectionTestCase.$$$reportNull$$$0(2);
        }
        if (tool == null) {
            InspectionTestCase.$$$reportNull$$$0(3);
        }
        this.doTest(folderName, (InspectionToolWrapper)new GlobalInspectionToolWrapper(tool));
    }

    public void doTest(@NonNls @NotNull String folderName, @NotNull GlobalInspectionTool tool, boolean checkRange) {
        if (folderName == null) {
            InspectionTestCase.$$$reportNull$$$0(4);
        }
        if (tool == null) {
            InspectionTestCase.$$$reportNull$$$0(5);
        }
        this.doTest(folderName, (InspectionToolWrapper)new GlobalInspectionToolWrapper(tool), checkRange);
    }

    public void doTest(@NonNls @NotNull String folderName, @NotNull GlobalInspectionTool tool, boolean checkRange, boolean runDeadCodeFirst) {
        if (folderName == null) {
            InspectionTestCase.$$$reportNull$$$0(6);
        }
        if (tool == null) {
            InspectionTestCase.$$$reportNull$$$0(7);
        }
        this.doTest(folderName, (InspectionToolWrapper)new GlobalInspectionToolWrapper(tool), "java 1.4", checkRange, runDeadCodeFirst, new InspectionToolWrapper[0]);
    }

    public void doTest(@NonNls @NotNull String folderName, @NotNull InspectionToolWrapper tool) {
        if (folderName == null) {
            InspectionTestCase.$$$reportNull$$$0(8);
        }
        if (tool == null) {
            InspectionTestCase.$$$reportNull$$$0(9);
        }
        this.doTest(folderName, tool, "java 1.4");
    }

    public void doTest(@NonNls @NotNull String folderName, @NotNull InspectionToolWrapper tool, boolean checkRange) {
        if (folderName == null) {
            InspectionTestCase.$$$reportNull$$$0(10);
        }
        if (tool == null) {
            InspectionTestCase.$$$reportNull$$$0(11);
        }
        this.doTest(folderName, tool, "java 1.4", checkRange);
    }

    public void doTest(@NonNls @NotNull String folderName, @NotNull LocalInspectionTool tool, @NonNls String jdkName) {
        if (folderName == null) {
            InspectionTestCase.$$$reportNull$$$0(12);
        }
        if (tool == null) {
            InspectionTestCase.$$$reportNull$$$0(13);
        }
        this.doTest(folderName, (InspectionToolWrapper)new LocalInspectionToolWrapper(tool), jdkName);
    }

    public void doTest(@NonNls @NotNull String folderName, @NotNull InspectionToolWrapper tool, @NonNls String jdkName) {
        if (folderName == null) {
            InspectionTestCase.$$$reportNull$$$0(14);
        }
        if (tool == null) {
            InspectionTestCase.$$$reportNull$$$0(15);
        }
        this.doTest(folderName, tool, jdkName, false);
    }

    public void doTest(@NonNls @NotNull String folderName, @NotNull InspectionToolWrapper tool, @NonNls String jdkName, boolean checkRange) {
        if (folderName == null) {
            InspectionTestCase.$$$reportNull$$$0(16);
        }
        if (tool == null) {
            InspectionTestCase.$$$reportNull$$$0(17);
        }
        this.doTest(folderName, tool, jdkName, checkRange, false, new InspectionToolWrapper[0]);
    }

    public void doTest(@NonNls @NotNull String folderName, @NotNull InspectionToolWrapper toolWrapper, @NonNls String jdkName, boolean checkRange, boolean runDeadCodeFirst, InspectionToolWrapper ... additional) {
        if (folderName == null) {
            InspectionTestCase.$$$reportNull$$$0(18);
        }
        if (toolWrapper == null) {
            InspectionTestCase.$$$reportNull$$$0(19);
        }
        if (additional == null) {
            InspectionTestCase.$$$reportNull$$$0(20);
        }
        String testDir = this.getTestDataPath() + "/" + folderName;
        GlobalInspectionContextImpl context = this.runTool(testDir, jdkName, runDeadCodeFirst, toolWrapper, additional);
        InspectionTestUtil.compareToolResults((GlobalInspectionContextImpl)context, (boolean)checkRange, (String)testDir, (Collection)ContainerUtil.append(Collections.singletonList(toolWrapper), (Object[])additional));
    }

    protected void runTool(@NonNls @NotNull String testDir, @NonNls String jdkName, @NotNull InspectionToolWrapper tool) {
        if (testDir == null) {
            InspectionTestCase.$$$reportNull$$$0(21);
        }
        if (tool == null) {
            InspectionTestCase.$$$reportNull$$$0(22);
        }
        this.runTool(testDir, jdkName, false, tool, new InspectionToolWrapper[0]);
    }

    protected GlobalInspectionContextImpl runTool(@NotNull String testDir, String jdkName, boolean runDeadCodeFirst, @NotNull InspectionToolWrapper toolWrapper, InspectionToolWrapper ... additional) {
        if (testDir == null) {
            InspectionTestCase.$$$reportNull$$$0(23);
        }
        if (toolWrapper == null) {
            InspectionTestCase.$$$reportNull$$$0(24);
        }
        if (additional == null) {
            InspectionTestCase.$$$reportNull$$$0(25);
        }
        VirtualFile[] sourceDir = new VirtualFile[1];
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (testDir == null) {
                InspectionTestCase.$$$reportNull$$$0(29);
            }
            try {
                this.setupRootModel(testDir, sourceDir, jdkName);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        });
        VirtualFile projectDir = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(new File(testDir));
        AnalysisScope scope = this.createAnalysisScope(sourceDir[0].equals(projectDir) ? projectDir : sourceDir[0].getParent());
        ArrayList<Object> toolWrappers = new ArrayList<Object>();
        if (runDeadCodeFirst) {
            toolWrappers.add(InspectionTestCase.getUnusedDeclarationWrapper());
        }
        toolWrappers.add(toolWrapper);
        ContainerUtil.addAll(toolWrappers, (Object[])additional);
        GlobalInspectionContextForTests globalContext = InspectionsKt.createGlobalContextForTool((AnalysisScope)scope, (Project)this.getProject(), toolWrappers);
        InspectionTestUtil.runTool((InspectionToolWrapper)toolWrapper, (AnalysisScope)scope, (GlobalInspectionContextForTests)globalContext);
        return globalContext;
    }

    @NotNull
    protected AnalysisScope createAnalysisScope(VirtualFile sourceDir) {
        PsiManager psiManager = PsiManager.getInstance(this.myProject);
        AnalysisScope analysisScope = new AnalysisScope(psiManager.findDirectory(sourceDir));
        if (analysisScope == null) {
            InspectionTestCase.$$$reportNull$$$0(26);
        }
        return analysisScope;
    }

    protected void setupRootModel(@NotNull String testDir, @NotNull VirtualFile[] sourceDir, String sdkName) {
        VirtualFile test_src;
        if (testDir == null) {
            InspectionTestCase.$$$reportNull$$$0(27);
        }
        if (sourceDir == null) {
            InspectionTestCase.$$$reportNull$$$0(28);
        }
        VirtualFile projectDir = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(new File(testDir));
        InspectionTestCase.assertNotNull((String)("could not find project dir " + testDir), (Object)projectDir);
        sourceDir[0] = projectDir.findChild("src");
        if (sourceDir[0] == null) {
            sourceDir[0] = projectDir;
        }
        PsiTestUtil.removeAllRoots((Module)this.myModule, (Sdk)this.getTestProjectSdk());
        PsiTestUtil.addContentRoot((Module)this.myModule, (VirtualFile)projectDir);
        PsiTestUtil.addSourceRoot((Module)this.myModule, (VirtualFile)sourceDir[0]);
        this.ext_src = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(new File(testDir + "/ext_src"));
        if (this.ext_src != null) {
            PsiTestUtil.addSourceRoot((Module)this.myModule, (VirtualFile)this.ext_src);
        }
        if ((test_src = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(new File(testDir + "/test_src"))) != null) {
            PsiTestUtil.addSourceRoot((Module)this.myModule, (VirtualFile)test_src, (boolean)true);
        }
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        ExtensionPoint point = Extensions.getRootArea().getExtensionPoint("com.intellij.deadCode");
        this.myUnusedCodeExtension = new EntryPoint(){

            @Override
            @NotNull
            public String getDisplayName() {
                if ("duh" == null) {
                    1.$$$reportNull$$$0(0);
                }
                return "duh";
            }

            @Override
            public boolean isEntryPoint(@NotNull RefElement refElement, @NotNull PsiElement psiElement) {
                if (refElement == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (psiElement == null) {
                    1.$$$reportNull$$$0(2);
                }
                return this.isEntryPoint(psiElement);
            }

            @Override
            public boolean isEntryPoint(@NotNull PsiElement psiElement) {
                if (psiElement == null) {
                    1.$$$reportNull$$$0(3);
                }
                return InspectionTestCase.this.ext_src != null && VfsUtilCore.isAncestor(InspectionTestCase.this.ext_src, PsiUtilCore.getVirtualFile(psiElement), false);
            }

            @Override
            public boolean isSelected() {
                return true;
            }

            @Override
            public void setSelected(boolean selected) {
            }

            public void readExternal(Element element) {
            }

            public void writeExternal(Element element) {
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/testFramework/InspectionTestCase$1";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "refElement";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "psiElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDisplayName";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/testFramework/InspectionTestCase$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "isEntryPoint";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        point.registerExtension((Object)this.myUnusedCodeExtension);
    }

    @Override
    protected void tearDown() throws Exception {
        try {
            ExtensionPoint point = Extensions.getRootArea().getExtensionPoint("com.intellij.deadCode");
            point.unregisterExtension((Object)this.myUnusedCodeExtension);
            this.myUnusedCodeExtension = null;
            this.ext_src = null;
        }
        finally {
            super.tearDown();
        }
    }

    protected void setUpJdk() {
    }

    protected Sdk getTestProjectSdk() {
        Sdk sdk = IdeaTestUtil.getMockJdk18();
        LanguageLevelProjectExtension.getInstance(this.getProject()).setLanguageLevel(LanguageLevel.JDK_1_8);
        return sdk;
    }

    @Override
    @NonNls
    protected String getTestDataPath() {
        return PathManagerEx.getTestDataPath() + "/inspection/";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folderName";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tool";
                break;
            }
            case 19: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWrapper";
                break;
            }
            case 20: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additional";
                break;
            }
            case 21: 
            case 23: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testDir";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/InspectionTestCase";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceDir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/InspectionTestCase";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "createAnalysisScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doTest";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "runTool";
                break;
            }
            case 26: {
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "setupRootModel";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "lambda$runTool$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

