/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.libraries;

import com.intellij.ProjectTopics;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.LanguagePerFileMappings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.webcore.ModuleHelper;
import com.intellij.webcore.libraries.ScriptingLibraryManager;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import com.intellij.webcore.libraries.ScriptingLibraryUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ScriptingLibraryMappings
extends LanguagePerFileMappings<ScriptingLibraryModel> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.webcore.libraries.ScriptingLibraryMappings");
    private final Map<VirtualFile, CompoundLibrary> myCompoundLibMap;
    private CompoundLibrary myProjectLibs;
    private volatile MultiMap<String, VirtualFile> myMappingsByLibraryNameMap;

    public ScriptingLibraryMappings(@NotNull Project project) {
        if (project == null) {
            ScriptingLibraryMappings.$$$reportNull$$$0(0);
        }
        super(project);
        this.myCompoundLibMap = ContainerUtil.newHashMap();
        this.myProjectLibs = new CompoundLibrary();
        this.registerLibraryTableListener(new MyLibraryTableListener(), this);
        MessageBusConnection conn = project.getMessageBus().connect((Disposable)project);
        conn.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            @Override
            public void rootsChanged(ModuleRootEvent event) {
                ScriptingLibraryMappings.this.myMappingsByLibraryNameMap = null;
            }
        });
    }

    @NotNull
    protected abstract ScriptingLibraryManager getLibraryManager();

    public void registerLibraryTableListener(LibraryTable.Listener listener, Disposable parentDisposable) {
        LibraryTable libTable = this.getLibraryManager().getLibraryTable(ScriptingLibraryModel.LibraryLevel.GLOBAL);
        libTable.addListener(listener, parentDisposable);
        libTable = this.getLibraryManager().getLibraryTable(ScriptingLibraryModel.LibraryLevel.PROJECT);
        libTable.addListener(listener, parentDisposable);
    }

    @Override
    public void setMappings(@NotNull Map<VirtualFile, ScriptingLibraryModel> mappings) {
        if (mappings == null) {
            ScriptingLibraryMappings.$$$reportNull$$$0(1);
        }
        super.setMappings(mappings);
        this.myMappingsByLibraryNameMap = null;
    }

    @Override
    public void setMapping(@Nullable VirtualFile file, @Nullable ScriptingLibraryModel dialect) {
        super.setMapping(file, dialect);
        this.myMappingsByLibraryNameMap = null;
    }

    @Override
    public void loadState(Element state) {
        super.loadState(state);
        this.myMappingsByLibraryNameMap = null;
    }

    @Override
    public void cleanupForNextTest() {
        super.cleanupForNextTest();
        this.myMappingsByLibraryNameMap = null;
    }

    @Override
    protected String serialize(ScriptingLibraryModel library) {
        if (library instanceof CompoundLibrary) {
            return ((CompoundLibrary)library).serialize();
        }
        return this.getLibrarySerializationName(library);
    }

    @NotNull
    private String getLibrarySerializationName(@NotNull ScriptingLibraryModel library) {
        if (library == null) {
            ScriptingLibraryMappings.$$$reportNull$$$0(2);
        }
        if (library.isPredefined()) {
            String string = this.getPredefinedLibrarySerializationName(library.getName());
            if (string == null) {
                ScriptingLibraryMappings.$$$reportNull$$$0(3);
            }
            return string;
        }
        String string = library.getName();
        if (string == null) {
            ScriptingLibraryMappings.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    protected String getPredefinedLibraryPresentationName(@NotNull String serializationName) {
        if (serializationName == null) {
            ScriptingLibraryMappings.$$$reportNull$$$0(5);
        }
        String string = serializationName;
        if (string == null) {
            ScriptingLibraryMappings.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    protected String getPredefinedLibrarySerializationName(@NotNull String presentationName) {
        if (presentationName == null) {
            ScriptingLibraryMappings.$$$reportNull$$$0(7);
        }
        String string = presentationName;
        if (string == null) {
            ScriptingLibraryMappings.$$$reportNull$$$0(8);
        }
        return string;
    }

    public void reset() {
        this.getLibraryManager().reset();
        for (CompoundLibrary container : this.myCompoundLibMap.values()) {
            container.reset();
        }
        this.myProjectLibs.reset();
        this.myMappingsByLibraryNameMap = null;
    }

    public void updateMappings() {
        this.myCompoundLibMap.clear();
        this.myProjectLibs = new CompoundLibrary();
        HashMap newMappings = ContainerUtil.newHashMap();
        Map mappings = this.getMappings();
        for (Map.Entry entry : mappings.entrySet()) {
            VirtualFile file = entry.getKey();
            CompoundLibrary container = (CompoundLibrary)ObjectUtils.tryCast(entry.getValue(), CompoundLibrary.class);
            if (container == null) continue;
            CompoundLibrary newContainer = new CompoundLibrary();
            for (ScriptingLibraryModel libraryModel : container.getLibraries()) {
                String libName = libraryModel.getName();
                ScriptingLibraryModel updatedModel = this.getLibraryManager().getLibraryByName(libName);
                if (updatedModel == null) continue;
                newContainer.addLibrary(updatedModel);
            }
            if (newContainer.isEmpty()) continue;
            newMappings.put(file, newContainer);
            if (file == null) {
                this.myProjectLibs = newContainer;
                continue;
            }
            this.myCompoundLibMap.put(file, newContainer);
        }
        this.setMappings(newMappings);
        this.myMappingsByLibraryNameMap = null;
    }

    @NotNull
    private MultiMap<String, VirtualFile> getMappingsByLibraryNameMap() {
        MultiMap result = this.myMappingsByLibraryNameMap;
        if (result != null) {
            MultiMap multiMap = result;
            if (multiMap == null) {
                ScriptingLibraryMappings.$$$reportNull$$$0(9);
            }
            return multiMap;
        }
        result = MultiMap.create();
        Map mappings = this.getMappings();
        for (Map.Entry entry : mappings.entrySet()) {
            VirtualFile file = entry.getKey();
            CompoundLibrary container = (CompoundLibrary)ObjectUtils.tryCast(entry.getValue(), CompoundLibrary.class);
            if (container == null) continue;
            for (ScriptingLibraryModel libraryModel : container.getLibraries()) {
                String libName = libraryModel.getName();
                result.putValue((Object)libName, (Object)file);
            }
        }
        this.myMappingsByLibraryNameMap = result;
        MultiMap multiMap = result;
        if (multiMap == null) {
            ScriptingLibraryMappings.$$$reportNull$$$0(10);
        }
        return multiMap;
    }

    public void associate(@Nullable VirtualFile file, String libName, boolean isPredefined) {
        ScriptingLibraryModel libraryModel = this.getLibraryManager().getLibraryByName(libName);
        if (libraryModel == null) {
            return;
        }
        ScriptingLibraryModel container = (ScriptingLibraryModel)this.getImmediateMapping(file);
        if (container == null || !(container instanceof CompoundLibrary)) {
            container = new CompoundLibrary();
        }
        ((CompoundLibrary)container).addLibrary(libraryModel);
        this.setMapping(file, container);
        if (libraryModel.isPredefined() != isPredefined) {
            LOG.error("Library " + libName + " is incorrectly treated as " + (isPredefined ? "predefined" : "normal") + " while it is created as " + (libraryModel.isPredefined() ? "predefined" : "normal"));
        }
        this.myMappingsByLibraryNameMap = null;
    }

    public void associateWithProject(String libName) {
        this.associate(null, libName);
    }

    public void disassociateWithProject(@NotNull String libraryName) {
        if (libraryName == null) {
            ScriptingLibraryMappings.$$$reportNull$$$0(11);
        }
        this.disassociate(null, libraryName);
    }

    public void associate(@Nullable VirtualFile file, String libName) {
        this.associate(file, libName, false);
    }

    public void disassociate(@Nullable VirtualFile file, String libName) {
        ScriptingLibraryModel libraryModel = this.getLibraryManager().getLibraryByName(libName);
        if (libraryModel == null) {
            return;
        }
        ScriptingLibraryModel container = (ScriptingLibraryModel)this.getImmediateMapping(file);
        if (container == null) {
            return;
        }
        if (container instanceof CompoundLibrary && ((CompoundLibrary)container).containsLibrary(libName)) {
            ((CompoundLibrary)container).toggleLibrary(libraryModel);
            ((CompoundLibrary)container).applyChanges();
        }
        this.myMappingsByLibraryNameMap = null;
    }

    public boolean isAssociatedWithProject(String libName) {
        return this.isAssociatedWith(null, libName);
    }

    public boolean isAssociatedWith(@Nullable VirtualFile file, String libName) {
        ScriptingLibraryModel libraryModel = this.getLibraryManager().getLibraryByName(libName);
        if (libraryModel == null) {
            return false;
        }
        ScriptingLibraryModel container = (ScriptingLibraryModel)this.getImmediateMapping(file);
        return this.containsLibraryName(container, libName);
    }

    public boolean isLibraryInScopeFor(@NotNull VirtualFile file, @NotNull String libraryName) {
        ScriptingLibraryModel libraryModel;
        if (file == null) {
            ScriptingLibraryMappings.$$$reportNull$$$0(12);
        }
        if (libraryName == null) {
            ScriptingLibraryMappings.$$$reportNull$$$0(13);
        }
        if ((libraryModel = this.getLibraryManager().getLibraryByName(libraryName)) == null) {
            return false;
        }
        Ref found = Ref.create((Object)false);
        ScriptingLibraryMappings.iterateUp(file, (Processor<VirtualFile>)((Processor)virtualFile2 -> {
            ScriptingLibraryModel model;
            if (libraryName == null) {
                ScriptingLibraryMappings.$$$reportNull$$$0(31);
            }
            if (this.containsLibraryName(model = (ScriptingLibraryModel)this.getImmediateMapping((VirtualFile)virtualFile2), libraryName)) {
                found.set((Object)true);
                return false;
            }
            return true;
        }));
        return (Boolean)found.get();
    }

    private boolean containsLibraryName(@Nullable ScriptingLibraryModel container, @NotNull String libraryName) {
        if (libraryName == null) {
            ScriptingLibraryMappings.$$$reportNull$$$0(14);
        }
        if (container == null) {
            return false;
        }
        if (container instanceof CompoundLibrary) {
            return ((CompoundLibrary)container).containsLibrary(libraryName);
        }
        return container.getName().equals(libraryName);
    }

    @Override
    @NotNull
    protected String getValueAttribute() {
        if ("libraries" == null) {
            ScriptingLibraryMappings.$$$reportNull$$$0(15);
        }
        return "libraries";
    }

    @Override
    protected ScriptingLibraryModel handleUnknownMapping(VirtualFile file, String value) {
        if (value == null || !value.contains("{")) {
            return null;
        }
        String[] libNames = value.replace('{', ' ').replace('}', ' ').split(",");
        CompoundLibrary compoundLib = new CompoundLibrary();
        for (String libName : libNames) {
            String presentationName = this.getPredefinedLibraryPresentationName(libName.trim());
            ScriptingLibraryModel libraryModel = this.getLibraryManager().getLibraryByName(presentationName);
            if (libraryModel == null) continue;
            compoundLib.addLibrary(libraryModel);
        }
        if (file == null) {
            this.myProjectLibs = compoundLib;
        } else {
            this.myCompoundLibMap.put(file, compoundLib);
        }
        return compoundLib;
    }

    @NotNull
    public Collection<ScriptingLibraryModel> getValueVariants(@Nullable VirtualFile file) {
        List<ScriptingLibraryModel> libraries = this.getSingleLibraries();
        if (this.myCompoundLibMap.containsKey(file)) {
            libraries.add(this.myCompoundLibMap.get(file));
            List<ScriptingLibraryModel> list = libraries;
            if (list == null) {
                ScriptingLibraryMappings.$$$reportNull$$$0(16);
            }
            return list;
        }
        CompoundLibrary compoundLib = new CompoundLibrary();
        this.myCompoundLibMap.put(file, compoundLib);
        libraries.add(compoundLib);
        List<ScriptingLibraryModel> list = libraries;
        if (list == null) {
            ScriptingLibraryMappings.$$$reportNull$$$0(17);
        }
        return list;
    }

    @Nullable
    public ScriptingLibraryModel adjustChosenValue(VirtualFile file, ScriptingLibraryModel value) {
        CompoundLibrary compoundLib;
        if (value instanceof CompoundLibrary) {
            return value;
        }
        CompoundLibrary compoundLibrary = compoundLib = file == null ? this.myProjectLibs : this.myCompoundLibMap.get(file);
        if (value == null) {
            if (compoundLib != null) {
                compoundLib.clearLibraries();
                this.myCompoundLibMap.remove(file);
                compoundLib = null;
            }
        } else {
            if (compoundLib == null) {
                compoundLib = new CompoundLibrary();
                this.myCompoundLibMap.put(file, compoundLib);
            }
            compoundLib.toggleLibrary(value);
            if (compoundLib.isEmpty()) {
                this.myCompoundLibMap.remove(file);
                compoundLib = null;
            }
        }
        return compoundLib;
    }

    @Override
    public List<ScriptingLibraryModel> getAvailableValues() {
        return this.getSingleLibraries();
    }

    @Override
    public ScriptingLibraryModel getDefaultMapping(@Nullable VirtualFile file) {
        return null;
    }

    public List<ScriptingLibraryModel> getSingleLibraries() {
        return new ArrayList<ScriptingLibraryModel>(Arrays.asList(this.getLibraryManager().getAllLibraries()));
    }

    public static boolean isAssociatedWithProject(@NotNull List<VirtualFile> mappings) {
        if (mappings == null) {
            ScriptingLibraryMappings.$$$reportNull$$$0(18);
        }
        return mappings.contains(null);
    }

    public boolean isApplicable(VirtualFile libFile, VirtualFile srcFile) {
        if (!this.getLibraryManager().isLibraryFile(libFile)) {
            return true;
        }
        return this.isRecursivelyApplicable(libFile, srcFile);
    }

    private boolean isRecursivelyApplicable(VirtualFile libFile, VirtualFile srcFile) {
        if (srcFile == null) {
            return false;
        }
        ScriptingLibraryModel libraryModel = (ScriptingLibraryModel)this.getMapping(srcFile);
        if (libraryModel != null && libraryModel.containsFile(libFile)) {
            return true;
        }
        return this.isApplicable(libFile, srcFile.getParent());
    }

    private static void iterateUp(@Nullable VirtualFile file, @NotNull Processor<VirtualFile> processor) {
        if (processor == null) {
            ScriptingLibraryMappings.$$$reportNull$$$0(19);
        }
        if (!processor.process(null)) {
            return;
        }
        while (file != null) {
            if (!processor.process((Object)file)) {
                return;
            }
            file = file instanceof VirtualFileWindow ? ((VirtualFileWindow)((Object)file)).getDelegate() : file.getParent();
        }
    }

    public void forEachLibraryInScopeForFile(@NotNull VirtualFile file, @NotNull Consumer<ScriptingLibraryModel> consumer) {
        if (file == null) {
            ScriptingLibraryMappings.$$$reportNull$$$0(20);
        }
        if (consumer == null) {
            ScriptingLibraryMappings.$$$reportNull$$$0(21);
        }
        ScriptingLibraryMappings.iterateUp(file, (Processor<VirtualFile>)((Processor)virtualFile2 -> {
            ScriptingLibraryModel model;
            if (consumer == null) {
                ScriptingLibraryMappings.$$$reportNull$$$0(30);
            }
            if ((model = (ScriptingLibraryModel)this.getImmediateMapping((VirtualFile)virtualFile2)) instanceof CompoundLibrary) {
                for (ScriptingLibraryModel child : ((CompoundLibrary)model).getLibraries()) {
                    consumer.consume((Object)child);
                }
            } else if (model != null) {
                consumer.consume((Object)model);
            }
            return true;
        }));
    }

    @Override
    protected boolean shouldReparseFiles() {
        return false;
    }

    private boolean containsProjectLibraryName(@NotNull String libName) {
        if (libName == null) {
            ScriptingLibraryMappings.$$$reportNull$$$0(22);
        }
        return this.containsLibraryName((ScriptingLibraryModel)this.getImmediateMapping(null), libName);
    }

    public boolean containsLibrary(@NotNull ScriptingLibraryModel libModel) {
        if (libModel == null) {
            ScriptingLibraryMappings.$$$reportNull$$$0(23);
        }
        return !this.getMappingsByLibraryName(libModel.getName()).isEmpty();
    }

    public boolean dependsOn(@NotNull Module module, @NotNull ScriptingLibraryModel libModel, int moduleCount) {
        String libName;
        if (module == null) {
            ScriptingLibraryMappings.$$$reportNull$$$0(24);
        }
        if (libModel == null) {
            ScriptingLibraryMappings.$$$reportNull$$$0(25);
        }
        if (this.containsProjectLibraryName(libName = libModel.getName())) {
            return moduleCount == 1 || libModel.isAssociatedWith(module);
        }
        for (VirtualFile file : this.getMappings().keySet()) {
            ScriptingLibraryModel container = (ScriptingLibraryModel)this.getMapping(file);
            if (!(container instanceof CompoundLibrary) || !((CompoundLibrary)container).containsLibrary(libName) || !ModuleHelper.isSuitableModule(libModel, module, moduleCount, file)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public List<VirtualFile> getMappingsByLibraryName(@NotNull String libraryName) {
        if (libraryName == null) {
            ScriptingLibraryMappings.$$$reportNull$$$0(26);
        }
        MultiMap<String, VirtualFile> mappings = this.getMappingsByLibraryNameMap();
        List list = (List)mappings.get((Object)libraryName);
        if (list == null) {
            ScriptingLibraryMappings.$$$reportNull$$$0(27);
        }
        return list;
    }

    @NotNull
    public GlobalSearchScope getLibraryScopeForFile(@NotNull VirtualFile file) {
        if (file == null) {
            ScriptingLibraryMappings.$$$reportNull$$$0(28);
        }
        HashSet<VirtualFile> files = new HashSet<VirtualFile>();
        this.forEachLibraryInScopeForFile(file, (Consumer<ScriptingLibraryModel>)((Consumer)model -> model.addSignificantFiles(files)));
        GlobalSearchScope globalSearchScope = ScriptingLibraryUtil.getFilesAndDirectoriesScope(this.getProject(), files);
        if (globalSearchScope == null) {
            ScriptingLibraryMappings.$$$reportNull$$$0(29);
        }
        return globalSearchScope;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 27: 
            case 29: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 27: 
            case 29: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/webcore/libraries/ScriptingLibraryMappings";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serializationName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentationName";
                break;
            }
            case 11: 
            case 13: 
            case 14: 
            case 26: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryName";
                break;
            }
            case 12: 
            case 20: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 21: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libName";
                break;
            }
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libModel";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/webcore/libraries/ScriptingLibraryMappings";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibrarySerializationName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPredefinedLibraryPresentationName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPredefinedLibrarySerializationName";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getMappingsByLibraryNameMap";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueAttribute";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueVariants";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getMappingsByLibraryName";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryScopeForFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setMappings";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getLibrarySerializationName";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 27: 
            case 29: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getPredefinedLibraryPresentationName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getPredefinedLibrarySerializationName";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "disassociateWithProject";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isLibraryInScopeFor";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "containsLibraryName";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isAssociatedWithProject";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "iterateUp";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "forEachLibraryInScopeForFile";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "containsProjectLibraryName";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "containsLibrary";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "dependsOn";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getMappingsByLibraryName";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryScopeForFile";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "lambda$forEachLibraryInScopeForFile$1";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "lambda$isLibraryInScopeFor$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 27: 
            case 29: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyLibraryTableListener
    implements LibraryTable.Listener {
        private MyLibraryTableListener() {
        }

        @Override
        public void afterLibraryAdded(@NotNull Library newLibrary) {
            if (newLibrary == null) {
                MyLibraryTableListener.$$$reportNull$$$0(0);
            }
            ScriptingLibraryMappings.this.updateMappings();
        }

        @Override
        public void afterLibraryRenamed(@NotNull Library library) {
            if (library == null) {
                MyLibraryTableListener.$$$reportNull$$$0(1);
            }
            ScriptingLibraryMappings.this.updateMappings();
        }

        @Override
        public void afterLibraryRemoved(@NotNull Library library) {
            if (library == null) {
                MyLibraryTableListener.$$$reportNull$$$0(2);
            }
            ScriptingLibraryMappings.this.updateMappings();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newLibrary";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "library";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/webcore/libraries/ScriptingLibraryMappings$MyLibraryTableListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "afterLibraryAdded";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "afterLibraryRenamed";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "afterLibraryRemoved";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public class CompoundLibrary
    extends ScriptingLibraryModel {
        private final Map<String, ScriptingLibraryModel> myLibraries;
        private final Map<String, ScriptingLibraryModel> myOldLibraries;

        public CompoundLibrary() {
            super(null, null);
            this.myLibraries = new TreeMap<String, ScriptingLibraryModel>();
            this.myOldLibraries = new TreeMap<String, ScriptingLibraryModel>();
        }

        public void clearLibraries() {
            this.myOldLibraries.clear();
            this.myOldLibraries.putAll(this.myLibraries);
            this.myLibraries.clear();
        }

        public void toggleLibrary(@NotNull ScriptingLibraryModel library) {
            String libName;
            if (library == null) {
                CompoundLibrary.$$$reportNull$$$0(0);
            }
            if (this.myLibraries.containsKey(libName = library.getName())) {
                this.myLibraries.remove(libName);
                return;
            }
            this.myLibraries.put(libName, library);
        }

        private void addLibrary(@NotNull ScriptingLibraryModel library) {
            if (library == null) {
                CompoundLibrary.$$$reportNull$$$0(1);
            }
            String libName = library.getName();
            this.myLibraries.put(libName, library);
            this.applyChanges();
        }

        public boolean containsLibrary(String libName) {
            return this.myLibraries.containsKey(libName);
        }

        @Nullable
        public String serialize() {
            ArrayList names = ContainerUtil.newArrayList();
            for (ScriptingLibraryModel library : this.myLibraries.values()) {
                if (this.isPredefinedLibraryWithDefaultMappingsOrIncluded(library)) continue;
                names.add(ScriptingLibraryMappings.this.getLibrarySerializationName(library));
            }
            if (names.isEmpty()) {
                return null;
            }
            return "{" + StringUtil.join((Collection)names, (String)", ") + "}";
        }

        private boolean isPredefinedLibraryWithDefaultMappingsOrIncluded(@NotNull ScriptingLibraryModel model) {
            List<VirtualFile> mappings;
            if (model == null) {
                CompoundLibrary.$$$reportNull$$$0(2);
            }
            if (!model.isPredefined()) {
                return false;
            }
            List<VirtualFile> defaultMappings = model.getDefaultMappings();
            return defaultMappings.equals(mappings = ScriptingLibraryMappings.this.getMappingsByLibraryName(model.getName())) || defaultMappings.isEmpty() && ScriptingLibraryMappings.isAssociatedWithProject(mappings);
        }

        @Override
        @NotNull
        public String getName() {
            StringBuilder allNames = new StringBuilder();
            boolean isFirst = true;
            for (ScriptingLibraryModel library : this.myLibraries.values()) {
                allNames.append(isFirst ? "" : ", ");
                allNames.append(library.getName());
                isFirst = false;
            }
            String string = allNames.toString();
            if (string == null) {
                CompoundLibrary.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        public boolean containsFile(VirtualFile file) {
            for (ScriptingLibraryModel library : this.myLibraries.values()) {
                if (!library.containsFile(file)) continue;
                return true;
            }
            return false;
        }

        public Collection<ScriptingLibraryModel> getLibraries() {
            return this.myLibraries.values();
        }

        @Override
        public boolean isEmpty() {
            return this.myLibraries.isEmpty();
        }

        public int getLibraryCount() {
            return this.myLibraries.size();
        }

        public void applyChanges() {
            this.myOldLibraries.clear();
            this.myOldLibraries.putAll(this.myLibraries);
        }

        public boolean isModified() {
            if (this.myOldLibraries == null) {
                return false;
            }
            for (String libName : this.myLibraries.keySet()) {
                if (this.myOldLibraries.containsKey(libName)) continue;
                return true;
            }
            for (String libName : ArrayUtil.toStringArray(this.myOldLibraries.keySet())) {
                if (this.myLibraries.containsKey(libName)) continue;
                return true;
            }
            return false;
        }

        public void reset() {
            this.myLibraries.clear();
            this.myLibraries.putAll(this.myOldLibraries);
        }

        @Override
        @NotNull
        public Set<VirtualFile> getSourceFiles() {
            HashSet<VirtualFile> sourceFiles = new HashSet<VirtualFile>();
            for (ScriptingLibraryModel libModel : this.myLibraries.values()) {
                sourceFiles.addAll(libModel.getSourceFiles());
            }
            HashSet<VirtualFile> hashSet = sourceFiles;
            if (hashSet == null) {
                CompoundLibrary.$$$reportNull$$$0(4);
            }
            return hashSet;
        }

        @Override
        public Set<VirtualFile> getCompactFiles() {
            HashSet<VirtualFile> compactFiles = new HashSet<VirtualFile>();
            for (ScriptingLibraryModel libModel : this.myLibraries.values()) {
                compactFiles.addAll(libModel.getCompactFiles());
            }
            return compactFiles;
        }

        @Override
        public void addSignificantFiles(Collection<VirtualFile> result) {
            for (ScriptingLibraryModel libModel : this.myLibraries.values()) {
                libModel.addSignificantFiles(result);
            }
        }

        @Override
        public void collectFilesWithGlobalDefinitions(@NotNull Collection<VirtualFile> result) {
            if (result == null) {
                CompoundLibrary.$$$reportNull$$$0(5);
            }
            for (ScriptingLibraryModel libModel : this.myLibraries.values()) {
                libModel.collectFilesWithGlobalDefinitions(result);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "library";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/webcore/libraries/ScriptingLibraryMappings$CompoundLibrary";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/webcore/libraries/ScriptingLibraryMappings$CompoundLibrary";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSourceFiles";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "toggleLibrary";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "addLibrary";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isPredefinedLibraryWithDefaultMappingsOrIncluded";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "collectFilesWithGlobalDefinitions";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

