/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.initializr;

import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.SettingsStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleWithNameAlreadyExists;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.LanguageLevelModuleExtension;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.spring.boot.initializr.SpringInitializrApplicationInfoStep;
import com.intellij.spring.boot.initializr.SpringInitializrDownloader;
import com.intellij.spring.boot.initializr.SpringInitializrModuleBuilderPostTask;
import com.intellij.spring.boot.initializr.SpringInitializrOptions;
import com.intellij.spring.boot.initializr.SpringInitializrServiceChooserStep;
import com.intellij.spring.boot.initializr.dependencies.SpringInitializrDependenciesStep;
import icons.SpringBootApiIcons;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.JTextField;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringInitializrModuleBuilder
extends ModuleBuilder {
    private SpringInitializrOptions myOptions;
    private String myServiceUrl;

    public SpringInitializrOptions getOptions() {
        return this.myOptions;
    }

    void setOptions(SpringInitializrOptions options) {
        this.myOptions = options;
    }

    String getServiceUrl() {
        return this.myServiceUrl;
    }

    void setServiceUrl(String serviceUrl) {
        this.myServiceUrl = serviceUrl;
    }

    @Nullable
    public ModuleWizardStep modifySettingsStep(@NotNull SettingsStep settingsStep) {
        JTextField moduleNameField;
        if (settingsStep == null) {
            SpringInitializrModuleBuilder.$$$reportNull$$$0(0);
        }
        if ((moduleNameField = settingsStep.getModuleNameField()) != null) {
            moduleNameField.setText(this.myOptions.artifact);
        }
        return super.modifySettingsStep(settingsStep);
    }

    public ModuleWizardStep[] createWizardSteps(@NotNull WizardContext wizardContext, @NotNull ModulesProvider modulesProvider) {
        if (wizardContext == null) {
            SpringInitializrModuleBuilder.$$$reportNull$$$0(1);
        }
        if (modulesProvider == null) {
            SpringInitializrModuleBuilder.$$$reportNull$$$0(2);
        }
        return new ModuleWizardStep[]{new SpringInitializrApplicationInfoStep(this, wizardContext), new SpringInitializrDependenciesStep(this)};
    }

    @Nullable
    public ModuleWizardStep getCustomOptionsStep(WizardContext context, Disposable parentDisposable) {
        return new SpringInitializrServiceChooserStep(this);
    }

    @Nullable
    public String getBuilderId() {
        return "SpringInitializr";
    }

    public String getDescription() {
        return "Create <b>Spring Boot</b> applications using Spring Boot Starters.";
    }

    public String getPresentableName() {
        return "Spring Initializr";
    }

    public String getParentGroup() {
        return "Build Tools";
    }

    public int getWeight() {
        return 80;
    }

    public Icon getNodeIcon() {
        return SpringBootApiIcons.SpringBoot;
    }

    public ModuleType getModuleType() {
        return StdModuleTypes.JAVA;
    }

    public void setupRootModel(ModifiableRootModel modifiableRootModel) throws ConfigurationException {
        LanguageLevelModuleExtension moduleExt;
        Sdk sdk;
        Sdk sdk2 = sdk = this.getModuleJdk() != null ? this.getModuleJdk() : ProjectRootManager.getInstance((Project)modifiableRootModel.getProject()).getProjectSdk();
        if (sdk != null) {
            modifiableRootModel.setSdk(sdk);
        }
        if ((moduleExt = (LanguageLevelModuleExtension)modifiableRootModel.getModuleExtension(LanguageLevelModuleExtension.class)) != null && sdk != null) {
            SpringInitializrOptions.Option selected = (SpringInitializrOptions.Option)((Object)this.myOptions.javaVersion.getSelected());
            assert (selected != null);
            LanguageLevel parse = LanguageLevel.parse((String)selected.id);
            if (parse != null) {
                JavaSdkVersion javaSdkVersion = JavaSdkVersion.fromLanguageLevel((LanguageLevel)parse);
                JavaSdkVersion sdkJavaVersion = JavaSdk.getInstance().getVersion(sdk);
                if (sdkJavaVersion != null && sdkJavaVersion.isAtLeast(javaSdkVersion)) {
                    moduleExt.setLanguageLevel(parse);
                }
            }
        }
        this.doAddContentEntry(modifiableRootModel);
    }

    @NotNull
    public Module createModule(@NotNull ModifiableModuleModel moduleModel) throws InvalidDataException, IOException, ModuleWithNameAlreadyExists, JDOMException, ConfigurationException {
        if (moduleModel == null) {
            SpringInitializrModuleBuilder.$$$reportNull$$$0(3);
        }
        Module module = super.createModule(moduleModel);
        ApplicationManager.getApplication().invokeLater(() -> {
            ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
                try {
                    SpringInitializrDownloader downloader = new SpringInitializrDownloader(this);
                    downloader.execute(ProgressManager.getInstance().getProgressIndicator());
                }
                catch (IOException e) {
                    ApplicationManager.getApplication().invokeLater(() -> Messages.showErrorDialog((String)("Error: " + e.getMessage()), (String)"Spring Initializr"));
                }
            }, "Downloading Spring Initializr Template...", true, null);
            for (SpringInitializrModuleBuilderPostTask task : (SpringInitializrModuleBuilderPostTask[])SpringInitializrModuleBuilderPostTask.EXTENSION_POINT_NAME.getExtensions()) {
                if (task.runAfterSetup(module)) continue;
                return;
            }
        }, ModalityState.current());
        Module module2 = module;
        if (module2 == null) {
            SpringInitializrModuleBuilder.$$$reportNull$$$0(4);
        }
        return module2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsStep";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wizardContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modulesProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleModel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/initializr/SpringInitializrModuleBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/initializr/SpringInitializrModuleBuilder";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createModule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "modifySettingsStep";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createWizardSteps";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createModule";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

