/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.initializr.dependencies;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.ui.popup.IconButton;
import com.intellij.spring.boot.initializr.SpringInitializrOptions;
import com.intellij.spring.boot.initializr.Version;
import com.intellij.spring.boot.initializr.VersionRange;
import com.intellij.ui.HoverHyperlinkLabel;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.InplaceButton;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.UI;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

class SelectedDependenciesPanel
extends JPanel {
    private final List<SpringInitializrOptions.MultiSelectGroup> myDependencies;
    private StatusText myEmptyText;
    private JPanel mySelectedDependenciesPanel;
    private final MyActionListener myActionListener;

    SelectedDependenciesPanel(List<SpringInitializrOptions.MultiSelectGroup> dependencies, MyActionListener listener) {
        super(new BorderLayout());
        this.myDependencies = dependencies;
        this.myActionListener = listener;
        JLabel selectedDepsLabel = new JLabel("Selected Dependencies");
        selectedDepsLabel.setFont(UIUtil.getLabelFont().deriveFont(1));
        selectedDepsLabel.setBorder((Border)JBUI.Borders.empty((int)8, (int)0));
        this.add((Component)selectedDepsLabel, "North");
        this.mySelectedDependenciesPanel = new JPanel(new BorderLayout());
        this.mySelectedDependenciesPanel.setBackground(UIUtil.getListBackground());
        this.mySelectedDependenciesPanel.setBorder(JBUI.Borders.customLine((Color)JBColor.border()));
        this.add((Component)this.mySelectedDependenciesPanel, "Center");
    }

    void updateSelection(Version sbVersion, final Set<String> selectedDependenciesIds) {
        JPanel allDependencies = new JPanel((LayoutManager)new VerticalLayout(JBUI.scale((int)4))){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                SelectedDependenciesPanel.this.myEmptyText.paint((Component)this, g);
            }
        };
        allDependencies.setBorder(JBUI.Borders.empty((int)4));
        allDependencies.setBackground(UIUtil.getListBackground());
        for (final SpringInitializrOptions.MultiSelectGroup group : this.myDependencies) {
            if (!ContainerUtil.intersects(selectedDependenciesIds, (Collection)ContainerUtil.map(group.options, option -> option.id))) continue;
            JPanel groupPanel = new JPanel(new BorderLayout());
            groupPanel.setBackground(UIUtil.getListBackground());
            groupPanel.setBorder((Border)JBUI.Borders.emptyBottom((int)12));
            HoverHyperlinkLabel groupLabel = new HoverHyperlinkLabel(group.name, UI.getColor((String)"link.foreground"));
            groupLabel.setFont(UIUtil.getLabelFont().deriveFont(1));
            groupLabel.setBorder((Border)JBUI.Borders.emptyBottom((int)8));
            groupLabel.setToolTipText("Switch to category on the left");
            groupLabel.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

                protected void hyperlinkActivated(HyperlinkEvent e) {
                    SelectedDependenciesPanel.this.myActionListener.navigateCategory(group.name);
                }
            });
            groupPanel.add((Component)groupLabel, "North");
            JPanel groupDependencies = new JPanel((LayoutManager)new VerticalLayout(JBUI.scale((int)4)));
            groupDependencies.setBackground(UIUtil.getListBackground());
            groupDependencies.setBorder((Border)JBUI.Borders.empty((int)0, (int)20, (int)0, (int)10));
            for (final SpringInitializrOptions.Option option2 : group.options) {
                if (!selectedDependenciesIds.contains(option2.id)) continue;
                VersionRange versionRange = (VersionRange)option2.getUserData(SpringInitializrOptions.Option.VERSION_RANGE);
                boolean unavailable = versionRange != null && !versionRange.match(sbVersion);
                JLabel dependencyLabel = new JLabel(option2.display);
                dependencyLabel.setBorder((Border)JBUI.Borders.emptyBottom((int)4));
                if (unavailable) {
                    dependencyLabel.setEnabled(false);
                    dependencyLabel.setDisabledIcon(AllIcons.General.BalloonWarning);
                    dependencyLabel.setToolTipText("Requires Spring Boot Version " + versionRange.displayText());
                }
                InplaceButton removeDependencyButton = new InplaceButton(new IconButton("Remove", AllIcons.Modules.DeleteContentFolder, AllIcons.Modules.DeleteContentFolderRollover), new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SelectedDependenciesPanel.this.myActionListener.onDependencyDeleted(option2.id);
                    }
                });
                removeDependencyButton.setCursor(Cursor.getPredefinedCursor(12));
                removeDependencyButton.setTransform(0, -JBUI.scale((int)2));
                JPanel dependencyPanel = new JPanel(new BorderLayout());
                dependencyPanel.setBackground(UIUtil.getListBackground());
                dependencyPanel.add((Component)dependencyLabel, "West");
                dependencyPanel.add((Component)removeDependencyButton, "East");
                groupDependencies.add(dependencyPanel);
            }
            groupPanel.add((Component)groupDependencies, "Center");
            allDependencies.add((Component)groupPanel, "TOP");
        }
        JScrollPane allDependenciesScrollPane = ScrollPaneFactory.createScrollPane((Component)allDependencies, (boolean)true);
        this.mySelectedDependenciesPanel.removeAll();
        this.mySelectedDependenciesPanel.add((Component)allDependenciesScrollPane, "Center");
        this.mySelectedDependenciesPanel.revalidate();
        this.myEmptyText = new StatusText(allDependencies){

            protected boolean isStatusVisible() {
                return selectedDependenciesIds.isEmpty();
            }
        };
        this.myEmptyText.setText("Select dependencies on the left");
    }

    static interface MyActionListener {
        public void onDependencyDeleted(String var1);

        public void navigateCategory(String var1);
    }
}

