/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.log;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgFile;
import org.zmlx.hg4idea.HgFileRevision;
import org.zmlx.hg4idea.HgRevisionNumber;
import org.zmlx.hg4idea.log.HgBaseLogParser;
import org.zmlx.hg4idea.util.HgVersion;

public class HgFileRevisionLogParser
extends HgBaseLogParser<HgFileRevision> {
    private static final Logger LOG = Logger.getInstance(HgFileRevisionLogParser.class);
    @NotNull
    private final HgFile myHgFile;
    @NotNull
    private final Project myProject;
    @NotNull
    private HgVersion myVersion;

    public HgFileRevisionLogParser(@NotNull Project project, @NotNull HgFile hgFile, @NotNull HgVersion currentVersion) {
        if (project == null) {
            HgFileRevisionLogParser.$$$reportNull$$$0(0);
        }
        if (hgFile == null) {
            HgFileRevisionLogParser.$$$reportNull$$$0(1);
        }
        if (currentVersion == null) {
            HgFileRevisionLogParser.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.myHgFile = hgFile;
        this.myVersion = currentVersion;
    }

    @Override
    @Nullable
    protected HgFileRevision convertDetails(@NotNull String rev, @NotNull String changeset, @NotNull SmartList<HgRevisionNumber> parents, @NotNull Date revisionDate, @NotNull String author, @NotNull String email, @NotNull List<String> attributes) {
        String separator;
        if (rev == null) {
            HgFileRevisionLogParser.$$$reportNull$$$0(3);
        }
        if (changeset == null) {
            HgFileRevisionLogParser.$$$reportNull$$$0(4);
        }
        if (parents == null) {
            HgFileRevisionLogParser.$$$reportNull$$$0(5);
        }
        if (revisionDate == null) {
            HgFileRevisionLogParser.$$$reportNull$$$0(6);
        }
        if (author == null) {
            HgFileRevisionLogParser.$$$reportNull$$$0(7);
        }
        if (email == null) {
            HgFileRevisionLogParser.$$$reportNull$$$0(8);
        }
        if (attributes == null) {
            HgFileRevisionLogParser.$$$reportNull$$$0(9);
        }
        int numAttributes = attributes.size();
        String commitMessage = HgFileRevisionLogParser.parseAdditionalStringAttribute(attributes, 5);
        String branchName = HgFileRevisionLogParser.parseAdditionalStringAttribute(attributes, 6);
        HgRevisionNumber vcsRevisionNumber = new HgRevisionNumber(rev, changeset, author, email, commitMessage, (List<HgRevisionNumber>)parents);
        Set<String> filesAdded = Collections.emptySet();
        Set<String> filesModified = Collections.emptySet();
        Set<String> filesDeleted = Collections.emptySet();
        Map<String, String> copies = Collections.emptyMap();
        boolean shouldParseOldTemplate = !this.myVersion.isBuiltInFunctionSupported();
        String string = separator = shouldParseOldTemplate ? " " : "\u0001";
        if (numAttributes > 7) {
            filesAdded = HgFileRevisionLogParser.parseFileList(attributes.get(7), separator);
            if (numAttributes > 8) {
                filesModified = HgFileRevisionLogParser.parseFileList(attributes.get(8), separator);
                if (numAttributes > 9) {
                    filesDeleted = HgFileRevisionLogParser.parseFileList(attributes.get(9), separator);
                    if (numAttributes > 10) {
                        copies = shouldParseOldTemplate ? HgFileRevisionLogParser.parseCopiesFileListAsOldVersion(attributes.get(10)) : HgFileRevisionLogParser.parseCopiesFileList(attributes.get(10));
                        Iterator<String> keys = copies.keySet().iterator();
                        while (keys.hasNext()) {
                            String s = keys.next();
                            if (filesAdded.contains(copies.get(s)) && filesDeleted.contains(s)) {
                                filesAdded.remove(copies.get(s));
                                filesDeleted.remove(s);
                                continue;
                            }
                            if (filesDeleted.contains(s)) continue;
                            keys.remove();
                        }
                    }
                }
            }
        }
        return new HgFileRevision(this.myProject, this.myHgFile, vcsRevisionNumber, branchName, revisionDate, vcsRevisionNumber.getAuthor(), commitMessage, filesModified, filesAdded, filesDeleted, copies);
    }

    private static Set<String> parseFileList(@Nullable String fileListString, @NotNull String separator) {
        if (separator == null) {
            HgFileRevisionLogParser.$$$reportNull$$$0(10);
        }
        return StringUtil.isEmpty((String)fileListString) ? Collections.emptySet() : new HashSet(StringUtil.split((String)fileListString, (String)separator));
    }

    @NotNull
    static Map<String, String> parseCopiesFileList(@Nullable String fileListString) {
        if (StringUtil.isEmpty((String)fileListString)) {
            Map<String, String> map = Collections.emptyMap();
            if (map == null) {
                HgFileRevisionLogParser.$$$reportNull$$$0(11);
            }
            return map;
        }
        HashMap<String, String> copies = new HashMap<String, String>();
        List filesList = StringUtil.split((String)fileListString, (String)"\u0001");
        for (String pairOfFiles : filesList) {
            String[] files = pairOfFiles.split("\\s+\\(");
            if (files.length != 2) {
                LOG.info("Couldn't parse copied files: " + fileListString);
                HashMap<String, String> hashMap = copies;
                if (hashMap == null) {
                    HgFileRevisionLogParser.$$$reportNull$$$0(12);
                }
                return hashMap;
            }
            copies.put(files[1].substring(0, files[1].length() - 1), files[0]);
        }
        HashMap<String, String> hashMap = copies;
        if (hashMap == null) {
            HgFileRevisionLogParser.$$$reportNull$$$0(13);
        }
        return hashMap;
    }

    @NotNull
    static Map<String, String> parseCopiesFileListAsOldVersion(@Nullable String fileListString) {
        String source;
        int afterRightBraceIndex;
        if (StringUtil.isEmpty((String)fileListString)) {
            Map<String, String> map = Collections.emptyMap();
            if (map == null) {
                HgFileRevisionLogParser.$$$reportNull$$$0(14);
            }
            return map;
        }
        HashMap<String, String> copies = new HashMap<String, String>();
        String[] filesList = fileListString.split("\\s+\\(");
        String target = filesList[0];
        for (int i = 1; i < filesList.length && (afterRightBraceIndex = HgFileRevisionLogParser.findRightBracePosition(source = filesList[i])) != -1; ++i) {
            copies.put(source.substring(0, afterRightBraceIndex - 1), target);
            if (afterRightBraceIndex >= source.length()) break;
            target = source.substring(afterRightBraceIndex);
        }
        HashMap<String, String> hashMap = copies;
        if (hashMap == null) {
            HgFileRevisionLogParser.$$$reportNull$$$0(15);
        }
        return hashMap;
    }

    private static int findRightBracePosition(@NotNull String str) {
        if (str == null) {
            HgFileRevisionLogParser.$$$reportNull$$$0(16);
        }
        int len = str.length();
        int depth = 1;
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '(': {
                    ++depth;
                    break;
                }
                case ')': {
                    --depth;
                }
            }
            if (depth != 0) continue;
            return i + 1;
        }
        LOG.info("Unexpected output during parse copied files in log command " + str);
        return -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hgFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentVersion";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rev";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeset";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parents";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revisionDate";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "author";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "email";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/zmlx/hg4idea/log/HgFileRevisionLogParser";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/zmlx/hg4idea/log/HgFileRevisionLogParser";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "parseCopiesFileList";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "parseCopiesFileListAsOldVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "convertDetails";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "parseFileList";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findRightBracePosition";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

