/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCallbackWrapper;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattService;
import android.bluetooth.BluetoothProfile;
import android.bluetooth.IBluetoothGatt;
import android.bluetooth.IBluetoothGattCallback;
import android.content.Context;
import android.os.ParcelUuid;
import android.os.RemoteException;
import android.util.Log;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class BluetoothGatt
implements BluetoothProfile {
    private static final String TAG = "BluetoothGatt";
    private static final boolean DBG = true;
    private static final boolean VDBG = false;
    private final Context mContext;
    private IBluetoothGatt mService;
    private BluetoothGattCallback mCallback;
    private int mClientIf;
    private boolean mAuthRetry = false;
    private BluetoothDevice mDevice;
    private boolean mAutoConnect;
    private int mConnState;
    private final Object mStateLock = new Object();
    private Boolean mDeviceBusy = false;
    private int mTransport;
    private static final int CONN_STATE_IDLE = 0;
    private static final int CONN_STATE_CONNECTING = 1;
    private static final int CONN_STATE_CONNECTED = 2;
    private static final int CONN_STATE_DISCONNECTING = 3;
    private static final int CONN_STATE_CLOSED = 4;
    private List<BluetoothGattService> mServices;
    public static final int GATT_SUCCESS = 0;
    public static final int GATT_READ_NOT_PERMITTED = 2;
    public static final int GATT_WRITE_NOT_PERMITTED = 3;
    public static final int GATT_INSUFFICIENT_AUTHENTICATION = 5;
    public static final int GATT_REQUEST_NOT_SUPPORTED = 6;
    public static final int GATT_INSUFFICIENT_ENCRYPTION = 15;
    public static final int GATT_INVALID_OFFSET = 7;
    public static final int GATT_INVALID_ATTRIBUTE_LENGTH = 13;
    public static final int GATT_CONNECTION_CONGESTED = 143;
    public static final int GATT_FAILURE = 257;
    public static final int CONNECTION_PRIORITY_BALANCED = 0;
    public static final int CONNECTION_PRIORITY_HIGH = 1;
    public static final int CONNECTION_PRIORITY_LOW_POWER = 2;
    static final int AUTHENTICATION_NONE = 0;
    static final int AUTHENTICATION_NO_MITM = 1;
    static final int AUTHENTICATION_MITM = 2;
    private final IBluetoothGattCallback mBluetoothGattCallback = new BluetoothGattCallbackWrapper(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onClientRegistered(int status, int clientIf) {
            Log.d(BluetoothGatt.TAG, "onClientRegistered() - status=" + status + " clientIf=" + clientIf);
            BluetoothGatt.this.mClientIf = clientIf;
            if (status != 0) {
                BluetoothGatt.this.mCallback.onConnectionStateChange(BluetoothGatt.this, 257, 0);
                Object object = BluetoothGatt.this.mStateLock;
                synchronized (object) {
                    BluetoothGatt.this.mConnState = 0;
                }
                return;
            }
            try {
                BluetoothGatt.this.mService.clientConnect(BluetoothGatt.this.mClientIf, BluetoothGatt.this.mDevice.getAddress(), !BluetoothGatt.this.mAutoConnect, BluetoothGatt.this.mTransport);
            }
            catch (RemoteException e) {
                Log.e(BluetoothGatt.TAG, "", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onClientConnectionState(int status, int clientIf, boolean connected, String address) {
            Log.d(BluetoothGatt.TAG, "onClientConnectionState() - status=" + status + " clientIf=" + clientIf + " device=" + address);
            if (!address.equals(BluetoothGatt.this.mDevice.getAddress())) {
                return;
            }
            int profileState = connected ? 2 : 0;
            try {
                BluetoothGatt.this.mCallback.onConnectionStateChange(BluetoothGatt.this, status, profileState);
            }
            catch (Exception ex) {
                Log.w(BluetoothGatt.TAG, "Unhandled exception in callback", ex);
            }
            Object object = BluetoothGatt.this.mStateLock;
            synchronized (object) {
                if (connected) {
                    BluetoothGatt.this.mConnState = 2;
                } else {
                    BluetoothGatt.this.mConnState = 0;
                }
            }
            object = BluetoothGatt.this.mDeviceBusy;
            synchronized (object) {
                BluetoothGatt.this.mDeviceBusy = false;
            }
        }

        @Override
        public void onSearchComplete(String address, List<BluetoothGattService> services, int status) {
            Log.d(BluetoothGatt.TAG, "onSearchComplete() = Device=" + address + " Status=" + status);
            if (!address.equals(BluetoothGatt.this.mDevice.getAddress())) {
                return;
            }
            for (BluetoothGattService s : services) {
                s.setDevice(BluetoothGatt.this.mDevice);
            }
            BluetoothGatt.this.mServices.addAll(services);
            for (BluetoothGattService fixedService : BluetoothGatt.this.mServices) {
                ArrayList<BluetoothGattService> includedServices = new ArrayList<BluetoothGattService>(fixedService.getIncludedServices());
                fixedService.getIncludedServices().clear();
                for (BluetoothGattService brokenRef : includedServices) {
                    BluetoothGattService includedService = BluetoothGatt.this.getService(BluetoothGatt.this.mDevice, brokenRef.getUuid(), brokenRef.getInstanceId(), brokenRef.getType());
                    if (includedService != null) {
                        fixedService.addIncludedService(includedService);
                        continue;
                    }
                    Log.e(BluetoothGatt.TAG, "Broken GATT database: can't find included service.");
                }
            }
            try {
                BluetoothGatt.this.mCallback.onServicesDiscovered(BluetoothGatt.this, status);
            }
            catch (Exception ex) {
                Log.w(BluetoothGatt.TAG, "Unhandled exception in callback", ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCharacteristicRead(String address, int status, int handle, byte[] value) {
            Log.w(BluetoothGatt.TAG, "onCharacteristicRead() - Device=" + address + " handle=" + handle + " Status=" + status);
            if (!address.equals(BluetoothGatt.this.mDevice.getAddress())) {
                return;
            }
            Boolean bl = BluetoothGatt.this.mDeviceBusy;
            synchronized (bl) {
                BluetoothGatt.this.mDeviceBusy = false;
            }
            if (!(status != 5 && status != 15 || BluetoothGatt.this.mAuthRetry)) {
                try {
                    BluetoothGatt.this.mAuthRetry = true;
                    BluetoothGatt.this.mService.readCharacteristic(BluetoothGatt.this.mClientIf, address, handle, 2);
                    return;
                }
                catch (RemoteException e) {
                    Log.e(BluetoothGatt.TAG, "", e);
                }
            }
            BluetoothGatt.this.mAuthRetry = false;
            BluetoothGattCharacteristic characteristic = BluetoothGatt.this.getCharacteristicById(BluetoothGatt.this.mDevice, handle);
            if (characteristic == null) {
                Log.w(BluetoothGatt.TAG, "onCharacteristicRead() failed to find characteristic!");
                return;
            }
            if (status == 0) {
                characteristic.setValue(value);
            }
            try {
                BluetoothGatt.this.mCallback.onCharacteristicRead(BluetoothGatt.this, characteristic, status);
            }
            catch (Exception ex) {
                Log.w(BluetoothGatt.TAG, "Unhandled exception in callback", ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCharacteristicWrite(String address, int status, int handle) {
            if (!address.equals(BluetoothGatt.this.mDevice.getAddress())) {
                return;
            }
            Boolean bl = BluetoothGatt.this.mDeviceBusy;
            synchronized (bl) {
                BluetoothGatt.this.mDeviceBusy = false;
            }
            BluetoothGattCharacteristic characteristic = BluetoothGatt.this.getCharacteristicById(BluetoothGatt.this.mDevice, handle);
            if (characteristic == null) {
                return;
            }
            if (!(status != 5 && status != 15 || BluetoothGatt.this.mAuthRetry)) {
                try {
                    BluetoothGatt.this.mAuthRetry = true;
                    BluetoothGatt.this.mService.writeCharacteristic(BluetoothGatt.this.mClientIf, address, handle, characteristic.getWriteType(), 2, characteristic.getValue());
                    return;
                }
                catch (RemoteException e) {
                    Log.e(BluetoothGatt.TAG, "", e);
                }
            }
            BluetoothGatt.this.mAuthRetry = false;
            try {
                BluetoothGatt.this.mCallback.onCharacteristicWrite(BluetoothGatt.this, characteristic, status);
            }
            catch (Exception ex) {
                Log.w(BluetoothGatt.TAG, "Unhandled exception in callback", ex);
            }
        }

        @Override
        public void onNotify(String address, int handle, byte[] value) {
            if (!address.equals(BluetoothGatt.this.mDevice.getAddress())) {
                return;
            }
            BluetoothGattCharacteristic characteristic = BluetoothGatt.this.getCharacteristicById(BluetoothGatt.this.mDevice, handle);
            if (characteristic == null) {
                return;
            }
            characteristic.setValue(value);
            try {
                BluetoothGatt.this.mCallback.onCharacteristicChanged(BluetoothGatt.this, characteristic);
            }
            catch (Exception ex) {
                Log.w(BluetoothGatt.TAG, "Unhandled exception in callback", ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onDescriptorRead(String address, int status, int handle, byte[] value) {
            if (!address.equals(BluetoothGatt.this.mDevice.getAddress())) {
                return;
            }
            Boolean bl = BluetoothGatt.this.mDeviceBusy;
            synchronized (bl) {
                BluetoothGatt.this.mDeviceBusy = false;
            }
            BluetoothGattDescriptor descriptor = BluetoothGatt.this.getDescriptorById(BluetoothGatt.this.mDevice, handle);
            if (descriptor == null) {
                return;
            }
            if (status == 0) {
                descriptor.setValue(value);
            }
            if (!(status != 5 && status != 15 || BluetoothGatt.this.mAuthRetry)) {
                try {
                    BluetoothGatt.this.mAuthRetry = true;
                    BluetoothGatt.this.mService.readDescriptor(BluetoothGatt.this.mClientIf, address, handle, 2);
                    return;
                }
                catch (RemoteException e) {
                    Log.e(BluetoothGatt.TAG, "", e);
                }
            }
            BluetoothGatt.this.mAuthRetry = true;
            try {
                BluetoothGatt.this.mCallback.onDescriptorRead(BluetoothGatt.this, descriptor, status);
            }
            catch (Exception ex) {
                Log.w(BluetoothGatt.TAG, "Unhandled exception in callback", ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onDescriptorWrite(String address, int status, int handle) {
            if (!address.equals(BluetoothGatt.this.mDevice.getAddress())) {
                return;
            }
            Boolean bl = BluetoothGatt.this.mDeviceBusy;
            synchronized (bl) {
                BluetoothGatt.this.mDeviceBusy = false;
            }
            BluetoothGattDescriptor descriptor = BluetoothGatt.this.getDescriptorById(BluetoothGatt.this.mDevice, handle);
            if (descriptor == null) {
                return;
            }
            if (!(status != 5 && status != 15 || BluetoothGatt.this.mAuthRetry)) {
                try {
                    BluetoothGatt.this.mAuthRetry = true;
                    BluetoothGatt.this.mService.writeDescriptor(BluetoothGatt.this.mClientIf, address, handle, 2, 2, descriptor.getValue());
                    return;
                }
                catch (RemoteException e) {
                    Log.e(BluetoothGatt.TAG, "", e);
                }
            }
            BluetoothGatt.this.mAuthRetry = false;
            try {
                BluetoothGatt.this.mCallback.onDescriptorWrite(BluetoothGatt.this, descriptor, status);
            }
            catch (Exception ex) {
                Log.w(BluetoothGatt.TAG, "Unhandled exception in callback", ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onExecuteWrite(String address, int status) {
            if (!address.equals(BluetoothGatt.this.mDevice.getAddress())) {
                return;
            }
            Boolean bl = BluetoothGatt.this.mDeviceBusy;
            synchronized (bl) {
                BluetoothGatt.this.mDeviceBusy = false;
            }
            try {
                BluetoothGatt.this.mCallback.onReliableWriteCompleted(BluetoothGatt.this, status);
            }
            catch (Exception ex) {
                Log.w(BluetoothGatt.TAG, "Unhandled exception in callback", ex);
            }
        }

        @Override
        public void onReadRemoteRssi(String address, int rssi, int status) {
            if (!address.equals(BluetoothGatt.this.mDevice.getAddress())) {
                return;
            }
            try {
                BluetoothGatt.this.mCallback.onReadRemoteRssi(BluetoothGatt.this, rssi, status);
            }
            catch (Exception ex) {
                Log.w(BluetoothGatt.TAG, "Unhandled exception in callback", ex);
            }
        }

        @Override
        public void onConfigureMTU(String address, int mtu, int status) {
            Log.d(BluetoothGatt.TAG, "onConfigureMTU() - Device=" + address + " mtu=" + mtu + " status=" + status);
            if (!address.equals(BluetoothGatt.this.mDevice.getAddress())) {
                return;
            }
            try {
                BluetoothGatt.this.mCallback.onMtuChanged(BluetoothGatt.this, mtu, status);
            }
            catch (Exception ex) {
                Log.w(BluetoothGatt.TAG, "Unhandled exception in callback", ex);
            }
        }
    };

    BluetoothGatt(Context context, IBluetoothGatt iGatt, BluetoothDevice device, int transport) {
        this.mContext = context;
        this.mService = iGatt;
        this.mDevice = device;
        this.mTransport = transport;
        this.mServices = new ArrayList<BluetoothGattService>();
        this.mConnState = 0;
    }

    public void close() {
        Log.d(TAG, "close()");
        this.unregisterApp();
        this.mConnState = 4;
    }

    BluetoothGattService getService(BluetoothDevice device, UUID uuid, int instanceId, int type) {
        for (BluetoothGattService svc : this.mServices) {
            if (!svc.getDevice().equals(device) || svc.getType() != type || svc.getInstanceId() != instanceId || !svc.getUuid().equals(uuid)) continue;
            return svc;
        }
        return null;
    }

    BluetoothGattCharacteristic getCharacteristicById(BluetoothDevice device, int instanceId) {
        for (BluetoothGattService svc : this.mServices) {
            for (BluetoothGattCharacteristic charac : svc.getCharacteristics()) {
                if (charac.getInstanceId() != instanceId) continue;
                return charac;
            }
        }
        return null;
    }

    BluetoothGattDescriptor getDescriptorById(BluetoothDevice device, int instanceId) {
        for (BluetoothGattService svc : this.mServices) {
            for (BluetoothGattCharacteristic charac : svc.getCharacteristics()) {
                for (BluetoothGattDescriptor desc : charac.getDescriptors()) {
                    if (desc.getInstanceId() != instanceId) continue;
                    return desc;
                }
            }
        }
        return null;
    }

    private boolean registerApp(BluetoothGattCallback callback) {
        Log.d(TAG, "registerApp()");
        if (this.mService == null) {
            return false;
        }
        this.mCallback = callback;
        UUID uuid = UUID.randomUUID();
        Log.d(TAG, "registerApp() - UUID=" + uuid);
        try {
            this.mService.registerClient(new ParcelUuid(uuid), this.mBluetoothGattCallback);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
        return true;
    }

    private void unregisterApp() {
        Log.d(TAG, "unregisterApp() - mClientIf=" + this.mClientIf);
        if (this.mService == null || this.mClientIf == 0) {
            return;
        }
        try {
            this.mCallback = null;
            this.mService.unregisterClient(this.mClientIf);
            this.mClientIf = 0;
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean connect(Boolean autoConnect, BluetoothGattCallback callback) {
        Log.d(TAG, "connect() - device: " + this.mDevice.getAddress() + ", auto: " + autoConnect);
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mConnState != 0) {
                throw new IllegalStateException("Not idle");
            }
            this.mConnState = 1;
        }
        this.mAutoConnect = autoConnect;
        if (!this.registerApp(callback)) {
            object = this.mStateLock;
            synchronized (object) {
                this.mConnState = 0;
            }
            Log.e(TAG, "Failed to register callback");
            return false;
        }
        return true;
    }

    public void disconnect() {
        Log.d(TAG, "cancelOpen() - device: " + this.mDevice.getAddress());
        if (this.mService == null || this.mClientIf == 0) {
            return;
        }
        try {
            this.mService.clientDisconnect(this.mClientIf, this.mDevice.getAddress());
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
        }
    }

    public boolean connect() {
        try {
            this.mService.clientConnect(this.mClientIf, this.mDevice.getAddress(), false, this.mTransport);
            return true;
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
    }

    public BluetoothDevice getDevice() {
        return this.mDevice;
    }

    public boolean discoverServices() {
        Log.d(TAG, "discoverServices() - device: " + this.mDevice.getAddress());
        if (this.mService == null || this.mClientIf == 0) {
            return false;
        }
        this.mServices.clear();
        try {
            this.mService.discoverServices(this.mClientIf, this.mDevice.getAddress());
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
        return true;
    }

    public List<BluetoothGattService> getServices() {
        ArrayList<BluetoothGattService> result = new ArrayList<BluetoothGattService>();
        for (BluetoothGattService service : this.mServices) {
            if (!service.getDevice().equals(this.mDevice)) continue;
            result.add(service);
        }
        return result;
    }

    public BluetoothGattService getService(UUID uuid) {
        for (BluetoothGattService service : this.mServices) {
            if (!service.getDevice().equals(this.mDevice) || !service.getUuid().equals(uuid)) continue;
            return service;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean readCharacteristic(BluetoothGattCharacteristic characteristic) {
        if ((characteristic.getProperties() & 2) == 0) {
            return false;
        }
        if (this.mService == null || this.mClientIf == 0) {
            return false;
        }
        BluetoothGattService service = characteristic.getService();
        if (service == null) {
            return false;
        }
        BluetoothDevice device = service.getDevice();
        if (device == null) {
            return false;
        }
        Boolean bl = this.mDeviceBusy;
        synchronized (bl) {
            if (this.mDeviceBusy.booleanValue()) {
                return false;
            }
            this.mDeviceBusy = true;
        }
        try {
            this.mService.readCharacteristic(this.mClientIf, device.getAddress(), characteristic.getInstanceId(), 0);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            this.mDeviceBusy = false;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeCharacteristic(BluetoothGattCharacteristic characteristic) {
        if ((characteristic.getProperties() & 8) == 0 && (characteristic.getProperties() & 4) == 0) {
            return false;
        }
        if (this.mService == null || this.mClientIf == 0 || characteristic.getValue() == null) {
            return false;
        }
        BluetoothGattService service = characteristic.getService();
        if (service == null) {
            return false;
        }
        BluetoothDevice device = service.getDevice();
        if (device == null) {
            return false;
        }
        Boolean bl = this.mDeviceBusy;
        synchronized (bl) {
            if (this.mDeviceBusy.booleanValue()) {
                return false;
            }
            this.mDeviceBusy = true;
        }
        try {
            this.mService.writeCharacteristic(this.mClientIf, device.getAddress(), characteristic.getInstanceId(), characteristic.getWriteType(), 0, characteristic.getValue());
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            this.mDeviceBusy = false;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean readDescriptor(BluetoothGattDescriptor descriptor) {
        if (this.mService == null || this.mClientIf == 0) {
            return false;
        }
        BluetoothGattCharacteristic characteristic = descriptor.getCharacteristic();
        if (characteristic == null) {
            return false;
        }
        BluetoothGattService service = characteristic.getService();
        if (service == null) {
            return false;
        }
        BluetoothDevice device = service.getDevice();
        if (device == null) {
            return false;
        }
        Boolean bl = this.mDeviceBusy;
        synchronized (bl) {
            if (this.mDeviceBusy.booleanValue()) {
                return false;
            }
            this.mDeviceBusy = true;
        }
        try {
            this.mService.readDescriptor(this.mClientIf, device.getAddress(), descriptor.getInstanceId(), 0);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            this.mDeviceBusy = false;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeDescriptor(BluetoothGattDescriptor descriptor) {
        if (this.mService == null || this.mClientIf == 0 || descriptor.getValue() == null) {
            return false;
        }
        BluetoothGattCharacteristic characteristic = descriptor.getCharacteristic();
        if (characteristic == null) {
            return false;
        }
        BluetoothGattService service = characteristic.getService();
        if (service == null) {
            return false;
        }
        BluetoothDevice device = service.getDevice();
        if (device == null) {
            return false;
        }
        Boolean bl = this.mDeviceBusy;
        synchronized (bl) {
            if (this.mDeviceBusy.booleanValue()) {
                return false;
            }
            this.mDeviceBusy = true;
        }
        try {
            this.mService.writeDescriptor(this.mClientIf, device.getAddress(), descriptor.getInstanceId(), 2, 0, descriptor.getValue());
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            this.mDeviceBusy = false;
            return false;
        }
        return true;
    }

    public boolean beginReliableWrite() {
        if (this.mService == null || this.mClientIf == 0) {
            return false;
        }
        try {
            this.mService.beginReliableWrite(this.mClientIf, this.mDevice.getAddress());
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeReliableWrite() {
        if (this.mService == null || this.mClientIf == 0) {
            return false;
        }
        Boolean bl = this.mDeviceBusy;
        synchronized (bl) {
            if (this.mDeviceBusy.booleanValue()) {
                return false;
            }
            this.mDeviceBusy = true;
        }
        try {
            this.mService.endReliableWrite(this.mClientIf, this.mDevice.getAddress(), true);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            this.mDeviceBusy = false;
            return false;
        }
        return true;
    }

    public void abortReliableWrite() {
        if (this.mService == null || this.mClientIf == 0) {
            return;
        }
        try {
            this.mService.endReliableWrite(this.mClientIf, this.mDevice.getAddress(), false);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
        }
    }

    public void abortReliableWrite(BluetoothDevice mDevice) {
        this.abortReliableWrite();
    }

    public boolean setCharacteristicNotification(BluetoothGattCharacteristic characteristic, boolean enable) {
        Log.d(TAG, "setCharacteristicNotification() - uuid: " + characteristic.getUuid() + " enable: " + enable);
        if (this.mService == null || this.mClientIf == 0) {
            return false;
        }
        BluetoothGattService service = characteristic.getService();
        if (service == null) {
            return false;
        }
        BluetoothDevice device = service.getDevice();
        if (device == null) {
            return false;
        }
        try {
            this.mService.registerForNotification(this.mClientIf, device.getAddress(), characteristic.getInstanceId(), enable);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
        return true;
    }

    public boolean refresh() {
        Log.d(TAG, "refresh() - device: " + this.mDevice.getAddress());
        if (this.mService == null || this.mClientIf == 0) {
            return false;
        }
        try {
            this.mService.refreshDevice(this.mClientIf, this.mDevice.getAddress());
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
        return true;
    }

    public boolean readRemoteRssi() {
        Log.d(TAG, "readRssi() - device: " + this.mDevice.getAddress());
        if (this.mService == null || this.mClientIf == 0) {
            return false;
        }
        try {
            this.mService.readRemoteRssi(this.mClientIf, this.mDevice.getAddress());
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
        return true;
    }

    public boolean requestMtu(int mtu) {
        Log.d(TAG, "configureMTU() - device: " + this.mDevice.getAddress() + " mtu: " + mtu);
        if (this.mService == null || this.mClientIf == 0) {
            return false;
        }
        try {
            this.mService.configureMTU(this.mClientIf, this.mDevice.getAddress(), mtu);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
        return true;
    }

    public boolean requestConnectionPriority(int connectionPriority) {
        if (connectionPriority < 0 || connectionPriority > 2) {
            throw new IllegalArgumentException("connectionPriority not within valid range");
        }
        Log.d(TAG, "requestConnectionPriority() - params: " + connectionPriority);
        if (this.mService == null || this.mClientIf == 0) {
            return false;
        }
        try {
            this.mService.connectionParameterUpdate(this.mClientIf, this.mDevice.getAddress(), connectionPriority);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
        return true;
    }

    @Override
    public int getConnectionState(BluetoothDevice device) {
        throw new UnsupportedOperationException("Use BluetoothManager#getConnectionState instead.");
    }

    @Override
    public List<BluetoothDevice> getConnectedDevices() {
        throw new UnsupportedOperationException("Use BluetoothManager#getConnectedDevices instead.");
    }

    @Override
    public List<BluetoothDevice> getDevicesMatchingConnectionStates(int[] states) {
        throw new UnsupportedOperationException("Use BluetoothManager#getDevicesMatchingConnectionStates instead.");
    }
}

