/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.ext.uml;

import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.VisibilityLevel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.ext.uml.MavenElement;
import org.jetbrains.idea.maven.ext.uml.MavenUmlDataKeys;
import org.jetbrains.idea.maven.ext.uml.MavenUmlEdge;
import org.jetbrains.idea.maven.ext.uml.MavenUmlNode;
import org.jetbrains.idea.maven.ext.uml.MavenUmlNodeHighlighter;
import org.jetbrains.idea.maven.ext.uml.MavenUmlProvider;
import org.jetbrains.idea.maven.ext.uml.MavenUmlVisibilityManager;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenArtifactNode;
import org.jetbrains.idea.maven.model.MavenArtifactState;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenArtifactScope;

public class MavenUmlDataModel
extends DiagramDataModel<MavenElement> {
    private final MavenElement myElement;
    private ArrayList<DiagramNode<MavenElement>> myNodes = new ArrayList();
    private Map<MavenArtifact, MavenUmlNode> myArtifactsNodes = new IdentityHashMap<MavenArtifact, MavenUmlNode>();
    private ArrayList<DiagramEdge<MavenElement>> myEdges = new ArrayList();
    private MavenUmlNode myRoot;
    private Map<MavenUmlNode, List<MavenUmlEdge>> conflicted = new HashMap<MavenUmlNode, List<MavenUmlEdge>>();
    private Map<MavenUmlNode, List<MavenUmlEdge>> duplicated = new HashMap<MavenUmlNode, List<MavenUmlEdge>>();
    private VisibilityLevel myVisibility;

    public MavenUmlDataModel(Project project, MavenElement element) {
        super(project, DiagramProvider.findByID((String)"MAVEN"));
        this.myElement = element;
    }

    public void refreshDataModel() {
        this.myNodes.clear();
        this.myArtifactsNodes.clear();
        this.myEdges.clear();
        this.conflicted.clear();
        this.duplicated.clear();
        this.myVisibility = this.getVisibilityManager().getCurrentVisibilityLevel();
        this.myRoot = new MavenUmlNode(this.myElement);
        this.addNodesRecursively(this.myRoot);
        this.addConflictEdges();
        this.addDuplicatedEdges();
    }

    private void addConflictEdges() {
        MavenUmlNodeHighlighter highlighter = MavenUmlProvider.getInstance().getExtras().getNodeHighlighter();
        if (highlighter != null) {
            for (MavenUmlNode node : this.conflicted.keySet()) {
                List nodes = highlighter.onNodeSelected(Collections.singletonList(node), this);
                if (nodes == null) continue;
                for (DiagramNode to : nodes) {
                    to.putUserData(MavenUmlDataKeys.CONFLICTED_WITH, (Object)node);
                    if (to == node) continue;
                    MavenUmlEdge e = new MavenUmlEdge(node, (MavenUmlNode)to, MavenArtifactState.CONFLICT);
                    this.conflicted.get((Object)node).add(e);
                }
            }
        }
    }

    private void addDuplicatedEdges() {
        MavenUmlNodeHighlighter highlighter = MavenUmlProvider.getInstance().getExtras().getNodeHighlighter();
        if (highlighter != null) {
            for (MavenUmlNode node : this.duplicated.keySet()) {
                List nodes = highlighter.onNodeSelected(Collections.singletonList(node), this);
                if (nodes == null) continue;
                for (DiagramNode to : nodes) {
                    to.putUserData(MavenUmlDataKeys.DUPLICATED_WITH, (Object)node);
                    if (to == node) continue;
                    MavenUmlEdge e = new MavenUmlEdge(node, (MavenUmlNode)to, MavenArtifactState.DUPLICATE);
                    this.duplicated.get((Object)node).add(e);
                }
            }
        }
    }

    private void addNodesRecursively(@NotNull MavenUmlNode root) {
        if (root == null) {
            MavenUmlDataModel.$$$reportNull$$$0(0);
        }
        ArrayList<Pair<MavenUmlNode, MavenElement>> duplicates = new ArrayList<Pair<MavenUmlNode, MavenElement>>();
        this.addNodesRecursively(root, duplicates);
        for (Pair<MavenUmlNode, MavenElement> duplicate : duplicates) {
            MavenUmlNode to = this.findOriginNode((MavenElement)duplicate.second);
            if (to == null) continue;
            this.myEdges.add((DiagramEdge<MavenElement>)new MavenUmlEdge((MavenUmlNode)((Object)duplicate.first), to));
        }
    }

    private void addNodesRecursively(@NotNull MavenUmlNode node, @NotNull List<Pair<MavenUmlNode, MavenElement>> duplicates) {
        if (node == null) {
            MavenUmlDataModel.$$$reportNull$$$0(1);
        }
        if (duplicates == null) {
            MavenUmlDataModel.$$$reportNull$$$0(2);
        }
        this.addNode(node);
        MavenElement mavenElement = node.getIdentifyingElement();
        MavenArtifactState state = mavenElement.getState();
        if (state == MavenArtifactState.CONFLICT) {
            this.conflicted.put(node, new ArrayList());
        } else if (state == MavenArtifactState.DUPLICATE) {
            this.duplicated.put(node, new ArrayList());
        }
        for (MavenElement child : mavenElement.getChildren()) {
            if (!MavenUmlDataModel.suite(child.getScope(), this.myVisibility)) continue;
            boolean addChildren = true;
            MavenUmlNode to = null;
            if (child.getState() == MavenArtifactState.DUPLICATE) {
                to = this.findOriginNode(child);
                if (to == null) {
                    duplicates.add((Pair<MavenUmlNode, MavenElement>)Pair.create((Object)((Object)node), (Object)child));
                    continue;
                }
                addChildren = false;
            }
            if (to == null) {
                if (this.isRootNodeElement(child)) {
                    to = this.myRoot;
                    addChildren = false;
                } else {
                    to = new MavenUmlNode(child);
                }
            }
            this.myEdges.add((DiagramEdge<MavenElement>)new MavenUmlEdge(node, to));
            if (!addChildren) continue;
            this.addNodesRecursively(to, duplicates);
        }
    }

    private void addNode(@NotNull MavenUmlNode node) {
        if (node == null) {
            MavenUmlDataModel.$$$reportNull$$$0(3);
        }
        this.myNodes.add((DiagramNode<MavenElement>)node);
        MavenArtifactNode mavenArtifactNode = node.getIdentifyingElement().getArtifact();
        if (mavenArtifactNode != null) {
            ContainerUtil.putIfNotNull((Object)mavenArtifactNode.getArtifact(), (Object)((Object)node), this.myArtifactsNodes);
        }
    }

    private boolean isRootNodeElement(MavenElement mavenElement) {
        MavenArtifactNode artifactNode = mavenElement.getArtifact();
        if (artifactNode == null) {
            return false;
        }
        MavenArtifact artifact = artifactNode.getArtifact();
        if (artifact == null) {
            return false;
        }
        String path = artifact.getFile().getPath();
        return FileUtil.pathsEqual((String)this.myElement.getMavenProject().getFile().getPath(), (String)path);
    }

    @Nullable
    private MavenUmlNode findOriginNode(MavenElement mavenElement) {
        MavenArtifactNode childArtifact = mavenElement.getArtifact();
        if (childArtifact == null) {
            return null;
        }
        MavenArtifact relatedArtifact = childArtifact.getRelatedArtifact();
        if (relatedArtifact == null) {
            return null;
        }
        return this.myArtifactsNodes.get(relatedArtifact);
    }

    private static boolean suite(MavenArtifactScope scope, VisibilityLevel visibility) {
        if (visibility == MavenUmlVisibilityManager.ALL || scope == null) {
            return true;
        }
        switch (scope) {
            case COMPILE: {
                return visibility == MavenUmlVisibilityManager.COMPILE;
            }
            case PROVIDED: {
                return visibility == MavenUmlVisibilityManager.PROVIDED;
            }
            case RUNTIME: {
                return visibility == MavenUmlVisibilityManager.RUNTIME;
            }
            case TEST: {
                return visibility == MavenUmlVisibilityManager.TEST;
            }
        }
        return false;
    }

    @NotNull
    public Collection<DiagramNode<MavenElement>> getNodes() {
        ArrayList<DiagramNode<MavenElement>> arrayList = this.myNodes;
        if (arrayList == null) {
            MavenUmlDataModel.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @NotNull
    public Collection<DiagramEdge<MavenElement>> getEdges() {
        ArrayList<DiagramEdge<MavenElement>> arrayList = this.myEdges;
        if (arrayList == null) {
            MavenUmlDataModel.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @NotNull
    public String getNodeName(DiagramNode<MavenElement> n) {
        String string = ((MavenElement)n.getIdentifyingElement()).getName();
        if (string == null) {
            MavenUmlDataModel.$$$reportNull$$$0(6);
        }
        return string;
    }

    public DiagramNode<MavenElement> addElement(MavenElement element) {
        MavenUmlNode node;
        if (element != null && !this.myNodes.contains((Object)(node = new MavenUmlNode(element)))) {
            this.addNode(node);
            return node;
        }
        return null;
    }

    @NotNull
    public ModificationTracker getModificationTracker() {
        ModificationTracker modificationTracker = MavenProjectsManager.getInstance((Project)this.getProject()).getModificationTracker();
        if (modificationTracker == null) {
            MavenUmlDataModel.$$$reportNull$$$0(7);
        }
        return modificationTracker;
    }

    public void dispose() {
    }

    public MavenUmlNode getRoot() {
        return this.myRoot;
    }

    @Nullable
    public List<MavenUmlEdge> getConflictedEdgesForNode(MavenUmlNode node) {
        MavenUmlNode parent = (MavenUmlNode)((Object)node.getUserData(MavenUmlDataKeys.CONFLICTED_WITH));
        if (parent != null) {
            return this.conflicted.get((Object)parent);
        }
        return null;
    }

    @Nullable
    public List<MavenUmlEdge> getDuplicatedEdgesForNode(MavenUmlNode node) {
        MavenUmlNode parent = (MavenUmlNode)((Object)node.getUserData(MavenUmlDataKeys.DUPLICATED_WITH));
        if (parent != null) {
            return this.duplicated.get((Object)parent);
        }
        return null;
    }

    public void addConflicted(MavenUmlEdge edge) {
        this.myEdges.add((DiagramEdge<MavenElement>)edge);
    }

    public void addDuplicated(MavenUmlEdge edge) {
        this.myEdges.add((DiagramEdge<MavenElement>)edge);
    }

    public void removeAllExtraEdges() {
        for (List<MavenUmlEdge> edges : this.conflicted.values()) {
            this.myEdges.removeAll(edges);
        }
        for (List<MavenUmlEdge> edges : this.duplicated.values()) {
            this.myEdges.removeAll(edges);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "duplicates";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/ext/uml/MavenUmlDataModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/ext/uml/MavenUmlDataModel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodes";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdges";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getModificationTracker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addNodesRecursively";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addNode";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

