/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.lang.references;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiPolyVariantReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.lang.index.MarkdownHeadersIndex;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownHeaderImpl;
import org.intellij.plugins.markdown.lang.references.MarkdownAnchorReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u001f2\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u00022\u00020\u0004:\u0001\u001fB)\b\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0011\u001a\u00020\u0006H\u0016J\b\u0010\u0012\u001a\u00020\u0003H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0006H\u0016J\u0013\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0016\u00a2\u0006\u0002\u0010\u0019J\u001b\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00172\u0006\u0010\u001c\u001a\u00020\u001dH\u0016\u00a2\u0006\u0002\u0010\u001eR\u0016\u0010\r\u001a\u0004\u0018\u00010\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/intellij/plugins/markdown/lang/references/MarkdownAnchorReferenceImpl;", "Lorg/intellij/plugins/markdown/lang/references/MarkdownAnchorReference;", "Lcom/intellij/psi/PsiPolyVariantReferenceBase;", "Lcom/intellij/psi/PsiElement;", "Lcom/intellij/codeInsight/daemon/EmptyResolveMessageProvider;", "myAnchor", "", "myFileReference", "Lcom/intellij/psi/impl/source/resolve/reference/impl/providers/FileReference;", "myPsiElement", "myOffset", "", "(Ljava/lang/String;Lcom/intellij/psi/impl/source/resolve/reference/impl/providers/FileReference;Lcom/intellij/psi/PsiElement;I)V", "file", "Lcom/intellij/psi/PsiFile;", "getFile", "()Lcom/intellij/psi/PsiFile;", "getCanonicalText", "getElement", "getRangeInElement", "Lcom/intellij/openapi/util/TextRange;", "getUnresolvedMessagePattern", "getVariants", "", "", "()[Ljava/lang/Object;", "multiResolve", "Lcom/intellij/psi/ResolveResult;", "incompleteCode", "", "(Z)[Lcom/intellij/psi/ResolveResult;", "Companion", "markdown"})
public final class MarkdownAnchorReferenceImpl
extends PsiPolyVariantReferenceBase<PsiElement>
implements MarkdownAnchorReference,
EmptyResolveMessageProvider {
    private final String myAnchor;
    private final FileReference myFileReference;
    private final PsiElement myPsiElement;
    private final int myOffset;
    public static final Companion Companion = new Companion(null);

    private final PsiFile getFile() {
        PsiFile psiFile;
        if (this.myFileReference != null) {
            PsiFileSystemItem psiFileSystemItem = this.myFileReference.resolve();
            if (!(psiFileSystemItem instanceof PsiFile)) {
                psiFileSystemItem = null;
            }
            psiFile = (PsiFile)psiFileSystemItem;
        } else {
            psiFile = this.myPsiElement.getContainingFile().getOriginalFile();
        }
        return psiFile;
    }

    @NotNull
    public PsiElement getElement() {
        return this.myPsiElement;
    }

    @NotNull
    public TextRange getRangeInElement() {
        return new TextRange(this.myOffset, this.myOffset + this.myAnchor.length());
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        String it;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        Collection headers;
        CharSequence charSequence = this.myAnchor;
        if (charSequence.length() == 0) {
            ResolveResult[] resolveResultArray = PsiElementResolveResult.createResults((PsiElement[])new PsiElement[]{this.myPsiElement});
            Intrinsics.checkExpressionValueIsNotNull((Object)resolveResultArray, (String)"PsiElementResolveResult.\u2026eateResults(myPsiElement)");
            return resolveResultArray;
        }
        Project project = this.myPsiElement.getProject();
        String suggestedHeader = StringUtil.replace((String)this.getCanonicalText(), (String)"-", (String)" ");
        String string = StringUtil.capitalize((String)suggestedHeader);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringUtil.capitalize(suggestedHeader)");
        Project project2 = project;
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        Iterable iterable = headers = MarkdownHeadersIndex.Companion.collectFileHeaders(string, project2, this.getFile());
        if (!iterable.isEmpty()) {
            ResolveResult[] resolveResultArray = PsiElementResolveResult.createResults(headers);
            Intrinsics.checkExpressionValueIsNotNull((Object)resolveResultArray, (String)"PsiElementResolveResult.createResults(headers)");
            return resolveResultArray;
        }
        String string2 = StringUtil.capitalizeWords((String)suggestedHeader, (boolean)true);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"StringUtil.capitalizeWords(suggestedHeader, true)");
        iterable = headers = MarkdownHeadersIndex.Companion.collectFileHeaders(string2, project, this.getFile());
        if (!iterable.isEmpty()) {
            ResolveResult[] resolveResultArray = PsiElementResolveResult.createResults(headers);
            Intrinsics.checkExpressionValueIsNotNull((Object)resolveResultArray, (String)"PsiElementResolveResult.createResults(headers)");
            return resolveResultArray;
        }
        iterable = StubIndex.getInstance().getAllKeys(MarkdownHeadersIndex.Companion.getKEY(), project);
        void var6_6 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            String string3 = it = (String)element$iv$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"it");
            if (!Intrinsics.areEqual((Object)MarkdownAnchorReferenceImpl.Companion.dashed(string3), (Object)this.getCanonicalText())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            String string4 = it = (String)element$iv$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"it");
            Iterable list$iv$iv = MarkdownHeadersIndex.Companion.collectFileHeaders(string4, project, this.getFile());
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        headers = (List)destination$iv$iv;
        ResolveResult[] resolveResultArray = PsiElementResolveResult.createResults((Collection)headers);
        Intrinsics.checkExpressionValueIsNotNull((Object)resolveResultArray, (String)"PsiElementResolveResult.createResults(headers)");
        return resolveResultArray;
    }

    @NotNull
    public String getCanonicalText() {
        return this.myAnchor;
    }

    @NotNull
    public Object[] getVariants() {
        Project project = this.myPsiElement.getProject();
        ArrayList list = ContainerUtil.newArrayList();
        Iterable $receiver$iv = StubIndex.getInstance().getAllKeys(MarkdownHeadersIndex.Companion.getKEY(), project);
        for (Object element$iv : $receiver$iv) {
            GlobalSearchScope globalSearchScope;
            String key = (String)element$iv;
            StubIndex stubIndex = StubIndex.getInstance();
            StubIndexKey<String, MarkdownHeaderImpl> stubIndexKey = MarkdownHeadersIndex.Companion.getKEY();
            String string = key;
            Project project2 = project;
            if (this.getFile() != null) {
                PsiFile psiFile;
                Project project3 = project2;
                String string2 = string;
                StubIndexKey<String, MarkdownHeaderImpl> stubIndexKey2 = stubIndexKey;
                StubIndex stubIndex2 = stubIndex;
                PsiFile it = psiFile;
                GlobalSearchScope globalSearchScope2 = GlobalSearchScope.fileScope((PsiFile)it);
                stubIndex = stubIndex2;
                stubIndexKey = stubIndexKey2;
                string = string2;
                project2 = project3;
                globalSearchScope = globalSearchScope2;
            } else {
                globalSearchScope = null;
            }
            stubIndex.processElements(stubIndexKey, (Object)string, project2, globalSearchScope, MarkdownHeaderImpl.class, (Processor)new Processor<MarkdownHeaderImpl>(key, this, project, list){
                final /* synthetic */ String $key;
                final /* synthetic */ MarkdownAnchorReferenceImpl this$0;
                final /* synthetic */ Project $project$inlined;
                final /* synthetic */ ArrayList $list$inlined;
                {
                    this.$key = string;
                    this.this$0 = markdownAnchorReferenceImpl;
                    this.$project$inlined = project;
                    this.$list$inlined = arrayList;
                }

                public final boolean process(MarkdownHeaderImpl it) {
                    String string = this.$key;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"key");
                    return this.$list$inlined.add(org.intellij.plugins.markdown.lang.references.MarkdownAnchorReferenceImpl$Companion.access$dashed(MarkdownAnchorReferenceImpl.Companion, string));
                }
            });
        }
        Iterable iterable = $receiver$iv = (Collection)list;
        if (iterable == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Iterable thisCollection$iv = iterable;
        Object[] objectArray = thisCollection$iv.toArray(new Object[thisCollection$iv.size()]);
        if (objectArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return objectArray;
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        String string;
        if (this.getFile() == null) {
            String string2 = MarkdownBundle.message("markdown.cannot.resolve.anchor.error.message", this.myAnchor);
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"MarkdownBundle.message(\"\u2026error.message\", myAnchor)");
        } else {
            Object[] objectArray = new Object[2];
            objectArray[0] = this.myAnchor;
            PsiFile psiFile = this.getFile();
            if (psiFile == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.PsiFile");
            }
            objectArray[1] = psiFile.getName();
            String string3 = MarkdownBundle.message("markdown.cannot.resolve.anchor.in.file.error.message", objectArray);
            string = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"MarkdownBundle.message(\"\u2026, (file as PsiFile).name)");
        }
        return string;
    }

    public MarkdownAnchorReferenceImpl(@NotNull String myAnchor, @Nullable FileReference myFileReference, @NotNull PsiElement myPsiElement, int myOffset) {
        Intrinsics.checkParameterIsNotNull((Object)myAnchor, (String)"myAnchor");
        Intrinsics.checkParameterIsNotNull((Object)myPsiElement, (String)"myPsiElement");
        super(myPsiElement);
        this.myAnchor = myAnchor;
        this.myFileReference = myFileReference;
        this.myPsiElement = myPsiElement;
        this.myOffset = myOffset;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a8\u0006\u0006"}, d2={"Lorg/intellij/plugins/markdown/lang/references/MarkdownAnchorReferenceImpl$Companion;", "", "()V", "dashed", "", "it", "markdown"})
    public static final class Companion {
        private final String dashed(String it) {
            String string;
            String string2 = string = it;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.toLowerCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
            return StringsKt.replace$default((String)string3, (String)" ", (String)"-", (boolean)false, (int)4, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

