/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.settings;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.util.Disposer;
import javax.swing.JComponent;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.settings.MarkdownApplicationSettings;
import org.intellij.plugins.markdown.settings.MarkdownSettingsForm;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MarkdownSettingsConfigurable
implements SearchableConfigurable {
    @Nullable
    private MarkdownSettingsForm myForm;
    @NotNull
    private MarkdownApplicationSettings myMarkdownApplicationSettings;

    public MarkdownSettingsConfigurable(@NotNull MarkdownApplicationSettings markdownApplicationSettings) {
        if (markdownApplicationSettings == null) {
            MarkdownSettingsConfigurable.$$$reportNull$$$0(0);
        }
        this.myForm = null;
        this.myMarkdownApplicationSettings = markdownApplicationSettings;
    }

    @NotNull
    public String getId() {
        if ("Settings.Markdown" == null) {
            MarkdownSettingsConfigurable.$$$reportNull$$$0(1);
        }
        return "Settings.Markdown";
    }

    @Nls
    public String getDisplayName() {
        return MarkdownBundle.message("markdown.settings.name", new Object[0]);
    }

    @NotNull
    public JComponent createComponent() {
        JComponent jComponent = this.getForm().getComponent();
        if (jComponent == null) {
            MarkdownSettingsConfigurable.$$$reportNull$$$0(2);
        }
        return jComponent;
    }

    @NotNull
    public MarkdownSettingsForm getForm() {
        if (this.myForm == null) {
            this.myForm = new MarkdownSettingsForm();
        }
        MarkdownSettingsForm markdownSettingsForm = this.myForm;
        if (markdownSettingsForm == null) {
            MarkdownSettingsConfigurable.$$$reportNull$$$0(3);
        }
        return markdownSettingsForm;
    }

    public boolean isModified() {
        return !this.getForm().getMarkdownCssSettings().equals(this.myMarkdownApplicationSettings.getMarkdownCssSettings()) || !this.getForm().getMarkdownPreviewSettings().equals(this.myMarkdownApplicationSettings.getMarkdownPreviewSettings());
    }

    public void apply() throws ConfigurationException {
        MarkdownSettingsForm form = this.getForm();
        form.validate();
        this.myMarkdownApplicationSettings.setMarkdownCssSettings(form.getMarkdownCssSettings());
        this.myMarkdownApplicationSettings.setMarkdownPreviewSettings(form.getMarkdownPreviewSettings());
    }

    public void reset() {
        this.getForm().setMarkdownCssSettings(this.myMarkdownApplicationSettings.getMarkdownCssSettings());
        this.getForm().setMarkdownPreviewSettings(this.myMarkdownApplicationSettings.getMarkdownPreviewSettings());
    }

    public void disposeUIResources() {
        if (this.myForm != null) {
            Disposer.dispose((Disposable)this.myForm);
        }
        this.myForm = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "markdownApplicationSettings";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/markdown/settings/MarkdownSettingsConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/markdown/settings/MarkdownSettingsConfigurable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getForm";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

