/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.settings;

import com.intellij.ide.highlighter.HighlighterFactory;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.TextBrowseFolderListener;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.settings.MarkdownCssSettings;
import org.intellij.plugins.markdown.settings.MarkdownPreviewSettings;
import org.intellij.plugins.markdown.ui.preview.MarkdownHtmlPanelProvider;
import org.intellij.plugins.markdown.ui.split.SplitFileEditor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MarkdownSettingsForm
implements MarkdownCssSettings.Holder,
MarkdownPreviewSettings.Holder,
Disposable {
    private static final String JAVA_FX_HTML_PANEL_PROVIDER = "JavaFxHtmlPanelProvider";
    private static final String LOBO_HTML_PANEL_PROVIDER = "LoboHtmlPanelProvider";
    private JPanel myMainPanel;
    private JBCheckBox myCssFromURIEnabled;
    private TextFieldWithBrowseButton myCssURI;
    private JBCheckBox myApplyCustomCssText;
    private JPanel myEditorPanel;
    private JPanel myCssTitledSeparator;
    private ComboBox myPreviewProvider;
    private ComboBox myDefaultSplitLayout;
    private JBCheckBox myUseGrayscaleRenderingForJBCheckBox;
    private JPanel myPreviewTitledSeparator;
    private JBCheckBox myAutoScrollCheckBox;
    private JBCheckBox myPreviewWithJavaFX;
    private JPanel myMultipleProvidersPreviewPanel;
    @Nullable
    private EditorEx myEditor;
    @NotNull
    private final ActionListener myCssURIListener;
    @NotNull
    private final ActionListener myCustomCssTextListener;
    private Object myLastItem;
    private EnumComboBoxModel<SplitFileEditor.SplitEditorLayout> mySplitLayoutModel;
    private CollectionComboBoxModel<MarkdownHtmlPanelProvider.ProviderInfo> myPreviewPanelModel;

    public MarkdownSettingsForm() {
        this.$$$setupUI$$$();
        this.myCssURIListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MarkdownSettingsForm.this.myCssURI.setEnabled(MarkdownSettingsForm.this.myCssFromURIEnabled.isSelected());
            }
        };
        this.myCustomCssTextListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MarkdownSettingsForm.this.adjustCSSRulesAvailability();
            }
        };
        this.adjustCSSRulesAvailability();
        this.myCssFromURIEnabled.addActionListener(this.myCssURIListener);
        this.myApplyCustomCssText.addActionListener(this.myCustomCssTextListener);
        this.myCssURI.addBrowseFolderListener(new TextBrowseFolderListener(FileChooserDescriptorFactory.createSingleFileDescriptor((String)"css")){

            @NotNull
            protected String chosenFileToResultingText(@NotNull VirtualFile chosenFile) {
                if (chosenFile == null) {
                    3.$$$reportNull$$$0(0);
                }
                String string = chosenFile.getUrl();
                if (string == null) {
                    3.$$$reportNull$$$0(1);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "chosenFile";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/intellij/plugins/markdown/settings/MarkdownSettingsForm$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/intellij/plugins/markdown/settings/MarkdownSettingsForm$3";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "chosenFileToResultingText";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "chosenFileToResultingText";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        boolean multipleProviders = MarkdownSettingsForm.isMultipleProviders();
        this.myPreviewWithJavaFX.setVisible(!multipleProviders);
        this.myMultipleProvidersPreviewPanel.setVisible(multipleProviders);
        this.updateUseGrayscaleEnabled();
        this.myDefaultSplitLayout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MarkdownSettingsForm.this.adjustAutoScroll();
            }
        });
        this.adjustAutoScroll();
    }

    private void adjustAutoScroll() {
        this.myAutoScrollCheckBox.setEnabled(this.myDefaultSplitLayout.getSelectedItem() == SplitFileEditor.SplitEditorLayout.SPLIT);
    }

    private void adjustCSSRulesAvailability() {
        if (this.myEditor != null) {
            boolean enabled = this.myApplyCustomCssText.isSelected();
            this.myEditor.getDocument().setReadOnly(!enabled);
            this.myEditor.getContentComponent().setEnabled(enabled);
            this.myEditor.setCaretEnabled(enabled);
        }
    }

    public JComponent getComponent() {
        return this.myMainPanel;
    }

    private void createUIComponents() {
        this.myEditorPanel = new JPanel(new BorderLayout());
        this.myEditor = MarkdownSettingsForm.createEditor();
        this.myEditorPanel.add((Component)this.myEditor.getComponent(), "Center");
        this.myCssTitledSeparator = new TitledSeparator(MarkdownBundle.message("markdown.settings.css.title.name", new Object[0]));
        this.createPreviewUIComponents();
    }

    private void createJavaFXPreviewSettings() {
        this.myPreviewWithJavaFX = new JBCheckBox(MarkdownBundle.message("markdown.settings.preview.with.javafx", new Object[0]));
        this.myPreviewWithJavaFX.addActionListener(e -> {
            MarkdownHtmlPanelProvider provider = MarkdownHtmlPanelProvider.createFromInfo(this.getSelectedProvider());
            MarkdownHtmlPanelProvider.AvailabilityInfo availability = provider.isAvailable();
            if (!availability.checkAvailability(this.myMainPanel)) {
                this.myPreviewWithJavaFX.setSelected(false);
            } else {
                this.updateUseGrayscaleEnabled();
            }
        });
    }

    private static boolean isMultipleProviders() {
        return MarkdownHtmlPanelProvider.getProviders().length > 2;
    }

    public void validate() throws ConfigurationException {
        if (!this.myCssFromURIEnabled.isSelected()) {
            return;
        }
        try {
            new URL(this.myCssURI.getText()).toURI();
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new ConfigurationException("URI '" + this.myCssURI.getText() + "' parsing reports the error: " + e.getMessage());
        }
    }

    @NotNull
    private static EditorEx createEditor() {
        EditorFactory editorFactory = EditorFactory.getInstance();
        Document editorDocument = editorFactory.createDocument((CharSequence)"");
        EditorEx editor = (EditorEx)editorFactory.createEditor(editorDocument);
        MarkdownSettingsForm.fillEditorSettings(editor.getSettings());
        MarkdownSettingsForm.setHighlighting(editor);
        EditorEx editorEx = editor;
        if (editorEx == null) {
            MarkdownSettingsForm.$$$reportNull$$$0(0);
        }
        return editorEx;
    }

    private static void setHighlighting(EditorEx editor) {
        FileType cssFileType = FileTypeManager.getInstance().getFileTypeByExtension("css");
        if (cssFileType == UnknownFileType.INSTANCE) {
            return;
        }
        EditorHighlighter editorHighlighter = HighlighterFactory.createHighlighter((FileType)cssFileType, (EditorColorsScheme)EditorColorsManager.getInstance().getGlobalScheme(), null);
        editor.setHighlighter(editorHighlighter);
    }

    private static void fillEditorSettings(EditorSettings editorSettings) {
        editorSettings.setWhitespacesShown(false);
        editorSettings.setLineMarkerAreaShown(false);
        editorSettings.setIndentGuidesShown(false);
        editorSettings.setLineNumbersShown(true);
        editorSettings.setFoldingOutlineShown(false);
        editorSettings.setAdditionalColumnsCount(1);
        editorSettings.setAdditionalLinesCount(1);
        editorSettings.setUseSoftWraps(false);
    }

    @Override
    public void setMarkdownCssSettings(@NotNull MarkdownCssSettings settings) {
        if (settings == null) {
            MarkdownSettingsForm.$$$reportNull$$$0(1);
        }
        this.myCssFromURIEnabled.setSelected(settings.isUriEnabled());
        this.myCssURI.setText(settings.getStylesheetUri());
        this.myApplyCustomCssText.setSelected(settings.isTextEnabled());
        this.resetEditor(settings.getStylesheetText());
        this.myCssURIListener.actionPerformed(null);
        this.myCustomCssTextListener.actionPerformed(null);
    }

    void resetEditor(@NotNull String cssText) {
        if (cssText == null) {
            MarkdownSettingsForm.$$$reportNull$$$0(2);
        }
        if (this.myEditor != null && !this.myEditor.isDisposed()) {
            ApplicationManager.getApplication().runWriteAction(() -> {
                if (cssText == null) {
                    MarkdownSettingsForm.$$$reportNull$$$0(12);
                }
                boolean writable = this.myEditor.getDocument().isWritable();
                this.myEditor.getDocument().setReadOnly(false);
                this.myEditor.getDocument().setText((CharSequence)cssText);
                this.myEditor.getDocument().setReadOnly(!writable);
            });
        }
    }

    @Override
    @NotNull
    public MarkdownCssSettings getMarkdownCssSettings() {
        MarkdownCssSettings markdownCssSettings = new MarkdownCssSettings(this.myCssFromURIEnabled.isSelected(), this.myCssURI.getText(), this.myApplyCustomCssText.isSelected(), this.myEditor != null && !this.myEditor.isDisposed() ? (String)ReadAction.compute(() -> this.myEditor.getDocument().getText()) : "");
        if (markdownCssSettings == null) {
            MarkdownSettingsForm.$$$reportNull$$$0(3);
        }
        return markdownCssSettings;
    }

    public void dispose() {
        if (this.myEditor != null && !this.myEditor.isDisposed()) {
            EditorFactory.getInstance().releaseEditor((Editor)this.myEditor);
        }
        this.myEditor = null;
    }

    private void createPreviewUIComponents() {
        this.myPreviewTitledSeparator = new TitledSeparator(MarkdownBundle.message("markdown.settings.preview.name", new Object[0]));
        this.mySplitLayoutModel = new EnumComboBoxModel(SplitFileEditor.SplitEditorLayout.class);
        this.myDefaultSplitLayout = new ComboBox(this.mySplitLayoutModel);
        this.myDefaultSplitLayout.setRenderer((ListCellRenderer)new ListCellRendererWrapper<SplitFileEditor.SplitEditorLayout>(){

            public void customize(JList list, SplitFileEditor.SplitEditorLayout value, int index, boolean selected, boolean hasFocus) {
                this.setText(value.getPresentationText());
            }
        });
        this.createMultipleProvidersSettings();
        this.createJavaFXPreviewSettings();
    }

    private void createMultipleProvidersSettings() {
        List providerInfos = ContainerUtil.mapNotNull((Object[])MarkdownHtmlPanelProvider.getProviders(), provider -> {
            if (provider.isAvailable() == MarkdownHtmlPanelProvider.AvailabilityInfo.UNAVAILABLE) {
                return null;
            }
            return provider.getProviderInfo();
        });
        this.myPreviewPanelModel = new CollectionComboBoxModel(providerInfos, providerInfos.get(0));
        this.myPreviewProvider = new ComboBox(this.myPreviewPanelModel);
        this.myLastItem = this.myPreviewProvider.getSelectedItem();
        this.myPreviewProvider.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Object item = e.getItem();
                if (e.getStateChange() != 1 || !(item instanceof MarkdownHtmlPanelProvider.ProviderInfo)) {
                    return;
                }
                MarkdownHtmlPanelProvider provider = MarkdownHtmlPanelProvider.createFromInfo((MarkdownHtmlPanelProvider.ProviderInfo)item);
                MarkdownHtmlPanelProvider.AvailabilityInfo availability = provider.isAvailable();
                if (!availability.checkAvailability(MarkdownSettingsForm.this.myMainPanel)) {
                    MarkdownSettingsForm.this.myPreviewProvider.setSelectedItem(MarkdownSettingsForm.this.myLastItem);
                } else {
                    MarkdownSettingsForm.this.myLastItem = item;
                    MarkdownSettingsForm.this.updateUseGrayscaleEnabled();
                }
            }
        });
    }

    private void updateUseGrayscaleEnabled() {
        MarkdownHtmlPanelProvider.ProviderInfo selected = this.getSelectedProvider();
        this.myUseGrayscaleRenderingForJBCheckBox.setEnabled(MarkdownSettingsForm.isProviderOf(selected, JAVA_FX_HTML_PANEL_PROVIDER));
    }

    private static boolean isProviderOf(@NotNull MarkdownHtmlPanelProvider.ProviderInfo selected, @NotNull String provider) {
        if (selected == null) {
            MarkdownSettingsForm.$$$reportNull$$$0(4);
        }
        if (provider == null) {
            MarkdownSettingsForm.$$$reportNull$$$0(5);
        }
        return selected.getClassName().contains(provider);
    }

    @NotNull
    private static MarkdownHtmlPanelProvider getProvider(@NotNull String providerClass) {
        if (providerClass == null) {
            MarkdownSettingsForm.$$$reportNull$$$0(6);
        }
        for (MarkdownHtmlPanelProvider provider : MarkdownHtmlPanelProvider.getProviders()) {
            if (!MarkdownSettingsForm.isProviderOf(provider.getProviderInfo(), providerClass)) continue;
            MarkdownHtmlPanelProvider markdownHtmlPanelProvider = provider;
            if (markdownHtmlPanelProvider == null) {
                MarkdownSettingsForm.$$$reportNull$$$0(7);
            }
            return markdownHtmlPanelProvider;
        }
        throw new RuntimeException("Cannot find " + providerClass);
    }

    @NotNull
    private MarkdownHtmlPanelProvider.ProviderInfo getSelectedProvider() {
        if (MarkdownSettingsForm.isMultipleProviders()) {
            MarkdownHtmlPanelProvider.ProviderInfo providerInfo = (MarkdownHtmlPanelProvider.ProviderInfo)Objects.requireNonNull(this.myPreviewPanelModel.getSelected());
            if (providerInfo == null) {
                MarkdownSettingsForm.$$$reportNull$$$0(8);
            }
            return providerInfo;
        }
        MarkdownHtmlPanelProvider.ProviderInfo providerInfo = this.myPreviewWithJavaFX.isEnabled() && this.myPreviewWithJavaFX.isSelected() ? MarkdownSettingsForm.getProvider(JAVA_FX_HTML_PANEL_PROVIDER).getProviderInfo() : MarkdownSettingsForm.getProvider(LOBO_HTML_PANEL_PROVIDER).getProviderInfo();
        if (providerInfo == null) {
            MarkdownSettingsForm.$$$reportNull$$$0(9);
        }
        return providerInfo;
    }

    @Override
    public void setMarkdownPreviewSettings(@NotNull MarkdownPreviewSettings settings) {
        if (settings == null) {
            MarkdownSettingsForm.$$$reportNull$$$0(10);
        }
        if (MarkdownSettingsForm.isMultipleProviders()) {
            if (this.myPreviewPanelModel.contains((Object)settings.getHtmlPanelProviderInfo())) {
                this.myPreviewPanelModel.setSelectedItem((Object)settings.getHtmlPanelProviderInfo());
            }
        } else {
            this.myPreviewWithJavaFX.setSelected(MarkdownSettingsForm.isProviderOf(settings.getHtmlPanelProviderInfo(), JAVA_FX_HTML_PANEL_PROVIDER));
        }
        this.mySplitLayoutModel.setSelectedItem((Enum)settings.getSplitEditorLayout());
        this.myUseGrayscaleRenderingForJBCheckBox.setSelected(settings.isUseGrayscaleRendering());
        this.myAutoScrollCheckBox.setSelected(settings.isAutoScrollPreview());
        this.updateUseGrayscaleEnabled();
    }

    @Override
    @NotNull
    public MarkdownPreviewSettings getMarkdownPreviewSettings() {
        MarkdownHtmlPanelProvider.ProviderInfo provider = this.getSelectedProvider();
        Objects.requireNonNull(provider);
        MarkdownPreviewSettings markdownPreviewSettings = new MarkdownPreviewSettings((SplitFileEditor.SplitEditorLayout)this.mySplitLayoutModel.getSelectedItem(), provider, this.myUseGrayscaleRenderingForJBCheckBox.isSelected(), this.myAutoScrollCheckBox.isSelected());
        if (markdownPreviewSettings == null) {
            MarkdownSettingsForm.$$$reportNull$$$0(11);
        }
        return markdownPreviewSettings;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 12: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 12: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/markdown/settings/MarkdownSettingsForm";
                break;
            }
            case 1: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cssText";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selected";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providerClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/markdown/settings/MarkdownSettingsForm";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMarkdownCssSettings";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getProvider";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedProvider";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getMarkdownPreviewSettings";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setMarkdownCssSettings";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resetEditor";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isProviderOf";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getProvider";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setMarkdownPreviewSettings";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$resetEditor$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 12: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JBCheckBox jBCheckBox2;
        JBCheckBox jBCheckBox3;
        JBCheckBox jBCheckBox4;
        JPanel jPanel;
        JPanel jPanel2;
        this.createUIComponents();
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(4, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myMultipleProvidersPreviewPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel, new GridConstraints(2, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Preview browser:");
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        ComboBox comboBox = this.myPreviewProvider;
        jPanel.add((Component)comboBox, new GridConstraints(0, 1, 1, 1, 8, 0, 2, 0, null, null, null));
        JBCheckBox jBCheckBox5 = this.myPreviewWithJavaFX;
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox5, ResourceBundle.getBundle("org/intellij/plugins/markdown/bundle/MarkdownBundle").getString("markdown.settings.preview.with.javafx"));
        jPanel3.add((Component)jBCheckBox5, new GridConstraints(1, 0, 1, 3, 8, 0, 0, 0, null, null, null));
        this.myUseGrayscaleRenderingForJBCheckBox = jBCheckBox4 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox4, ResourceBundle.getBundle("org/intellij/plugins/markdown/bundle/MarkdownBundle").getString("markdown.settings.preview.use.grayscale"));
        jPanel3.add((Component)jBCheckBox4, new GridConstraints(3, 0, 1, 3, 8, 0, 0, 0, null, null, null, 2));
        JBLabel jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, ResourceBundle.getBundle("org/intellij/plugins/markdown/bundle/MarkdownBundle").getString("markdown.settings.default.layout"));
        jPanel3.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 1));
        ComboBox comboBox2 = this.myDefaultSplitLayout;
        jPanel3.add((Component)comboBox2, new GridConstraints(0, 1, 1, 1, 8, 0, 2, 0, null, null, null));
        this.myAutoScrollCheckBox = jBCheckBox3 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox3, ResourceBundle.getBundle("org/intellij/plugins/markdown/bundle/MarkdownBundle").getString("markdown.settings.preview.auto.scroll.checkbox"));
        jPanel3.add((Component)jBCheckBox3, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(5, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel4 = this.myCssTitledSeparator;
        jPanel2.add((Component)jPanel4, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myCssFromURIEnabled = jBCheckBox2 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox2, ResourceBundle.getBundle("org/intellij/plugins/markdown/bundle/MarkdownBundle").getString("markdown.settings.css.enable.uri"));
        jPanel2.add((Component)jBCheckBox2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCssURI = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel2.add((Component)textFieldWithBrowseButton, new GridConstraints(2, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myApplyCustomCssText = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, ResourceBundle.getBundle("org/intellij/plugins/markdown/bundle/MarkdownBundle").getString("markdown.settings.css.enable.inline"));
        jPanel2.add((Component)jBCheckBox, new GridConstraints(3, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        JPanel jPanel5 = this.myEditorPanel;
        ((Component)jPanel5).setBackground(new Color(-1118482));
        ((Component)jPanel5).setEnabled(true);
        jPanel2.add((Component)jPanel5, new GridConstraints(4, 0, 1, 2, 0, 3, 3, 3, null, new Dimension(-1, 150), null, 1));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

