/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.preview;

import com.intellij.CommonBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.xmlb.annotations.Attribute;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.intellij.plugins.markdown.ui.preview.MarkdownHtmlPanel;
import org.jetbrains.annotations.NotNull;

public abstract class MarkdownHtmlPanelProvider {
    public static final ExtensionPointName<MarkdownHtmlPanelProvider> EP_NAME = ExtensionPointName.create((String)"org.intellij.markdown.html.panel.provider");
    private static MarkdownHtmlPanelProvider[] ourProviders = null;

    @NotNull
    public abstract MarkdownHtmlPanel createHtmlPanel();

    @NotNull
    public abstract AvailabilityInfo isAvailable();

    @NotNull
    public abstract ProviderInfo getProviderInfo();

    @NotNull
    public static MarkdownHtmlPanelProvider[] getProviders() {
        if (ourProviders == null) {
            ourProviders = (MarkdownHtmlPanelProvider[])EP_NAME.getExtensions();
        }
        if (ourProviders == null) {
            MarkdownHtmlPanelProvider.$$$reportNull$$$0(0);
        }
        return ourProviders;
    }

    @NotNull
    public static MarkdownHtmlPanelProvider createFromInfo(@NotNull ProviderInfo providerInfo) {
        MarkdownHtmlPanelProvider markdownHtmlPanelProvider;
        if (providerInfo == null) {
            MarkdownHtmlPanelProvider.$$$reportNull$$$0(1);
        }
        try {
            markdownHtmlPanelProvider = (MarkdownHtmlPanelProvider)Class.forName(providerInfo.getClassName()).newInstance();
        }
        catch (Exception e) {
            Messages.showMessageDialog((String)("Cannot set preview panel provider (" + providerInfo.getName() + "):\n" + e.getMessage()), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
            Logger.getInstance(MarkdownHtmlPanelProvider.class).error((Throwable)e);
            MarkdownHtmlPanelProvider markdownHtmlPanelProvider2 = MarkdownHtmlPanelProvider.getProviders()[0];
            if (markdownHtmlPanelProvider2 == null) {
                MarkdownHtmlPanelProvider.$$$reportNull$$$0(3);
            }
            return markdownHtmlPanelProvider2;
        }
        if (markdownHtmlPanelProvider == null) {
            MarkdownHtmlPanelProvider.$$$reportNull$$$0(2);
        }
        return markdownHtmlPanelProvider;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/markdown/ui/preview/MarkdownHtmlPanelProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providerInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getProviders";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/markdown/ui/preview/MarkdownHtmlPanelProvider";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createFromInfo";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createFromInfo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static abstract class AvailabilityInfo {
        public static final AvailabilityInfo AVAILABLE = new AvailabilityInfo(){

            @Override
            public boolean checkAvailability(@NotNull JComponent parentComponent) {
                if (parentComponent == null) {
                    1.$$$reportNull$$$0(0);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentComponent", "org/intellij/plugins/markdown/ui/preview/MarkdownHtmlPanelProvider$AvailabilityInfo$1", "checkAvailability"));
            }
        };
        public static final AvailabilityInfo UNAVAILABLE = new AvailabilityInfo(){

            @Override
            public boolean checkAvailability(@NotNull JComponent parentComponent) {
                if (parentComponent == null) {
                    2.$$$reportNull$$$0(0);
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentComponent", "org/intellij/plugins/markdown/ui/preview/MarkdownHtmlPanelProvider$AvailabilityInfo$2", "checkAvailability"));
            }
        };

        public abstract boolean checkAvailability(@NotNull JComponent var1);
    }

    public static class ProviderInfo {
        @Attribute(value="name")
        @NotNull
        private String myName;
        @Attribute(value="className")
        @NotNull
        private String className;

        private ProviderInfo() {
            this.myName = "";
            this.className = "";
        }

        public ProviderInfo(@NotNull String name, @NotNull String className) {
            if (name == null) {
                ProviderInfo.$$$reportNull$$$0(0);
            }
            if (className == null) {
                ProviderInfo.$$$reportNull$$$0(1);
            }
            this.myName = name;
            this.className = className;
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                ProviderInfo.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public String getClassName() {
            String string = this.className;
            if (string == null) {
                ProviderInfo.$$$reportNull$$$0(3);
            }
            return string;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProviderInfo info = (ProviderInfo)o;
            if (!this.myName.equals(info.myName)) {
                return false;
            }
            return this.className.equals(info.className);
        }

        public int hashCode() {
            int result = this.myName.hashCode();
            result = 31 * result + this.className.hashCode();
            return result;
        }

        public String toString() {
            return this.myName;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "className";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/intellij/plugins/markdown/ui/preview/MarkdownHtmlPanelProvider$ProviderInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/intellij/plugins/markdown/ui/preview/MarkdownHtmlPanelProvider$ProviderInfo";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getClassName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

