/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.preview.javafx;

import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.ui.JBColor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.JBUI;
import com.sun.javafx.application.PlatformImpl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.text.FontSmoothingType;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javax.swing.JComponent;
import javax.swing.JPanel;
import netscape.javascript.JSObject;
import org.intellij.markdown.html.HtmlGenerator;
import org.intellij.plugins.markdown.settings.MarkdownApplicationSettings;
import org.intellij.plugins.markdown.ui.preview.MarkdownHtmlPanel;
import org.intellij.plugins.markdown.ui.preview.PreviewStaticServer;
import org.intellij.plugins.markdown.ui.preview.javafx.ImageRefreshFix;
import org.intellij.plugins.markdown.ui.preview.javafx.JFXPanelWrapper;
import org.intellij.plugins.markdown.ui.preview.javafx.SafeOpener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaFxHtmlPanel
extends MarkdownHtmlPanel {
    private static final NotNullLazyValue<String> MY_SCRIPTING_LINES = new NotNullLazyValue<String>(){

        @NotNull
        protected String compute() {
            String string = SCRIPTS.stream().map(s -> "<script src=\"" + PreviewStaticServer.getScriptUrl(s) + "\"></script>").reduce((s, s2) -> s + "\n" + s2).orElseGet(String::new);
            if (string == null) {
                1.$$$reportNull$$$0(0);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/ui/preview/javafx/JavaFxHtmlPanel$1", "compute"));
        }
    };
    @NotNull
    private final JPanel myPanelWrapper;
    @NotNull
    private final List<Runnable> myInitActions = new ArrayList<Runnable>();
    @Nullable
    private JFXPanel myPanel;
    @Nullable
    private WebView myWebView;
    @NotNull
    private String[] myCssUris = ArrayUtil.EMPTY_STRING_ARRAY;
    @NotNull
    private String myCSP = "";
    @NotNull
    private String myLastRawHtml = "";
    @NotNull
    private final ScrollPreservingListener myScrollPreservingListener = new ScrollPreservingListener();
    @NotNull
    private final BridgeSettingListener myBridgeSettingListener = new BridgeSettingListener();

    public JavaFxHtmlPanel() {
        this.myPanelWrapper = new JPanel(new BorderLayout());
        this.myPanelWrapper.setBackground(JBColor.background());
        ApplicationManager.getApplication().invokeLater(() -> JavaFxHtmlPanel.runFX(() -> PlatformImpl.startup(() -> {
            this.myWebView = new WebView();
            JavaFxHtmlPanel.updateFontSmoothingType(this.myWebView, MarkdownApplicationSettings.getInstance().getMarkdownPreviewSettings().isUseGrayscaleRendering());
            this.myWebView.setContextMenuEnabled(false);
            this.myWebView.setZoom((double)JBUI.scale((float)1.0f));
            WebEngine engine = this.myWebView.getEngine();
            engine.getLoadWorker().stateProperty().addListener((ChangeListener)this.myBridgeSettingListener);
            engine.getLoadWorker().stateProperty().addListener((ChangeListener)this.myScrollPreservingListener);
            Scene scene = new Scene((Parent)this.myWebView);
            ApplicationManager.getApplication().invokeLater(() -> JavaFxHtmlPanel.runFX(() -> {
                this.myPanel = new JFXPanelWrapper();
                Platform.runLater(() -> this.myPanel.setScene(scene));
                this.setHtml("");
                for (Runnable action : this.myInitActions) {
                    Platform.runLater((Runnable)action);
                }
                this.myInitActions.clear();
                this.myPanelWrapper.add((Component)this.myPanel, "Center");
                this.myPanelWrapper.repaint();
            }));
        })));
        this.subscribeForGrayscaleSetting();
    }

    private static void runFX(@NotNull Runnable r) {
        if (r == null) {
            JavaFxHtmlPanel.$$$reportNull$$$0(0);
        }
        IdeEventQueue.unsafeNonblockingExecute((Runnable)r);
    }

    private void runInPlatformWhenAvailable(@NotNull Runnable runnable) {
        if (runnable == null) {
            JavaFxHtmlPanel.$$$reportNull$$$0(1);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myPanel == null) {
            this.myInitActions.add(runnable);
        } else {
            Platform.runLater((Runnable)runnable);
        }
    }

    private void subscribeForGrayscaleSetting() {
        MessageBusConnection settingsConnection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this);
        MarkdownApplicationSettings.SettingsChangedListener settingsChangedListener = new MarkdownApplicationSettings.SettingsChangedListener(){

            @Override
            public void beforeSettingsChanged(@NotNull MarkdownApplicationSettings settings) {
                if (settings == null) {
                    2.$$$reportNull$$$0(0);
                }
                JavaFxHtmlPanel.this.runInPlatformWhenAvailable(() -> {
                    if (settings == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    if (JavaFxHtmlPanel.this.myWebView != null) {
                        JavaFxHtmlPanel.updateFontSmoothingType(JavaFxHtmlPanel.this.myWebView, settings.getMarkdownPreviewSettings().isUseGrayscaleRendering());
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "settings";
                objectArray2[1] = "org/intellij/plugins/markdown/ui/preview/javafx/JavaFxHtmlPanel$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeSettingsChanged";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$beforeSettingsChanged$0";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        settingsConnection.subscribe(MarkdownApplicationSettings.SettingsChangedListener.TOPIC, (Object)settingsChangedListener);
    }

    private static void updateFontSmoothingType(@NotNull WebView view, boolean isGrayscale) {
        if (view == null) {
            JavaFxHtmlPanel.$$$reportNull$$$0(2);
        }
        FontSmoothingType typeToSet = isGrayscale ? FontSmoothingType.GRAY : FontSmoothingType.LCD;
        view.fontSmoothingTypeProperty().setValue((Object)typeToSet);
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanelWrapper;
        if (jPanel == null) {
            JavaFxHtmlPanel.$$$reportNull$$$0(3);
        }
        return jPanel;
    }

    @Override
    public void setHtml(@NotNull String html) {
        if (html == null) {
            JavaFxHtmlPanel.$$$reportNull$$$0(4);
        }
        this.myLastRawHtml = html;
        String htmlToRender = this.prepareHtml(html);
        this.runInPlatformWhenAvailable(() -> this.getWebViewGuaranteed().getEngine().loadContent(htmlToRender));
    }

    @NotNull
    private String prepareHtml(@NotNull String html) {
        if (html == null) {
            JavaFxHtmlPanel.$$$reportNull$$$0(5);
        }
        String string = ImageRefreshFix.setStamps(html.replace("<head>", "<head><meta http-equiv=\"Content-Security-Policy\" content=\"" + this.myCSP + "\"/>" + JavaFxHtmlPanel.getCssLines(null, this.myCssUris) + "\n" + JavaFxHtmlPanel.getScriptingLines()));
        if (string == null) {
            JavaFxHtmlPanel.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    public void setCSS(@Nullable String inlineCss, String ... fileUris) {
        if (fileUris == null) {
            JavaFxHtmlPanel.$$$reportNull$$$0(7);
        }
        PreviewStaticServer.getInstance().setInlineStyle(inlineCss);
        this.myCssUris = inlineCss == null ? fileUris : ArrayUtil.mergeArrays((String[])fileUris, (String[])new String[]{PreviewStaticServer.getStyleUrl("inline.css")});
        this.myCSP = PreviewStaticServer.createCSP(ContainerUtil.map((Collection)SCRIPTS, s -> PreviewStaticServer.getScriptUrl(s)), ContainerUtil.concat((List)ContainerUtil.map((Collection)STYLES, s -> PreviewStaticServer.getStyleUrl(s)), (List)ContainerUtil.filter((Object[])fileUris, s -> s.startsWith("http://") || s.startsWith("https://"))));
        this.setHtml(this.myLastRawHtml);
    }

    @Override
    public void render() {
        this.runInPlatformWhenAvailable(() -> {
            this.getWebViewGuaranteed().getEngine().reload();
            ApplicationManager.getApplication().invokeLater(this.myPanelWrapper::repaint);
        });
    }

    @Override
    public void scrollToMarkdownSrcOffset(int offset) {
        this.runInPlatformWhenAvailable(() -> {
            this.getWebViewGuaranteed().getEngine().executeScript("if ('__IntelliJTools' in window) __IntelliJTools.scrollToOffset(" + offset + ", '" + HtmlGenerator.Companion.getSRC_ATTRIBUTE_NAME() + "');");
            Object result = this.getWebViewGuaranteed().getEngine().executeScript("document.documentElement.scrollTop || document.body.scrollTop");
            if (result instanceof Number) {
                this.myScrollPreservingListener.myScrollY = ((Number)result).intValue();
            }
        });
    }

    public void dispose() {
        this.runInPlatformWhenAvailable(() -> {
            this.getWebViewGuaranteed().getEngine().getLoadWorker().stateProperty().removeListener((ChangeListener)this.myScrollPreservingListener);
            this.getWebViewGuaranteed().getEngine().getLoadWorker().stateProperty().removeListener((ChangeListener)this.myBridgeSettingListener);
        });
    }

    @NotNull
    private WebView getWebViewGuaranteed() {
        if (this.myWebView == null) {
            throw new IllegalStateException("WebView should be initialized by now. Check the caller thread");
        }
        WebView webView = this.myWebView;
        if (webView == null) {
            JavaFxHtmlPanel.$$$reportNull$$$0(8);
        }
        return webView;
    }

    @NotNull
    private static String getScriptingLines() {
        String string = (String)MY_SCRIPTING_LINES.getValue();
        if (string == null) {
            JavaFxHtmlPanel.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/markdown/ui/preview/javafx/JavaFxHtmlPanel";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "html";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileUris";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/markdown/ui/preview/javafx/JavaFxHtmlPanel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareHtml";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getWebViewGuaranteed";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getScriptingLines";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "runFX";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "runInPlatformWhenAvailable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "updateFontSmoothingType";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 9: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setHtml";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "prepareHtml";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setCSS";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ScrollPreservingListener
    implements ChangeListener<Worker.State> {
        volatile int myScrollY = 0;

        private ScrollPreservingListener() {
        }

        public void changed(ObservableValue<? extends Worker.State> observable, Worker.State oldValue, Worker.State newValue) {
            if (newValue == Worker.State.RUNNING) {
                Object result = JavaFxHtmlPanel.this.getWebViewGuaranteed().getEngine().executeScript("document.documentElement.scrollTop || document.body.scrollTop");
                if (result instanceof Number) {
                    this.myScrollY = ((Number)result).intValue();
                }
            } else if (newValue == Worker.State.SUCCEEDED) {
                JavaFxHtmlPanel.this.getWebViewGuaranteed().getEngine().executeScript("document.documentElement.scrollTop = ({} || document.body).scrollTop = " + this.myScrollY);
            }
        }
    }

    private class BridgeSettingListener
    implements ChangeListener<Worker.State> {
        private BridgeSettingListener() {
        }

        public void changed(ObservableValue<? extends Worker.State> observable, Worker.State oldValue, Worker.State newValue) {
            JSObject win = (JSObject)JavaFxHtmlPanel.this.getWebViewGuaranteed().getEngine().executeScript("window");
            win.setMember("JavaPanelBridge", JavaPanelBridge.INSTANCE);
        }
    }

    public static class JavaPanelBridge {
        static final JavaPanelBridge INSTANCE = new JavaPanelBridge();

        public void openInExternalBrowser(@NotNull String link) {
            if (link == null) {
                JavaPanelBridge.$$$reportNull$$$0(0);
            }
            SafeOpener.openLink(link);
        }

        public void log(@Nullable String text) {
            Logger.getInstance(JavaPanelBridge.class).warn(text);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "link", "org/intellij/plugins/markdown/ui/preview/javafx/JavaFxHtmlPanel$JavaPanelBridge", "openInExternalBrowser"));
        }
    }
}

