/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.j2ee.web.resin.resin.configuration;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import org.intellij.j2ee.web.resin.ResinModel;
import org.intellij.j2ee.web.resin.resin.ResinInstallation;
import org.intellij.j2ee.web.resin.resin.configuration.Resin31ConfigurationStrategy;
import org.intellij.j2ee.web.resin.resin.configuration.Resin3XConfigurationStrategy;
import org.intellij.j2ee.web.resin.resin.configuration.ResinConfigImport;
import org.intellij.j2ee.web.resin.resin.configuration.ResinXmlConfigurationStrategy;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jetbrains.annotations.NonNls;

public class Resin4XmlConfigurationStrategy
extends ResinXmlConfigurationStrategy {
    private static final Logger LOG = Logger.getInstance(Resin4XmlConfigurationStrategy.class);
    @NonNls
    protected static final String RESIN_CONF = "resin4.xml";
    @NonNls
    private static final String HOST_DEFAULT_ELEMENT = "host-default";
    @NonNls
    private static final String WEB_APP_DEPLOY_ELEMENT = "web-app-deploy";
    @NonNls
    private static final String SERVER_MULTI_ELEMENT = "server-multi";
    @NonNls
    private static final String ROOT_DIR_ATTRIBUTE = "root-directory";
    @NonNls
    private static final String STARTUP_MODE_ATTRIBUTE = "startup-mode";
    @NonNls
    private static final String ID_PREFIX_ATTRIBUTE = "id-prefix";
    @NonNls
    private static final String ID_ATTRIBUTE = "id";
    @NonNls
    private static final String FIRST_SERVER_ID_SUFFIX = "0";
    @NonNls
    private static final String JVM_ARG = "jvm-arg";
    @NonNls
    private static final String JVM_ARG_SEPARATOR = "=";
    private String myServerId;

    Resin4XmlConfigurationStrategy(ResinInstallation resinInstallation) {
        super(resinInstallation);
    }

    @Override
    public void init(ResinModel serverModel, Document document) throws ExecutionException {
        ArgNameValue[] jmxJvmArgs;
        super.init(serverModel, document);
        Resin4ElementsProvider elementsProvider = (Resin4ElementsProvider)this.getElementsProvider();
        Namespace ns = elementsProvider.getNS();
        Element hostDefaultElement = elementsProvider.getClusterElement().getChild(HOST_DEFAULT_ELEMENT, ns);
        if (hostDefaultElement == null) {
            hostDefaultElement = elementsProvider.getOrCreateChildElement(elementsProvider.getClusterDefaultElement(), HOST_DEFAULT_ELEMENT);
        }
        Element webAppDeployElement = elementsProvider.getOrCreateChildElement(hostDefaultElement, WEB_APP_DEPLOY_ELEMENT);
        webAppDeployElement.setAttribute(STARTUP_MODE_ATTRIBUTE, serverModel.getDeployMode());
        Element serverElement = elementsProvider.getServerElement();
        if (serverElement != null) {
            this.myServerId = serverElement.getAttributeValue(ID_ATTRIBUTE);
        } else if (elementsProvider.getServerDefaultElement() == null) {
            Element serverMultiElement = elementsProvider.getClusterElement().getChild(SERVER_MULTI_ELEMENT, ns);
            if (serverMultiElement != null) {
                this.myServerId = serverMultiElement.getAttributeValue(ID_PREFIX_ATTRIBUTE) + FIRST_SERVER_ID_SUFFIX;
            } else {
                throw new ExecutionException("Can't find neither 'server' nor 'server-default' nor 'server-multi' element");
            }
        }
        HashMap<String, Element> jvmArgName2Element = new HashMap<String, Element>();
        List jvmArgElements = elementsProvider.getParamParentElement().getChildren(JVM_ARG, ns);
        for (Object jvmArg : jvmArgElements) {
            if (!(jvmArg instanceof Element)) continue;
            Element jvmArgElement = (Element)jvmArg;
            String jvmArgText = jvmArgElement.getText();
            String[] jvmArgNameValue = jvmArgText.split(JVM_ARG_SEPARATOR, 2);
            jvmArgName2Element.put(jvmArgNameValue[0], jvmArgElement);
        }
        for (ArgNameValue jmxJvmArg : jmxJvmArgs = new ArgNameValue[]{new ArgNameValue("-Dcom.sun.management.jmxremote.port", String.valueOf(serverModel.getJmxPort())), new ArgNameValue("-Dcom.sun.management.jmxremote.ssl", "false"), new ArgNameValue("-Dcom.sun.management.jmxremote.authenticate", "false")}) {
            Element jvmArgElement = (Element)jvmArgName2Element.get(jmxJvmArg.getFirst());
            if (jvmArgElement == null) {
                jvmArgElement = new Element(JVM_ARG, ns);
                elementsProvider.getParamParentElement().addContent(jvmArgElement);
            }
            jvmArgElement.setText((String)jmxJvmArg.getFirst() + JVM_ARG_SEPARATOR + (String)jmxJvmArg.getSecond());
        }
    }

    @Override
    public String getServerId() {
        return this.myServerId;
    }

    @Override
    protected String getExpandDirAttr() {
        return ROOT_DIR_ATTRIBUTE;
    }

    @Override
    public InputStream getDefaultResinConfContent() {
        return this.getClass().getResourceAsStream(RESIN_CONF);
    }

    @Override
    protected Resin3XConfigurationStrategy.ElementsProvider createElementsProvider() {
        return new Resin4ElementsProvider(this.getDocument());
    }

    private class Resin4ElementsProvider
    extends Resin31ConfigurationStrategy.Resin31ElementsProvider {
        public Resin4ElementsProvider(Document document) {
            super(document);
        }

        public Element getDirectClusterDefaultElement() {
            return this.getRootElement().getChild("cluster-default", this.getNS());
        }

        @Override
        protected Element doGetClusterDefaultElement() {
            Element result = this.getDirectClusterDefaultElement();
            if (result != null) {
                return result;
            }
            for (ResinConfigImport configImport : Resin4XmlConfigurationStrategy.this.getImports()) {
                Resin4ElementsProvider importElementsProvider;
                Document importDoc = configImport.getImportDoc();
                if (importDoc == null || (result = (importElementsProvider = new Resin4ElementsProvider(importDoc)).getDirectClusterDefaultElement()) == null) continue;
                if (Resin4XmlConfigurationStrategy.this.getInstallation().getVersion().getParsed().compare(4, 0, 41) >= 0) {
                    Resin4XmlConfigurationStrategy.this.resolveImports(importDoc, null);
                }
                configImport.copy();
                return result;
            }
            return super.doGetClusterDefaultElement();
        }
    }

    private static class ArgNameValue
    extends Pair<String, String> {
        public ArgNameValue(@NonNls String first, @NonNls String second) {
            super((Object)first, (Object)second);
        }
    }
}

