/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jboss.jbpm.layout;

import com.intellij.jboss.jbpm.render.size.ChartNodeSizeEnhancer;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ChartLayoutCoordinator {
    @Nullable
    public NodeLayout getNodeLayout(@NotNull String var1, ChartNodeSizeEnhancer var2);

    @Nullable
    public Runnable getChangeNodeLayoutAction(@NotNull String var1, @NotNull NodeLayout var2, @Nullable ChartNodeSizeEnhancer var3);

    @Nullable
    public List<Point> getEdgePoints(@NotNull String var1, @NotNull String var2);

    @Nullable
    public Runnable getChangeEdgePointsAction(@NotNull String var1, @NotNull String var2, @NotNull List<Point> var3);

    public static class NodeLayout {
        @NotNull
        private final Point center;
        @NotNull
        private final Size size;

        private NodeLayout(double centerX, double centerY, double width, double height) {
            this.center = new Point(centerX, centerY);
            this.size = new Size(width, height);
        }

        private NodeLayout(@NotNull Size size, @NotNull Point center) {
            if (size == null) {
                NodeLayout.$$$reportNull$$$0(0);
            }
            if (center == null) {
                NodeLayout.$$$reportNull$$$0(1);
            }
            this.size = size;
            this.center = center;
        }

        public static NodeLayout createByCenterPoint(@NotNull Size size, @NotNull Point center) {
            if (size == null) {
                NodeLayout.$$$reportNull$$$0(2);
            }
            if (center == null) {
                NodeLayout.$$$reportNull$$$0(3);
            }
            return new NodeLayout(size, center);
        }

        public static NodeLayout createByCenterPoint(double centerX, double centerY, double width, double height) {
            return new NodeLayout(centerX, centerY, width, height);
        }

        public static NodeLayout createByEdges(double left, double top, double right, double bottom) {
            return new NodeLayout((left + right) / 2.0, (top + bottom) / 2.0, Math.abs(right - left), Math.abs(bottom - top));
        }

        public String toString() {
            return "NodeLayout(" + this.center.x + "," + this.center.y + ")[" + this.size.width + "," + this.size.height + "]";
        }

        public double getLeft() {
            return this.center.x - this.size.width / 2.0;
        }

        public double getRight() {
            return this.center.x + this.size.width / 2.0;
        }

        public double getTop() {
            return this.center.y - this.size.height / 2.0;
        }

        public double getBottom() {
            return this.center.y + this.size.height / 2.0;
        }

        public double getCenterX() {
            return this.center.x;
        }

        public double getCenterY() {
            return this.center.y;
        }

        public double getWidth() {
            return this.size.width;
        }

        public double getHeight() {
            return this.size.height;
        }

        @NotNull
        public Point getCenter() {
            Point point = this.center;
            if (point == null) {
                NodeLayout.$$$reportNull$$$0(4);
            }
            return point;
        }

        @NotNull
        public Size getSize() {
            Size size = this.size;
            if (size == null) {
                NodeLayout.$$$reportNull$$$0(5);
            }
            return size;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NodeLayout layout = (NodeLayout)o;
            if (!this.center.equals(layout.center)) {
                return false;
            }
            return this.size.equals(layout.size);
        }

        public int hashCode() {
            int result = this.center.hashCode();
            result = 31 * result + this.size.hashCode();
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "size";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "center";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/jboss/jbpm/layout/ChartLayoutCoordinator$NodeLayout";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/jboss/jbpm/layout/ChartLayoutCoordinator$NodeLayout";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCenter";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSize";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createByCenterPoint";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class Size {
        public final double width;
        public final double height;

        public Size(double width, double height) {
            this.width = width;
            this.height = height;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Size size = (Size)o;
            if (Double.compare(size.width, this.width) != 0) {
                return false;
            }
            return Double.compare(size.height, this.height) == 0;
        }

        public int hashCode() {
            long temp = Double.doubleToLongBits(this.width);
            int result = (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.height);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            return result;
        }
    }

    public static class Point {
        public final double x;
        public final double y;

        public Point(double x, double y) {
            this.x = x;
            this.y = y;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Point point = (Point)o;
            if (Double.compare(point.x, this.x) != 0) {
                return false;
            }
            return Double.compare(point.y, this.y) == 0;
        }

        public int hashCode() {
            long temp = Double.doubleToLongBits(this.x);
            int result = (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.y);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            return result;
        }
    }
}

