/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jboss.jbpm.model;

import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.jboss.jbpm.model.ChartDataModel;
import com.intellij.jboss.jbpm.model.ChartEdge;
import com.intellij.jboss.jbpm.model.ChartNode;
import com.intellij.jboss.jbpm.model.ChartSource;
import com.intellij.jboss.jbpm.settings.ChartProvider;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class ChartDataModelImpl<T, Node extends ChartNode<T>, Edge extends ChartEdge<T>, Source extends ChartSource>
extends ChartDataModel<T> {
    private Map<String, Node> nodes;
    private HashMap<Pair<String, String>, Edge> edges;
    @NotNull
    private final Source source;

    public ChartDataModelImpl(Project project, ChartProvider<T> provider, @NotNull Source source) {
        if (source == null) {
            ChartDataModelImpl.$$$reportNull$$$0(0);
        }
        super(project, provider);
        this.nodes = new HashMap<String, Node>();
        this.edges = new HashMap();
        this.source = source;
    }

    @Override
    @NotNull
    public Collection<Node> getNodes() {
        Collection<Node> collection = this.nodes.values();
        if (collection == null) {
            ChartDataModelImpl.$$$reportNull$$$0(1);
        }
        return collection;
    }

    @Override
    @NotNull
    public Collection<Edge> getEdges() {
        Collection<Edge> collection = this.edges.values();
        if (collection == null) {
            ChartDataModelImpl.$$$reportNull$$$0(2);
        }
        return collection;
    }

    public void refreshDataModel() {
        this.nodes.clear();
        this.edges.clear();
        this.updateDataModel();
    }

    protected Node addNode(Node node) {
        String nodeId = ((ChartNode)((Object)node)).getId();
        if (!StringUtil.isNotEmpty((String)nodeId)) {
            return null;
        }
        assert (!this.nodes.containsKey(nodeId));
        this.nodes.put(nodeId, node);
        return node;
    }

    protected Edge addEdge(Edge edge) {
        ChartNode source = ((ChartEdge)((Object)edge)).getSource();
        ChartNode target = ((ChartEdge)((Object)edge)).getTarget();
        this.edges.put((Pair<String, String>)Pair.create((Object)source.getId(), (Object)target.getId()), edge);
        return edge;
    }

    public void removeNode(DiagramNode<T> node) {
        Runnable action = this.getRemoveNodeAction((ChartNode)node);
        if (action == null) {
            return;
        }
        action.run();
    }

    @NotNull
    public final Edge createEdge(final @NotNull DiagramNode<T> from, final @NotNull DiagramNode<T> to) {
        if (from == null) {
            ChartDataModelImpl.$$$reportNull$$$0(3);
        }
        if (to == null) {
            ChartDataModelImpl.$$$reportNull$$$0(4);
        }
        assert (from instanceof ChartNode);
        assert (to instanceof ChartNode);
        ChartEdge chartEdge = (ChartEdge)((Object)new WriteCommandAction<Edge>(this.getProject(), "Add " + this.getProvider().getChartName() + "  edge", new PsiFile[]{this.getSource().getPsiFile()}){

            protected void run(@NotNull Result<Edge> result) throws Throwable {
                if (result == null) {
                    1.$$$reportNull$$$0(0);
                }
                result.setResult(ChartDataModelImpl.this.createEdge((ChartNode)from, (ChartNode)to));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/jboss/jbpm/model/ChartDataModelImpl$1", "run"));
            }
        }.execute().getResultObject());
        if (chartEdge == null) {
            ChartDataModelImpl.$$$reportNull$$$0(5);
        }
        return (Edge)((Object)chartEdge);
    }

    public abstract Edge createEdge(Node var1, Node var2);

    @Override
    public void removeEdge(DiagramEdge<T> edge) {
        final Runnable action = this.getRemoveEdgeAction((ChartEdge)edge);
        if (action == null) {
            return;
        }
        new WriteCommandAction<Void>(this.getProject(), "Remove " + this.getProvider().getChartName() + " edge", new PsiFile[]{this.source.getPsiFile()}){

            protected void run(@NotNull Result<Void> result) throws Throwable {
                if (result == null) {
                    2.$$$reportNull$$$0(0);
                }
                action.run();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/jboss/jbpm/model/ChartDataModelImpl$2", "run"));
            }
        }.execute();
    }

    protected Runnable getRemoveNodeAction(Node node) {
        String nodeId = ((ChartNode)((Object)node)).getId();
        if (!StringUtil.isNotEmpty((String)nodeId)) {
            return null;
        }
        this.nodes.remove(nodeId);
        List edgeKeys = JBIterable.from(this.edges.keySet()).filter(pair -> nodeId.equals(pair.first) || nodeId.equals(pair.second)).toList();
        List edges = JBIterable.from((Iterable)edgeKeys).transform(pair -> (ChartEdge)((Object)((Object)this.edges.get(pair)))).toList();
        for (Pair pair2 : edgeKeys) {
            this.edges.remove(pair2);
        }
        return () -> {
            for (ChartEdge edge : edges) {
                edge.removeSelf();
            }
            node.removeSelf();
        };
    }

    protected Runnable getRemoveEdgeAction(Edge edge) {
        ChartNode source = ((ChartEdge)((Object)edge)).getSource();
        ChartNode target = ((ChartEdge)((Object)edge)).getTarget();
        this.edges.remove(Pair.create((Object)source.getId(), (Object)target.getId()));
        return () -> edge.removeSelf();
    }

    protected abstract void updateDataModel();

    public Edge getEdge(Pair<String, String> pair) {
        return (Edge)((Object)((ChartEdge)((Object)this.edges.get(pair))));
    }

    public Node getNode(String fqn) {
        return (Node)((Object)((ChartNode)((Object)this.nodes.get(fqn))));
    }

    @NotNull
    protected Source getSource() {
        Source Source = this.source;
        if (Source == null) {
            ChartDataModelImpl.$$$reportNull$$$0(6);
        }
        return Source;
    }

    @NotNull
    public ModificationTracker getModificationTracker() {
        ChartDataModelImpl chartDataModelImpl = this;
        if (chartDataModelImpl == null) {
            ChartDataModelImpl.$$$reportNull$$$0(7);
        }
        return chartDataModelImpl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jboss/jbpm/model/ChartDataModelImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jboss/jbpm/model/ChartDataModelImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodes";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdges";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createEdge";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSource";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getModificationTracker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createEdge";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

