/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vaadin.framework;

import com.intellij.gwt.sdk.GwtVersion;
import com.intellij.gwt.sdk.impl.GwtVersionImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.text.VersionComparatorUtil;
import com.intellij.vaadin.framework.VaadinVersion;
import com.intellij.vaadin.framework.VaadinVersionImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VaadinVersionUtil {
    @NotNull
    public static VaadinVersion getVaadinVersion(@NotNull Module module) {
        VaadinVersion version;
        if (module == null) {
            VaadinVersionUtil.$$$reportNull$$$0(0);
        }
        VaadinVersion vaadinVersion = (version = VaadinVersionUtil.getVersionOrNull(module)) != null ? version : VaadinVersionUtil.getDefaultVersion();
        if (vaadinVersion == null) {
            VaadinVersionUtil.$$$reportNull$$$0(1);
        }
        return vaadinVersion;
    }

    @NotNull
    public static VaadinVersion getDefaultVersion() {
        VaadinVersionImpl vaadinVersionImpl = VaadinVersionImpl.V7_OR_LATER;
        if (vaadinVersionImpl == null) {
            VaadinVersionUtil.$$$reportNull$$$0(2);
        }
        return vaadinVersionImpl;
    }

    public static VaadinVersion[] getAllVersions() {
        return VaadinVersionImpl.values();
    }

    @Nullable
    private static VaadinVersion getVersionOrNull(@NotNull Module module) {
        if (module == null) {
            VaadinVersionUtil.$$$reportNull$$$0(3);
        }
        return (VaadinVersion)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            if (module == null) {
                VaadinVersionUtil.$$$reportNull$$$0(12);
            }
            GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)module.getProject());
            Object[] dependencies = new Object[]{ProjectRootManager.getInstance((Project)module.getProject())};
            for (VaadinVersion version : VaadinVersionUtil.getAllVersions()) {
                if (psiFacade.findClass(version.getServletClass(), scope) == null) continue;
                return CachedValueProvider.Result.create((Object)version, (Object[])dependencies);
            }
            return CachedValueProvider.Result.create(null, (Object[])dependencies);
        });
    }

    public static boolean hasVaadinFramework(@NotNull Module module) {
        if (module == null) {
            VaadinVersionUtil.$$$reportNull$$$0(4);
        }
        return VaadinVersionUtil.getVersionOrNull(module) != null;
    }

    @Nullable
    private static VirtualFile findVaadinJar(@NotNull Module module) {
        VaadinVersion version;
        if (module == null) {
            VaadinVersionUtil.$$$reportNull$$$0(5);
        }
        if ((version = VaadinVersionUtil.getVersionOrNull(module)) == null) {
            return null;
        }
        GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
        PsiClass aClass = JavaPsiFacade.getInstance((Project)module.getProject()).findClass(version.getServletClass(), scope);
        if (aClass == null) {
            return null;
        }
        PsiFile file = aClass.getContainingFile();
        if (file == null) {
            return null;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)module.getProject()).getFileIndex();
        VirtualFile root = index.getClassRootForFile(virtualFile);
        return VfsUtilCore.getVirtualFileForJar((VirtualFile)root);
    }

    @Nullable
    public static String detectVaadinHome(@NotNull Module module) {
        VirtualFile jar;
        if (module == null) {
            VaadinVersionUtil.$$$reportNull$$$0(6);
        }
        return (jar = VaadinVersionUtil.findVaadinJar(module)) != null ? jar.getParent().getPath() : null;
    }

    @NotNull
    public static GwtVersion getGwtVersion(@Nullable String vaadinVersion) {
        if (vaadinVersion == null) {
            GwtVersionImpl gwtVersionImpl = GwtVersionImpl.VERSION_2_7;
            if (gwtVersionImpl == null) {
                VaadinVersionUtil.$$$reportNull$$$0(7);
            }
            return gwtVersionImpl;
        }
        if (VersionComparatorUtil.compare((String)vaadinVersion, (String)"7.2.0") < 0) {
            GwtVersionImpl gwtVersionImpl = GwtVersionImpl.VERSION_2_5;
            if (gwtVersionImpl == null) {
                VaadinVersionUtil.$$$reportNull$$$0(8);
            }
            return gwtVersionImpl;
        }
        if (VersionComparatorUtil.compare((String)vaadinVersion, (String)"7.4.0") < 0) {
            GwtVersionImpl gwtVersionImpl = GwtVersionImpl.VERSION_2_6;
            if (gwtVersionImpl == null) {
                VaadinVersionUtil.$$$reportNull$$$0(9);
            }
            return gwtVersionImpl;
        }
        if (VersionComparatorUtil.compare((String)vaadinVersion, (String)"8.0.0") < 0) {
            GwtVersionImpl gwtVersionImpl = GwtVersionImpl.VERSION_2_7;
            if (gwtVersionImpl == null) {
                VaadinVersionUtil.$$$reportNull$$$0(10);
            }
            return gwtVersionImpl;
        }
        GwtVersionImpl gwtVersionImpl = GwtVersionImpl.VERSION_2_8;
        if (gwtVersionImpl == null) {
            VaadinVersionUtil.$$$reportNull$$$0(11);
        }
        return gwtVersionImpl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vaadin/framework/VaadinVersionUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vaadin/framework/VaadinVersionUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getVaadinVersion";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultVersion";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getGwtVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getVaadinVersion";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getVersionOrNull";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "hasVaadinFramework";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findVaadinJar";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "detectVaadinHome";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getVersionOrNull$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

