/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.fxom;

import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMIntrinsic;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javafx.scene.control.ToggleGroup;

public class FXOMFxIdIndex {
    private final FXOMDocument fxomDocument;
    private final Map<String, FXOMObject> fxIds;

    public FXOMFxIdIndex(FXOMDocument fxomDocument) {
        assert (fxomDocument != null);
        this.fxomDocument = fxomDocument;
        this.fxIds = fxomDocument.collectFxIds();
    }

    public FXOMDocument getFxomDocument() {
        return this.fxomDocument;
    }

    public FXOMObject lookup(String fxId) {
        assert (fxId != null);
        return this.fxIds.get(fxId);
    }

    public Map<String, FXOMObject> getFxIds() {
        return this.fxIds;
    }

    public List<FXOMInstance> collectToggleGroups() {
        ArrayList<FXOMInstance> result = new ArrayList<FXOMInstance>();
        for (Map.Entry<String, FXOMObject> e : this.fxIds.entrySet()) {
            FXOMInstance fxomInstance;
            FXOMObject fxomObject = e.getValue();
            if (!(fxomObject instanceof FXOMInstance) || (fxomInstance = (FXOMInstance)fxomObject).getDeclaredClass() != ToggleGroup.class) continue;
            result.add(fxomInstance);
        }
        return result;
    }

    public boolean isSelfContained(FXOMObject fxomObject) {
        List<FXOMIntrinsic> references = fxomObject.collectReferences(null);
        int externalCount = 0;
        for (FXOMIntrinsic reference : references) {
            assert (reference.getSource() != null);
            FXOMObject target = this.fxIds.get(reference.getSource());
            assert (target != null);
            if (target.isDescendantOf(fxomObject)) continue;
            ++externalCount;
        }
        return externalCount == 0;
    }

    public static boolean isSelfContainedObject(FXOMObject fxomObject) {
        FXOMFxIdIndex fxomIndex = new FXOMFxIdIndex(fxomObject.getFxomDocument());
        return fxomIndex.isSelfContained(fxomObject);
    }
}

