/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.common.datareducer;

import com.android.tools.adtui.chart.linechart.LineConfig;
import com.android.tools.adtui.common.datareducer.DataReducer;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import org.jetbrains.annotations.NotNull;

public class LineChartReducer
implements DataReducer {
    private static final float EPS = 1.0E-6f;
    private static int PATH_ITERATOR_COORDS_COUNT = 6;

    @Override
    public Path2D reduce(@NotNull Path2D path, @NotNull LineConfig config) {
        if (path == null) {
            LineChartReducer.$$$reportNull$$$0(0);
        }
        if (config == null) {
            LineChartReducer.$$$reportNull$$$0(1);
        }
        if (path.getCurrentPoint() == null) {
            return path;
        }
        Path2D.Float resultPath = new Path2D.Float();
        float[] coords = new float[PATH_ITERATOR_COORDS_COUNT];
        float pixel = -1.0f;
        float minX = -1.0f;
        float minY = -1.0f;
        float maxX = -1.0f;
        float maxY = -1.0f;
        float curX = -1.0f;
        float curY = -1.0f;
        int minIndex = -1;
        int maxIndex = -1;
        int curIndex = 0;
        PathIterator iterator = path.getPathIterator(null);
        while (!iterator.isDone()) {
            int segType = iterator.currentSegment(coords);
            assert (segType == 0 || segType == 1);
            float lastX = curX;
            float lastY = curY;
            curX = coords[0];
            curY = coords[1];
            if (curIndex > 0 && curX < lastX) {
                assert (LineChartReducer.equals(maxX, lastX) && LineChartReducer.equals(maxY, lastY));
                break;
            }
            if (curIndex == 0 || curX >= pixel) {
                if (curIndex > 0) {
                    LineChartReducer.addMinMaxPoints(resultPath, config, minIndex, minX, minY, maxIndex, maxX, maxY);
                    LineChartReducer.addToResultPath(resultPath, config, lastX, lastY);
                }
                pixel = (float)Math.floor(curX) + 1.0f;
                minX = maxX = curX;
                minY = maxY = curY;
                minIndex = maxIndex = curIndex;
                LineChartReducer.addToResultPath(resultPath, config, curX, curY);
            } else {
                if (minY > curY) {
                    minIndex = curIndex;
                    minX = curX;
                    minY = curY;
                }
                if (maxY <= curY) {
                    maxIndex = curIndex;
                    maxX = curX;
                    maxY = curY;
                }
            }
            iterator.next();
            ++curIndex;
        }
        LineChartReducer.addMinMaxPoints(resultPath, config, minIndex, minX, minY, maxIndex, maxX, maxY);
        LineChartReducer.addToResultPath(resultPath, config, curX, curY);
        if (config.isStepped() && (resultPath.getCurrentPoint() == null || LineChartReducer.equals((float)resultPath.getCurrentPoint().getY(), curY))) {
            LineChartReducer.addToPath(resultPath, curX, curY);
        }
        return resultPath;
    }

    private static void addMinMaxPoints(@NotNull Path2D path, @NotNull LineConfig config, int minIndex, float minX, float minY, int maxIndex, float maxX, float maxY) {
        if (path == null) {
            LineChartReducer.$$$reportNull$$$0(2);
        }
        if (config == null) {
            LineChartReducer.$$$reportNull$$$0(3);
        }
        if (minIndex < maxIndex) {
            LineChartReducer.addToResultPath(path, config, minX, minY, maxX, maxY);
        } else {
            LineChartReducer.addToResultPath(path, config, maxX, maxY, minX, minY);
        }
    }

    private static void addToResultPath(@NotNull Path2D path, @NotNull LineConfig config, float ... coords) {
        if (path == null) {
            LineChartReducer.$$$reportNull$$$0(4);
        }
        if (config == null) {
            LineChartReducer.$$$reportNull$$$0(5);
        }
        assert (coords.length % 2 == 0);
        for (int i = 0; i < coords.length; i += 2) {
            float x = coords[i];
            float y = coords[i + 1];
            if (config.isStepped()) {
                LineChartReducer.addToSteppedLinePath(path, x, y);
                continue;
            }
            LineChartReducer.addToPath(path, x, y);
        }
    }

    private static void addToSteppedLinePath(@NotNull Path2D path, float x, float y) {
        if (path == null) {
            LineChartReducer.$$$reportNull$$$0(6);
        }
        if (path.getCurrentPoint() == null) {
            path.moveTo(x, y);
        } else if (!LineChartReducer.equals(y, (float)path.getCurrentPoint().getY())) {
            LineChartReducer.addToPath(path, x, (float)path.getCurrentPoint().getY());
            LineChartReducer.addToPath(path, x, y);
        }
    }

    private static void addToPath(@NotNull Path2D path, float x, float y) {
        if (path == null) {
            LineChartReducer.$$$reportNull$$$0(7);
        }
        if (path.getCurrentPoint() == null) {
            path.moveTo(x, y);
        } else if (!LineChartReducer.equals((float)path.getCurrentPoint().getX(), x) || !LineChartReducer.equals((float)path.getCurrentPoint().getY(), y)) {
            path.lineTo(x, y);
        }
    }

    private static boolean equals(float a, float b) {
        return Math.abs(a - b) <= 1.0E-6f;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/adtui/common/datareducer/LineChartReducer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "reduce";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addMinMaxPoints";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "addToResultPath";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "addToSteppedLinePath";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "addToPath";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

