/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts;

import com.intellij.javaee.model.xml.web.Servlet;
import com.intellij.javaee.model.xml.web.ServletMapping;
import com.intellij.javaee.model.xml.web.WebApp;
import com.intellij.javaee.web.CommonParamValue;
import com.intellij.javaee.web.CommonServletMapping;
import com.intellij.javaee.web.ServletMappingInfo;
import com.intellij.javaee.web.ServletMappingType;
import com.intellij.javaee.web.WebUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.impl.source.jsp.WebDirectoryUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.struts.StrutsModel;
import com.intellij.struts.StrutsModelImpl;
import com.intellij.struts.WebDomFactory;
import com.intellij.struts.dom.StrutsConfig;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.GenericDomValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StrutsDomFactory
extends WebDomFactory<StrutsConfig, StrutsModel> {
    @NonNls
    private static final String CONFIG = "config";
    @NonNls
    private static final String CONFIG_PREFIX = "config/";

    public StrutsDomFactory(Project project) {
        super(StrutsConfig.class, project, "Struts");
    }

    @Nullable
    protected List<StrutsModel> computeAllModels(@NotNull Module module) {
        if (module == null) {
            StrutsDomFactory.$$$reportNull$$$0(0);
        }
        Collection webFacets = WebFacet.getInstances((Module)module);
        ArrayList<StrutsModel> models = new ArrayList<StrutsModel>();
        for (WebFacet webFacet : webFacets) {
            List<StrutsModel> strutsModels = this.computeAllModels(webFacet);
            if (strutsModels == null) continue;
            models.addAll(strutsModels);
        }
        return models;
    }

    protected StrutsModel computeModel(@NotNull XmlFile psiFile, @Nullable Module module) {
        DomFileElement dom;
        StrutsModel model;
        if (psiFile == null) {
            StrutsDomFactory.$$$reportNull$$$0(1);
        }
        if ((model = (StrutsModel)super.computeModel(psiFile, (UserDataHolder)module)) != null) {
            return model;
        }
        WebFacet webFacet = WebUtil.getWebFacet((PsiElement)psiFile);
        if (webFacet == null) {
            return null;
        }
        ServletMappingInfo info = StrutsDomFactory.findStrutsMapping(webFacet);
        if (info != null && (dom = this.getDomRoot(psiFile)) != null) {
            return new StrutsModelImpl(Collections.singleton(psiFile), (DomFileElement<StrutsConfig>)dom, info, "/", null);
        }
        return null;
    }

    @Nullable
    private List<StrutsModel> computeAllModels(@NotNull WebFacet webFacet) {
        ServletMappingInfo mappingInfo;
        if (webFacet == null) {
            StrutsDomFactory.$$$reportNull$$$0(2);
        }
        if ((mappingInfo = StrutsDomFactory.findStrutsMapping(webFacet)) == null) {
            return null;
        }
        List parameters = mappingInfo.getServlet().getInitParams();
        ArrayList<StrutsModel> strutsModels = new ArrayList<StrutsModel>();
        block0: for (CommonParamValue parameter : parameters) {
            DomFileElement mergedModel;
            String[] paths;
            String parameterName = (String)parameter.getParamName().getValue();
            if (parameterName == null) continue;
            String modulePath = null;
            if (parameterName.startsWith(CONFIG_PREFIX)) {
                modulePath = parameterName.substring(CONFIG_PREFIX.length() - 1);
            } else if (CONFIG.equals(parameterName)) {
                modulePath = "/";
            }
            if (modulePath == null) continue;
            for (StrutsModel model : strutsModels) {
                if (!model.getModulePrefix().equals(modulePath)) continue;
                continue block0;
            }
            String configList = (String)parameter.getParamValue().getValue();
            if (configList == null) continue;
            LinkedHashSet<XmlFile> configFiles = new LinkedHashSet<XmlFile>();
            for (String path : paths = configList.split(",")) {
                PsiFileSystemItem file = WebDirectoryUtil.getWebDirectoryUtil((Project)webFacet.getModule().getProject()).findFileByPath(path.trim(), webFacet);
                if (!(file instanceof XmlFile)) continue;
                configFiles.add((XmlFile)file);
            }
            if (configFiles.size() <= 0 || (mergedModel = this.createMergedModelRoot(configFiles)) == null) continue;
            PsiElement tag = parameter.getIdentifyingPsiElement();
            assert (tag != null);
            StrutsModelImpl model = new StrutsModelImpl(configFiles, (DomFileElement<StrutsConfig>)mergedModel, mappingInfo, modulePath, tag);
            strutsModels.add(model);
        }
        return strutsModels;
    }

    @Nullable
    private static ServletMappingInfo findStrutsMapping(@NotNull WebFacet webFacet) {
        WebApp webApp;
        if (webFacet == null) {
            StrutsDomFactory.$$$reportNull$$$0(3);
        }
        if ((webApp = webFacet.getRoot()) == null) {
            return null;
        }
        Servlet actionServlet = StrutsDomFactory.findActionServlet(webApp);
        if (actionServlet == null) {
            return null;
        }
        ServletMapping strutsMapping = null;
        for (ServletMapping mapping : webApp.getServletMappings()) {
            if (!actionServlet.equals(mapping.getServletName().getValue())) continue;
            strutsMapping = mapping;
            break;
        }
        if (strutsMapping == null) {
            return null;
        }
        List list = strutsMapping.getUrlPatterns();
        if (list.size() == 0) {
            return null;
        }
        String urlPattern = ((GenericDomValue)list.get(0)).getStringValue();
        if (urlPattern == null) {
            return null;
        }
        ServletMappingInfo mappingInfo = ServletMappingType.getPatternType((String)urlPattern).createMappingInfo(urlPattern, (CommonServletMapping)strutsMapping);
        if (mappingInfo.getType() == ServletMappingType.EXACT) {
            return null;
        }
        return mappingInfo;
    }

    protected StrutsModel createCombinedModel(@NotNull Set<XmlFile> configFiles, @NotNull DomFileElement<StrutsConfig> mergedModel, StrutsModel firstModel, Module module) {
        if (configFiles == null) {
            StrutsDomFactory.$$$reportNull$$$0(4);
        }
        if (mergedModel == null) {
            StrutsDomFactory.$$$reportNull$$$0(5);
        }
        return new StrutsModelImpl(configFiles, mergedModel, firstModel.getServletMappingInfo(), "/", firstModel.getConfigurationTag());
    }

    @Nullable
    private static Servlet findActionServlet(@NotNull WebApp webApp) {
        if (webApp == null) {
            StrutsDomFactory.$$$reportNull$$$0(6);
        }
        PsiClass actionServletClass = null;
        List servlets = webApp.getServlets();
        for (Servlet servlet : servlets) {
            String stringValue;
            PsiClass servletPsiClass = (PsiClass)servlet.getServletClass().getValue();
            if (servletPsiClass != null) {
                if (actionServletClass == null) {
                    GlobalSearchScope scope = servlet.getResolveScope();
                    actionServletClass = JavaPsiFacade.getInstance((Project)servletPsiClass.getProject()).findClass("org.apache.struts.action.ActionServlet", scope);
                    if (actionServletClass == null) {
                        return null;
                    }
                }
                if (InheritanceUtil.isInheritorOrSelf((PsiClass)servletPsiClass, actionServletClass, (boolean)true)) {
                    return servlet;
                }
            }
            if ((stringValue = servlet.getServletClass().getStringValue()) == null || !stringValue.equals("org.apache.struts.action.ActionServlet")) continue;
            return servlet;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "webFacet";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFiles";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mergedModel";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "webApp";
                break;
            }
        }
        objectArray2[1] = "com/intellij/struts/StrutsDomFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "computeAllModels";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "computeModel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findStrutsMapping";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "createCombinedModel";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "findActionServlet";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

