/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.components;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramCategory;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.DiagramVisibilityManager;
import com.intellij.diagram.VisibilityLevel;
import com.intellij.diagram.components.DiagramNodeElementComponent;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.psi.PsiElement;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBList;
import com.intellij.util.ArrayUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DiagramNodeBodyComponent
extends JBList
implements ListCellRenderer {
    private static JComponent ourSeparatorComponent = new JPanel();
    private final DiagramNodeElementComponent myValueComponent = new DiagramNodeElementComponent();
    private final DiagramBuilder myBuilder;
    private final Point myBasePoint;
    private DiagramNode myNode;

    public DiagramNodeBodyComponent(DiagramNode node, DiagramBuilder builder, Point point) {
        super(DiagramNodeBodyComponent.getNodeElements(node.getIdentifyingElement(), builder));
        this.myNode = node;
        this.myBuilder = builder;
        this.myBasePoint = point;
        this.disableEmptyText();
        this.setCellRenderer(this);
        this.setBackground(this.myBuilder.getProvider().getColorManager().getNodeBackground(builder.getProject(), node.getIdentifyingElement(), false));
        this.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int index;
                if (DiagramNodeBodyComponent.this.getSelectedValue() == null && (index = DiagramNodeBodyComponent.this.getSelectedIndex()) != -1) {
                    DiagramNodeBodyComponent.this.setSelectedIndex(index + (e.getLastIndex() == index ? 1 : -1));
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){
            boolean myIsEngaged = false;

            @Override
            public void mouseMoved(MouseEvent e) {
                if (this.myIsEngaged && !DiagramNodeBodyComponent.this.getComponentPopupMenu().isVisible()) {
                    Point point = e.getPoint();
                    int index = DiagramNodeBodyComponent.this.locationToIndex(point);
                    DiagramNodeBodyComponent.this.setSelectedIndex(index);
                } else {
                    this.myIsEngaged = true;
                }
            }
        });
        ActionGroup group = (ActionGroup)ActionManager.getInstance().getAction("Uml.NodeCellEditorPopup");
        ActionPopupMenu menu = ActionManager.getInstance().createActionPopupMenu("StructureViewPopup", group);
        this.setComponentPopupMenu(menu.getComponent());
        this.setExpandableItemsEnabled(false);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (value == null) {
            return ourSeparatorComponent;
        }
        this.myValueComponent.setUp(this.myBuilder, this.myNode, value, isSelected, this.getElementColor(value));
        this.myValueComponent.setSelected(isSelected);
        return this.myValueComponent;
    }

    public Color getElementColor(Object element) {
        PsiElement key;
        if (element instanceof PsiElement && !(key = (PsiElement)element).isPhysical()) {
            return JBColor.GRAY;
        }
        return JBColor.foreground();
    }

    public Point getPopupLocation(MouseEvent event) {
        Point p = this.myBuilder.getView().getCanvasComponent().getLocationOnScreen();
        return new Point(this.myBasePoint.x - p.x + event.getX(), this.myBasePoint.y - p.y + event.getY());
    }

    /*
     * Could not resolve type clashes
     */
    public static Object[] getNodeElements(Object element, DiagramBuilder builder) {
        ArrayList<Object> elements = new ArrayList<Object>();
        DiagramProvider umlProvider = builder.getProvider();
        DiagramVisibilityManager visibilityManager = builder.getDataModel().getVisibilityManager();
        VisibilityLevel visibility = visibilityManager.getCurrentVisibilityLevel();
        Comparator<VisibilityLevel> comparator = visibilityManager.getComparator();
        List<DiagramCategory> enabled = Arrays.asList(builder.getPresentation().getEnabledCategories());
        Object[] elems = umlProvider.getElementManager().getNodeItems(element);
        DiagramCategory[] categories = umlProvider.getNodeContentManager().getContentCategories();
        if (categories.length != 0) {
            for (DiagramCategory category : categories) {
                if (!enabled.contains(category)) continue;
                ArrayList<Object> nodeElements = new ArrayList<Object>();
                for (Object elem : elems) {
                    if (!umlProvider.getNodeContentManager().isInCategory(elem, category, builder.getPresentation())) continue;
                    nodeElements.add(elem);
                }
                if (nodeElements.isEmpty()) continue;
                boolean added = false;
                for (Object nodeElement : nodeElements) {
                    VisibilityLevel level = visibilityManager.getVisibilityLevel(nodeElement);
                    if (comparator.compare(level, visibility) > 0) continue;
                    elements.add(nodeElement);
                    added = true;
                }
                if (!added) continue;
                elements.add(null);
            }
        } else {
            elements.addAll(Arrays.asList(elems));
        }
        if (!elements.isEmpty() && elements.get(elements.size() - 1) == null) {
            elements.remove(elements.size() - 1);
        }
        return ArrayUtil.toObjectArray(elements);
    }

    static {
        ourSeparatorComponent.setBackground((Color)JBColor.GRAY);
        ourSeparatorComponent.setPreferredSize(new Dimension(-1, 1));
    }
}

