/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.android.configure;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinPluginUtil;
import org.jetbrains.kotlin.idea.configuration.GradleBuildScriptManipulator;
import org.jetbrains.kotlin.idea.configuration.KotlinWithGradleConfigurator;
import org.jetbrains.kotlin.idea.util.projectStructure.ProjectStructureUtilKt;
import org.jetbrains.kotlin.idea.versions.KotlinRuntimeLibraryUtilKt;
import org.jetbrains.kotlin.resolve.TargetPlatform;
import org.jetbrains.kotlin.resolve.jvm.platform.JvmPlatform;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0002J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0004H\u0014J\u001a\u0010\u0015\u001a\u00020\u00042\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0014\u001a\u00020\u0004H\u0014J\u0010\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/android/configure/KotlinAndroidGradleModuleConfigurator;", "Lorg/jetbrains/kotlin/idea/configuration/KotlinWithGradleConfigurator;", "()V", "kotlinPluginName", "", "getKotlinPluginName", "()Ljava/lang/String;", "name", "getName", "presentableText", "getPresentableText", "targetPlatform", "Lorg/jetbrains/kotlin/resolve/TargetPlatform;", "getTargetPlatform", "()Lorg/jetbrains/kotlin/resolve/TargetPlatform;", "addElementsToFile", "", "file", "Lcom/intellij/psi/PsiFile;", "isTopLevelProjectFile", "version", "getStdlibArtifactName", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "isApplicable", "module", "Lcom/intellij/openapi/module/Module;", "Companion", "idea-android"})
public final class KotlinAndroidGradleModuleConfigurator
extends KotlinWithGradleConfigurator {
    @NotNull
    private final String name = org.jetbrains.kotlin.android.configure.KotlinAndroidGradleModuleConfigurator$Companion.access$getNAME$p(Companion);
    @NotNull
    private final TargetPlatform targetPlatform = JvmPlatform.INSTANCE;
    @NotNull
    private final String presentableText = "Android with Gradle";
    @NotNull
    private final String kotlinPluginName = org.jetbrains.kotlin.android.configure.KotlinAndroidGradleModuleConfigurator$Companion.access$getKOTLIN_ANDROID$p(Companion);
    private static final String NAME = "android-gradle";
    private static final String KOTLIN_ANDROID = "kotlin-android";
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public TargetPlatform getTargetPlatform() {
        return this.targetPlatform;
    }

    @Override
    @NotNull
    public String getPresentableText() {
        return this.presentableText;
    }

    @Override
    public boolean isApplicable(@NotNull Module module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        return KotlinPluginUtil.isAndroidGradleModule(module);
    }

    @Override
    @NotNull
    protected String getKotlinPluginName() {
        return this.kotlinPluginName;
    }

    @Override
    protected boolean addElementsToFile(@NotNull PsiFile file2, boolean isTopLevelProjectFile, @NotNull String version) {
        Sdk sdk;
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        GradleBuildScriptManipulator manipulator = KotlinWithGradleConfigurator.Companion.getManipulator(file2);
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)((PsiElement)file2));
        if (module != null) {
            Module module2;
            Module it = module2 = module;
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)it);
            Intrinsics.checkExpressionValueIsNotNull((Object)moduleRootManager, (String)"ModuleRootManager.getInstance(it)");
            sdk = moduleRootManager.getSdk();
        } else {
            sdk = null;
        }
        Sdk sdk2 = sdk;
        String jvmTarget = this.getJvmTarget(sdk2, version);
        return isTopLevelProjectFile ? manipulator.configureProjectBuildScript(version) : manipulator.configureModuleBuildScript(this.getKotlinPluginName(), this.getStdlibArtifactName(sdk2, version), version, jvmTarget);
    }

    @Override
    @NotNull
    protected String getStdlibArtifactName(@Nullable Sdk sdk, @NotNull String version) {
        JavaSdkVersion sdkVersion;
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        if (sdk != null && KotlinRuntimeLibraryUtilKt.hasJreSpecificRuntime(version) && (sdkVersion = ProjectStructureUtilKt.getVersion(sdk)) != null && sdkVersion.isAtLeast(JavaSdkVersion.JDK_1_8)) {
            return KotlinRuntimeLibraryUtilKt.getMAVEN_STDLIB_ID_JDK7();
        }
        return super.getStdlibArtifactName(sdk, version);
    }

    static {
        NAME = NAME;
        KOTLIN_ANDROID = KOTLIN_ANDROID;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/android/configure/KotlinAndroidGradleModuleConfigurator$Companion;", "", "()V", "KOTLIN_ANDROID", "", "getKOTLIN_ANDROID", "()Ljava/lang/String;", "NAME", "getNAME", "idea-android"})
    public static final class Companion {
        private final String getNAME() {
            return NAME;
        }

        private final String getKOTLIN_ANDROID() {
            return KOTLIN_ANDROID;
        }

        private Companion() {
        }

        @NotNull
        public static final /* synthetic */ String access$getNAME$p(Companion $this) {
            return $this.getNAME();
        }

        @NotNull
        public static final /* synthetic */ String access$getKOTLIN_ANDROID$p(Companion $this) {
            return $this.getKOTLIN_ANDROID();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

