/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.daemon.impl.quickfix.OrderEntryFix;
import com.intellij.ide.actions.OpenFileAction;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExternalLibraryDescriptor;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.WritingAccessProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmSuppressWildcards;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.CoroutineSupport;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.idea.KotlinPluginUtil;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinStatus;
import org.jetbrains.kotlin.idea.configuration.GradleBuildScriptManipulator;
import org.jetbrains.kotlin.idea.configuration.GroovyBuildScriptManipulator;
import org.jetbrains.kotlin.idea.configuration.KotlinBuildScriptManipulator;
import org.jetbrains.kotlin.idea.configuration.KotlinProjectConfigurator;
import org.jetbrains.kotlin.idea.configuration.ModuleSourceRootGroup;
import org.jetbrains.kotlin.idea.configuration.NotificationMessageCollector;
import org.jetbrains.kotlin.idea.configuration.NotificationMessageCollectorKt;
import org.jetbrains.kotlin.idea.facet.KotlinVersionInfoProviderKt;
import org.jetbrains.kotlin.idea.framework.ui.ConfigureDialogWithModulesAndVersion;
import org.jetbrains.kotlin.idea.quickfix.ChangeCoroutineSupportFix;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.idea.versions.KotlinRuntimeLibraryUtilKt;
import org.jetbrains.kotlin.idea.versions.LibraryJarDescriptor;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 >2\u00020\u0001:\u0001>B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u0004H\u0014J.\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0016J\u0018\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u001e\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00100\u001fH\u0017J(\u0010 \u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010!\u001a\u00020\"H\u0002J>\u0010#\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010!\u001a\u00020\"2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\n0%H\u0016J\u0018\u0010&\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0004H\u0004J2\u0010'\u001a\b\u0012\u0004\u0012\u00020\n0(2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00100\u00162\u0006\u0010*\u001a\u00020\u00042\u0006\u0010!\u001a\u00020\"J\u001c\u0010+\u001a\u0004\u0018\u00010\u00042\b\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010\f\u001a\u00020\u0004H\u0014J\b\u0010.\u001a\u00020\u0004H\u0014J\u0010\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202H\u0016J\u001a\u00103\u001a\u00020\u00042\b\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010\f\u001a\u00020\u0004H\u0014J\u0010\u00104\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0010\u00105\u001a\u00020\b2\u0006\u00106\u001a\u00020\nH\u0002J4\u00107\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u00108\u001a\u0004\u0018\u00010\u00042\b\u00109\u001a\u0004\u0018\u00010\u00042\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020\bH\u0016J\f\u0010=\u001a\u00020\b*\u00020\nH\u0002R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006?"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/KotlinWithGradleConfigurator;", "Lorg/jetbrains/kotlin/idea/configuration/KotlinProjectConfigurator;", "()V", "kotlinPluginName", "", "getKotlinPluginName", "()Ljava/lang/String;", "addElementsToFile", "", "file", "Lcom/intellij/psi/PsiFile;", "isTopLevelProjectFile", "version", "addLibraryDependency", "", "module", "Lcom/intellij/openapi/module/Module;", "element", "Lcom/intellij/psi/PsiElement;", "library", "Lcom/intellij/openapi/roots/ExternalLibraryDescriptor;", "libraryJarDescriptors", "", "Lorg/jetbrains/kotlin/idea/versions/LibraryJarDescriptor;", "changeCoroutineConfiguration", "state", "Lorg/jetbrains/kotlin/config/LanguageFeature$State;", "configure", "project", "Lcom/intellij/openapi/project/Project;", "excludeModules", "", "configureBuildScript", "collector", "Lorg/jetbrains/kotlin/idea/configuration/NotificationMessageCollector;", "configureModule", "filesToOpen", "", "configureModuleBuildScript", "configureWithVersion", "Ljava/util/HashSet;", "modulesToConfigure", "kotlinVersion", "getJvmTarget", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "getMinimumSupportedVersion", "getStatus", "Lorg/jetbrains/kotlin/idea/configuration/ConfigureKotlinStatus;", "moduleSourceRootGroup", "Lorg/jetbrains/kotlin/idea/configuration/ModuleSourceRootGroup;", "getStdlibArtifactName", "isApplicable", "isFileConfigured", "buildScript", "updateLanguageVersion", "languageVersion", "apiVersion", "requiredStdlibVersion", "Lorg/jetbrains/kotlin/config/ApiVersion;", "forTests", "isConfiguredByAnyGradleConfigurator", "Companion", "idea-gradle"})
public abstract class KotlinWithGradleConfigurator
implements KotlinProjectConfigurator {
    @NotNull
    private static final String GROUP_ID = "org.jetbrains.kotlin";
    @NotNull
    private static final String GRADLE_PLUGIN_ID = "kotlin-gradle-plugin";
    @NotNull
    private static final String CLASSPATH = "classpath \"org.jetbrains.kotlin:kotlin-gradle-plugin:$kotlin_version\"";
    private static final String KOTLIN_BUILD_SCRIPT_NAME = "build.gradle.kts";
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public ConfigureKotlinStatus getStatus(@NotNull ModuleSourceRootGroup moduleSourceRootGroup) {
        boolean bl;
        block11: {
            boolean bl2;
            Module module;
            block10: {
                Intrinsics.checkParameterIsNotNull((Object)moduleSourceRootGroup, (String)"moduleSourceRootGroup");
                module = moduleSourceRootGroup.getBaseModule();
                if (!this.isApplicable(module)) {
                    return ConfigureKotlinStatus.NON_APPLICABLE;
                }
                Iterable $receiver$iv = moduleSourceRootGroup.getSourceRootModules();
                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    bl2 = true;
                } else {
                    for (Object element$iv : $receiver$iv) {
                        Module p1 = (Module)element$iv;
                        if (ConfigureKotlinInProjectUtilsKt.hasAnyKotlinRuntimeInScope(p1)) continue;
                        bl2 = false;
                        break block10;
                    }
                    bl2 = true;
                }
            }
            if (bl2) {
                return ConfigureKotlinStatus.CONFIGURED;
            }
            List buildFiles2 = (List)ApplicationUtilsKt.runReadAction((Function0)new Function0<List<? extends PsiFile>>(module){
                final /* synthetic */ Module $module;

                @NotNull
                public final List<PsiFile> invoke() {
                    Object[] objectArray = new PsiFile[2];
                    objectArray[0] = org.jetbrains.kotlin.idea.configuration.KotlinWithGradleConfigurator$Companion.access$getBuildScriptPsiFile(KotlinWithGradleConfigurator.Companion, this.$module);
                    Project project = this.$module.getProject();
                    Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"module.project");
                    objectArray[1] = org.jetbrains.kotlin.idea.configuration.KotlinWithGradleConfigurator$Companion.access$getTopLevelBuildScriptPsiFile(KotlinWithGradleConfigurator.Companion, project);
                    return CollectionsKt.filterNotNull((Iterable)CollectionsKt.listOf((Object[])objectArray));
                }
                {
                    this.$module = module;
                    super(0);
                }
            });
            if (buildFiles2.isEmpty()) {
                return ConfigureKotlinStatus.NON_APPLICABLE;
            }
            Iterable $receiver$iv = buildFiles2;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $receiver$iv) {
                    PsiFile it;
                    PsiFile psiFile = it = (PsiFile)element$iv;
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"it");
                    if (!this.isConfiguredByAnyGradleConfigurator(psiFile)) continue;
                    bl = false;
                    break block11;
                }
                bl = true;
            }
        }
        if (bl) {
            return ConfigureKotlinStatus.CAN_BE_CONFIGURED;
        }
        return ConfigureKotlinStatus.BROKEN;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isConfiguredByAnyGradleConfigurator(@NotNull PsiFile $receiver) {
        boolean bl;
        block4: {
            void $receiver$iv$iv;
            Object[] objectArray = Extensions.getExtensions(KotlinProjectConfigurator.Companion.getEP_NAME());
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"Extensions.getExtensions\u2026jectConfigurator.EP_NAME)");
            Object $receiver$iv = objectArray;
            Object object = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            for (int i = 0; i < ((void)$receiver$iv$iv).length; ++i) {
                void element$iv$iv = $receiver$iv$iv[i];
                if (!(element$iv$iv instanceof KotlinWithGradleConfigurator)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                object = $receiver$iv.iterator();
                while (object.hasNext()) {
                    Object element$iv = object.next();
                    KotlinWithGradleConfigurator it = (KotlinWithGradleConfigurator)element$iv;
                    if (!it.isFileConfigured($receiver)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    protected boolean isApplicable(@NotNull Module module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        return KotlinPluginUtil.isGradleModule(module) && !KotlinPluginUtil.isAndroidGradleModule(module);
    }

    @NotNull
    protected String getMinimumSupportedVersion() {
        return "1.0.0";
    }

    private final boolean isFileConfigured(PsiFile buildScript) {
        return Companion.getManipulator(buildScript).isConfigured(this.getKotlinPluginName());
    }

    @Override
    @JvmSuppressWildcards
    public void configure(@NotNull Project project, @NotNull Collection<Module> excludeModules) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull(excludeModules, (String)"excludeModules");
        ConfigureDialogWithModulesAndVersion dialog2 = new ConfigureDialogWithModulesAndVersion(project, this, excludeModules, this.getMinimumSupportedVersion());
        dialog2.show();
        if (!dialog2.isOK()) {
            return;
        }
        ApplicationUtilsKt.executeCommand$default(project, "Configure Kotlin", null, (Function0)new Function0<Unit>(this, project, dialog2){
            final /* synthetic */ KotlinWithGradleConfigurator this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ ConfigureDialogWithModulesAndVersion $dialog;

            public final void invoke() {
                NotificationMessageCollector collector2 = NotificationMessageCollectorKt.createConfigureKotlinNotificationCollector(this.$project);
                List<Module> list2 = this.$dialog.getModulesToConfigure();
                Intrinsics.checkExpressionValueIsNotNull(list2, (String)"dialog.modulesToConfigure");
                String string = this.$dialog.getKotlinVersion();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"dialog.kotlinVersion");
                HashSet<PsiFile> changedFiles = this.this$0.configureWithVersion(this.$project, list2, string, collector2);
                Iterator<PsiFile> iterator2 = changedFiles.iterator();
                while (iterator2.hasNext()) {
                    PsiFile file2;
                    PsiFile psiFile = file2 = iterator2.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"file");
                    OpenFileAction.openFile((VirtualFile)psiFile.getVirtualFile(), (Project)this.$project);
                }
                collector2.showNotification();
            }
            {
                this.this$0 = kotlinWithGradleConfigurator;
                this.$project = project;
                this.$dialog = configureDialogWithModulesAndVersion;
                super(0);
            }
        }, 2, null);
    }

    @NotNull
    public final HashSet<PsiFile> configureWithVersion(@NotNull Project project, @NotNull List<? extends Module> modulesToConfigure, @NotNull String kotlinVersion, @NotNull NotificationMessageCollector collector2) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull(modulesToConfigure, (String)"modulesToConfigure");
        Intrinsics.checkParameterIsNotNull((Object)kotlinVersion, (String)"kotlinVersion");
        Intrinsics.checkParameterIsNotNull((Object)collector2, (String)"collector");
        HashSet<PsiFile> filesToOpen = new HashSet<PsiFile>();
        PsiFile buildScript = KotlinWithGradleConfigurator.Companion.getTopLevelBuildScriptPsiFile(project);
        if (buildScript != null && KotlinWithGradleConfigurator.Companion.canConfigureFile(buildScript) && (bl = this.configureBuildScript(buildScript, true, kotlinVersion, collector2))) {
            filesToOpen.add(buildScript);
        }
        for (Module module : modulesToConfigure) {
            PsiFile file2 = KotlinWithGradleConfigurator.Companion.getBuildScriptPsiFile(module);
            if (file2 != null && KotlinWithGradleConfigurator.Companion.canConfigureFile(file2)) {
                this.configureModule(module, file2, false, kotlinVersion, collector2, (Collection<PsiFile>)filesToOpen);
                continue;
            }
            KotlinWithGradleConfigurator.Companion.showErrorMessage(project, "Cannot find build.gradle file for module " + module.getName());
        }
        return filesToOpen;
    }

    public void configureModule(@NotNull Module module, @NotNull PsiFile file2, boolean isTopLevelProjectFile, @NotNull String version, @NotNull NotificationMessageCollector collector2, @NotNull Collection<PsiFile> filesToOpen) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        Intrinsics.checkParameterIsNotNull((Object)collector2, (String)"collector");
        Intrinsics.checkParameterIsNotNull(filesToOpen, (String)"filesToOpen");
        boolean isModified2 = this.configureBuildScript(file2, isTopLevelProjectFile, version, collector2);
        if (isModified2) {
            filesToOpen.add(file2);
        }
    }

    protected final boolean configureModuleBuildScript(@NotNull PsiFile file2, @NotNull String version) {
        Sdk sdk;
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)((PsiElement)file2));
        if (module != null) {
            Module module2;
            Module it = module2 = module;
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)it);
            Intrinsics.checkExpressionValueIsNotNull((Object)moduleRootManager, (String)"ModuleRootManager.getInstance(it)");
            sdk = moduleRootManager.getSdk();
        } else {
            sdk = null;
        }
        Sdk sdk2 = sdk;
        String jvmTarget = this.getJvmTarget(sdk2, version);
        return Companion.getManipulator(file2).configureModuleBuildScript(this.getKotlinPluginName(), this.getStdlibArtifactName(sdk2, version), version, jvmTarget);
    }

    @NotNull
    protected String getStdlibArtifactName(@Nullable Sdk sdk, @NotNull String version) {
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        return KotlinRuntimeLibraryUtilKt.getStdlibArtifactId(sdk, version);
    }

    @Nullable
    protected String getJvmTarget(@Nullable Sdk sdk, @NotNull String version) {
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        return null;
    }

    @NotNull
    protected abstract String getKotlinPluginName();

    protected boolean addElementsToFile(@NotNull PsiFile file2, boolean isTopLevelProjectFile, @NotNull String version) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        if (!isTopLevelProjectFile) {
            boolean wasModified = Companion.configureProjectFile(file2, version);
            return wasModified |= this.configureModuleBuildScript(file2, version);
        }
        return false;
    }

    private final boolean configureBuildScript(PsiFile file2, boolean isTopLevelProjectFile, String version, NotificationMessageCollector collector2) {
        Project project = file2.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"file.project");
        boolean isModified2 = (Boolean)ApplicationUtilsKt.executeWriteCommand(project, "Configure " + file2.getName(), null, (Function0)new Function0<Boolean>(this, file2, isTopLevelProjectFile, version){
            final /* synthetic */ KotlinWithGradleConfigurator this$0;
            final /* synthetic */ PsiFile $file;
            final /* synthetic */ boolean $isTopLevelProjectFile;
            final /* synthetic */ String $version;

            /*
             * WARNING - void declaration
             */
            public final boolean invoke() {
                void var1_1;
                boolean isModified2 = this.this$0.addElementsToFile(this.$file, this.$isTopLevelProjectFile, this.$version);
                CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)((PsiElement)this.$file));
                return (boolean)var1_1;
            }
            {
                this.this$0 = kotlinWithGradleConfigurator;
                this.$file = psiFile;
                this.$isTopLevelProjectFile = bl;
                this.$version = string;
                super(0);
            }
        });
        VirtualFile virtualFile2 = file2.getVirtualFile();
        if (virtualFile2 != null && isModified2) {
            collector2.addMessage(virtualFile2.getPath() + " was modified");
        }
        return isModified2;
    }

    @Override
    public void updateLanguageVersion(@NotNull Module module, @Nullable String languageVersion, @Nullable String apiVersion, @NotNull ApiVersion requiredStdlibVersion, boolean forTests) {
        block1: {
            PsiElement psiElement2;
            PsiElement element3;
            boolean runtimeUpdateRequired;
            Object runtimeVersion;
            Object object;
            String it;
            Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
            Intrinsics.checkParameterIsNotNull((Object)requiredStdlibVersion, (String)"requiredStdlibVersion");
            Object object2 = KotlinVersionInfoProviderKt.getRuntimeLibraryVersion(module);
            boolean bl = object2 != null && (object2 = ApiVersion.Companion.parse(it = (object = object2))) != null ? ((ApiVersion)(runtimeVersion = (object = object2))).compareTo(requiredStdlibVersion) < 0 : (runtimeUpdateRequired = false);
            if (runtimeUpdateRequired) {
                Messages.showErrorDialog((Project)module.getProject(), (String)("This language feature requires version " + requiredStdlibVersion + " or later of the Kotlin runtime library. " + "Please update the version in your build script."), (String)"Update Language Version");
                return;
            }
            PsiElement psiElement3 = element3 = Companion.changeLanguageVersion(module, languageVersion, apiVersion, forTests);
            if (psiElement3 == null) break block1;
            PsiElement it2 = psiElement2 = psiElement3;
            Project project = module.getProject();
            PsiFile psiFile = it2.getContainingFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"it.containingFile");
            VirtualFile virtualFile2 = psiFile.getVirtualFile();
            TextRange textRange = it2.getTextRange();
            Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"it.textRange");
            new OpenFileDescriptor(project, virtualFile2, textRange.getStartOffset()).navigate(true);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void changeCoroutineConfiguration(@NotNull Module module, @NotNull LanguageFeature.State state) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        if (!(Intrinsics.areEqual((Object)state, (Object)LanguageFeature.State.DISABLED) ^ true)) ** GOTO lbl-1000
        v0 = KotlinVersionInfoProviderKt.getRuntimeLibraryVersion(module);
        if (v0 != null ? StringsKt.startsWith$default((String)v0, (String)"1.0", (boolean)false, (int)2, null) : false) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = runtimeUpdateRequired = false;
        }
        if (runtimeUpdateRequired) {
            Messages.showErrorDialog((Project)module.getProject(), (String)"Coroutines support requires version 1.1 or later of the Kotlin runtime library. Please update the version in your build script.", (String)ChangeCoroutineSupportFix.Companion.getFixText(state));
            return;
        }
        element = KotlinWithGradleConfigurator.Companion.changeCoroutineConfiguration(module, CoroutineSupport.INSTANCE.getCompilerArgument(state));
        if (element != null) {
            v2 = module.getProject();
            v3 = element.getContainingFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"element.containingFile");
            v4 = v3.getVirtualFile();
            v5 = element.getTextRange();
            Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"element.textRange");
            new OpenFileDescriptor(v2, v4, v5.getStartOffset()).navigate(true);
        }
    }

    @Override
    public void addLibraryDependency(@NotNull Module module, @NotNull PsiElement element3, @NotNull ExternalLibraryDescriptor library2, @NotNull List<? extends LibraryJarDescriptor> libraryJarDescriptors) {
        DependencyScope scope2;
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)library2, (String)"library");
        Intrinsics.checkParameterIsNotNull(libraryJarDescriptors, (String)"libraryJarDescriptors");
        DependencyScope dependencyScope = scope2 = OrderEntryFix.suggestScopeByLocation((Module)module, (PsiElement)element3);
        Intrinsics.checkExpressionValueIsNotNull((Object)dependencyScope, (String)"scope");
        Companion.addKotlinLibraryToModule(module, dependencyScope, library2);
    }

    static {
        GROUP_ID = GROUP_ID;
        GRADLE_PLUGIN_ID = GRADLE_PLUGIN_ID;
        CLASSPATH = "classpath \"" + Companion.getGROUP_ID() + ':' + Companion.getGRADLE_PLUGIN_ID() + ":$kotlin_version\"";
        KOTLIN_BUILD_SCRIPT_NAME = KOTLIN_BUILD_SCRIPT_NAME;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J(\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u000f\u001a\u00020\u00102\u0014\u0010\u001b\u001a\u0010\u0012\u0004\u0012\u00020\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u001a0\u001cH\u0002J\u0018\u0010\u001d\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u0004J,\u0010\u001f\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010 \u001a\u0004\u0018\u00010\u00042\b\u0010!\u001a\u0004\u0018\u00010\u00042\u0006\u0010\"\u001a\u00020\u0016J\u0016\u0010#\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010$\u001a\u00020\u0004J\u0012\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020\u0004H\u0002J\u000e\u0010(\u001a\u00020\u00042\u0006\u0010)\u001a\u00020\u0004J\u0018\u0010*\u001a\u00020\u00042\u0006\u0010+\u001a\u00020\u00042\b\b\u0002\u0010\u0011\u001a\u00020\u0004J\u0010\u0010,\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010-\u001a\u00020.2\u0006\u0010\u0017\u001a\u00020\u0018J\u001a\u0010/\u001a\u00020\u000e2\u0006\u00100\u001a\u0002012\b\u00102\u001a\u0004\u0018\u00010\u0004H\u0002J\u000e\u00103\u001a\u0004\u0018\u00010&*\u00020\u0010H\u0002J\u000e\u00104\u001a\u0004\u0018\u00010\u0018*\u00020\u0010H\u0002J\u0016\u00105\u001a\u0004\u0018\u00010\u0018*\u00020&2\u0006\u00100\u001a\u000201H\u0002J\u000e\u00106\u001a\u0004\u0018\u00010\u0018*\u000201H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006\u00a8\u00067"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/KotlinWithGradleConfigurator$Companion;", "", "()V", "CLASSPATH", "", "getCLASSPATH", "()Ljava/lang/String;", "GRADLE_PLUGIN_ID", "getGRADLE_PLUGIN_ID", "GROUP_ID", "getGROUP_ID", "KOTLIN_BUILD_SCRIPT_NAME", "getKOTLIN_BUILD_SCRIPT_NAME", "addKotlinLibraryToModule", "", "module", "Lcom/intellij/openapi/module/Module;", "scope", "Lcom/intellij/openapi/roots/DependencyScope;", "libraryDescriptor", "Lcom/intellij/openapi/roots/ExternalLibraryDescriptor;", "canConfigureFile", "", "file", "Lcom/intellij/psi/PsiFile;", "changeBuildGradle", "Lcom/intellij/psi/PsiElement;", "body", "Lkotlin/Function1;", "changeCoroutineConfiguration", "coroutineOption", "changeLanguageVersion", "languageVersion", "apiVersion", "forTests", "configureProjectFile", "version", "findBuildGradleFile", "Ljava/io/File;", "path", "getGroovyApplyPluginDirective", "pluginName", "getGroovyDependencySnippet", "artifactName", "getKotlinStdlibVersion", "getManipulator", "Lorg/jetbrains/kotlin/idea/configuration/GradleBuildScriptManipulator;", "showErrorMessage", "project", "Lcom/intellij/openapi/project/Project;", "message", "getBuildScriptFile", "getBuildScriptPsiFile", "getPsiFile", "getTopLevelBuildScriptPsiFile", "idea-gradle"})
    public static final class Companion {
        @NotNull
        public final GradleBuildScriptManipulator getManipulator(@NotNull PsiFile file2) {
            GradleBuildScriptManipulator gradleBuildScriptManipulator;
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            PsiFile psiFile = file2;
            if (psiFile instanceof KtFile) {
                gradleBuildScriptManipulator = new KotlinBuildScriptManipulator((KtFile)file2);
            } else if (psiFile instanceof GroovyFile) {
                gradleBuildScriptManipulator = new GroovyBuildScriptManipulator((GroovyFile)file2);
            } else {
                String string = "Unknown build script file type!";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            return gradleBuildScriptManipulator;
        }

        @NotNull
        public final String getGROUP_ID() {
            return GROUP_ID;
        }

        @NotNull
        public final String getGRADLE_PLUGIN_ID() {
            return GRADLE_PLUGIN_ID;
        }

        @NotNull
        public final String getCLASSPATH() {
            return CLASSPATH;
        }

        private final String getKOTLIN_BUILD_SCRIPT_NAME() {
            return KOTLIN_BUILD_SCRIPT_NAME;
        }

        @NotNull
        public final String getGroovyDependencySnippet(@NotNull String artifactName, @NotNull String scope2) {
            Intrinsics.checkParameterIsNotNull((Object)artifactName, (String)"artifactName");
            Intrinsics.checkParameterIsNotNull((Object)scope2, (String)"scope");
            return "" + scope2 + " \"org.jetbrains.kotlin:" + artifactName + ":$kotlin_version\"";
        }

        @NotNull
        public static /* bridge */ /* synthetic */ String getGroovyDependencySnippet$default(Companion companion, String string, String string2, int n, Object object) {
            if ((n & 2) != 0) {
                string2 = "compile";
            }
            return companion.getGroovyDependencySnippet(string, string2);
        }

        @NotNull
        public final String getGroovyApplyPluginDirective(@NotNull String pluginName) {
            Intrinsics.checkParameterIsNotNull((Object)pluginName, (String)"pluginName");
            return "apply plugin: '" + pluginName + '\'';
        }

        public final void addKotlinLibraryToModule(@NotNull Module module, @NotNull DependencyScope scope2, @NotNull ExternalLibraryDescriptor libraryDescriptor) {
            block2: {
                VirtualFile virtualFile2;
                PsiFile buildScript;
                Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
                Intrinsics.checkParameterIsNotNull((Object)scope2, (String)"scope");
                Intrinsics.checkParameterIsNotNull((Object)libraryDescriptor, (String)"libraryDescriptor");
                PsiFile psiFile = this.getBuildScriptPsiFile(module);
                if (psiFile == null) {
                    return;
                }
                PsiFile psiFile2 = buildScript = psiFile;
                Intrinsics.checkExpressionValueIsNotNull((Object)psiFile2, (String)"buildScript");
                if (!this.canConfigureFile(psiFile2)) {
                    return;
                }
                this.getManipulator(buildScript).addKotlinLibraryToModuleBuildScript(scope2, libraryDescriptor, KotlinPluginUtil.isAndroidGradleModule(module));
                VirtualFile virtualFile3 = buildScript.getVirtualFile();
                if (virtualFile3 == null) break block2;
                VirtualFile it = virtualFile2 = virtualFile3;
                Project project = buildScript.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"buildScript.project");
                NotificationMessageCollectorKt.createConfigureKotlinNotificationCollector(project).addMessage(it.getPath() + " was modified").showNotification();
            }
        }

        @Nullable
        public final PsiElement changeCoroutineConfiguration(@NotNull Module module, @NotNull String coroutineOption) {
            Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
            Intrinsics.checkParameterIsNotNull((Object)coroutineOption, (String)"coroutineOption");
            return this.changeBuildGradle(module, (Function1<? super PsiFile, ? extends PsiElement>)((Function1)new Function1<PsiFile, PsiElement>(coroutineOption){
                final /* synthetic */ String $coroutineOption;

                @Nullable
                public final PsiElement invoke(@NotNull PsiFile it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return KotlinWithGradleConfigurator.Companion.getManipulator(it).changeCoroutineConfiguration(this.$coroutineOption);
                }
                {
                    this.$coroutineOption = string;
                    super(1);
                }
            }));
        }

        @Nullable
        public final PsiElement changeLanguageVersion(@NotNull Module module, @Nullable String languageVersion, @Nullable String apiVersion, boolean forTests) {
            Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
            return this.changeBuildGradle(module, (Function1<? super PsiFile, ? extends PsiElement>)((Function1)new Function1<PsiFile, PsiElement>(languageVersion, forTests, apiVersion){
                final /* synthetic */ String $languageVersion;
                final /* synthetic */ boolean $forTests;
                final /* synthetic */ String $apiVersion;

                /*
                 * WARNING - void declaration
                 */
                @Nullable
                public final PsiElement invoke(@NotNull PsiFile buildScriptFile) {
                    void var3_3;
                    Intrinsics.checkParameterIsNotNull((Object)buildScriptFile, (String)"buildScriptFile");
                    GradleBuildScriptManipulator manipulator = KotlinWithGradleConfigurator.Companion.getManipulator(buildScriptFile);
                    PsiElement result2 = null;
                    if (this.$languageVersion != null) {
                        result2 = manipulator.changeLanguageVersion(this.$languageVersion, this.$forTests);
                    }
                    if (this.$apiVersion != null) {
                        result2 = manipulator.changeApiVersion(this.$apiVersion, this.$forTests);
                    }
                    return var3_3;
                }
                {
                    this.$languageVersion = string;
                    this.$forTests = bl;
                    this.$apiVersion = string2;
                    super(1);
                }
            }));
        }

        private final PsiElement changeBuildGradle(Module module, Function1<? super PsiFile, ? extends PsiElement> body2) {
            PsiFile buildScriptFile = this.getBuildScriptPsiFile(module);
            if (buildScriptFile != null && this.canConfigureFile(buildScriptFile)) {
                Project project = buildScriptFile.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"buildScriptFile.project");
                return (PsiElement)ApplicationUtilsKt.executeWriteCommand(project, "Change build.gradle configuration", null, (Function0)new Function0<PsiElement>(body2, buildScriptFile){
                    final /* synthetic */ Function1 $body;
                    final /* synthetic */ PsiFile $buildScriptFile;

                    @Nullable
                    public final PsiElement invoke() {
                        return (PsiElement)this.$body.invoke((Object)this.$buildScriptFile);
                    }
                    {
                        this.$body = function1;
                        this.$buildScriptFile = psiFile;
                        super(0);
                    }
                });
            }
            return null;
        }

        @Nullable
        public final String getKotlinStdlibVersion(@NotNull Module module) {
            String string;
            Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
            PsiFile psiFile = this.getBuildScriptPsiFile(module);
            if (psiFile != null) {
                PsiFile psiFile2;
                PsiFile it;
                PsiFile psiFile3 = it = (psiFile2 = psiFile);
                Intrinsics.checkExpressionValueIsNotNull((Object)psiFile3, (String)"it");
                string = Companion.getManipulator(psiFile3).getKotlinStdlibVersion();
            } else {
                string = null;
            }
            return string;
        }

        public final boolean configureProjectFile(@NotNull PsiFile file2, @NotNull String version) {
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
            return this.getManipulator(file2).configureProjectBuildScript(version);
        }

        private final boolean canConfigureFile(PsiFile file2) {
            return WritingAccessProvider.isPotentiallyWritable((VirtualFile)file2.getVirtualFile(), null);
        }

        private final PsiFile getBuildScriptPsiFile(@NotNull Module $receiver) {
            PsiFile psiFile;
            File file2 = this.getBuildScriptFile($receiver);
            if (file2 != null) {
                Project project = $receiver.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
                psiFile = this.getPsiFile(file2, project);
            } else {
                psiFile = null;
            }
            return psiFile;
        }

        private final PsiFile getTopLevelBuildScriptPsiFile(@NotNull Project $receiver) {
            PsiFile psiFile;
            String string = $receiver.getBasePath();
            if (string != null) {
                String string2;
                String it;
                String string3 = it = (string2 = string);
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"it");
                File file2 = Companion.findBuildGradleFile(string3);
                psiFile = file2 != null ? Companion.getPsiFile(file2, $receiver) : null;
            } else {
                psiFile = null;
            }
            return psiFile;
        }

        private final File getBuildScriptFile(@NotNull Module $receiver) {
            block3: {
                String string;
                String externalProjectPath;
                String moduleDir;
                String string2 = moduleDir = new File($receiver.getModuleFilePath()).getParent();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"moduleDir");
                File file2 = this.findBuildGradleFile(string2);
                if (file2 != null) {
                    File file3;
                    File it = file3 = file2;
                    return it;
                }
                ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)$receiver);
                Intrinsics.checkExpressionValueIsNotNull((Object)moduleRootManager, (String)"ModuleRootManager.getInstance(this)");
                VirtualFile[] virtualFileArray = moduleRootManager.getContentRoots();
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFileArray, (String)"ModuleRootManager.getInstance(this).contentRoots");
                Object[] $receiver$iv = virtualFileArray;
                for (int it = 0; it < $receiver$iv.length; ++it) {
                    File file4;
                    VirtualFile root;
                    Object element$iv = $receiver$iv[it];
                    VirtualFile virtualFile2 = root = (VirtualFile)element$iv;
                    Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"root");
                    String string3 = virtualFile2.getPath();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"root.path");
                    File file5 = Companion.findBuildGradleFile(string3);
                    if (file5 == null) continue;
                    File it2 = file4 = file5;
                    return it2;
                }
                String string4 = ExternalSystemApiUtil.getExternalProjectPath((Module)$receiver);
                if (string4 == null) break block3;
                String string5 = externalProjectPath = (string = string4);
                Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"externalProjectPath");
                File file6 = Companion.findBuildGradleFile(string5);
                if (file6 != null) {
                    File file7;
                    File it = file7 = file6;
                    return it;
                }
            }
            return null;
        }

        private final File findBuildGradleFile(String path) {
            File file2 = new File(path + "/" + "build.gradle");
            File it = file2;
            File file3 = it.exists() ? file2 : null;
            if (file3 == null) {
                file2 = new File(path + "/" + this.getKOTLIN_BUILD_SCRIPT_NAME());
                it = file2;
                file3 = it.exists() ? file2 : null;
            }
            return file3;
        }

        private final PsiFile getPsiFile(@NotNull File $receiver, Project project) {
            PsiFile psiFile;
            VirtualFile virtualFile2 = VfsUtil.findFileByIoFile((File)$receiver, (boolean)true);
            if (virtualFile2 != null) {
                VirtualFile virtualFile3;
                VirtualFile it = virtualFile3 = virtualFile2;
                psiFile = PsiManager.getInstance((Project)project).findFile(it);
            } else {
                psiFile = null;
            }
            return psiFile;
        }

        private final void showErrorMessage(Project project, String message2) {
            Messages.showErrorDialog((Project)project, (String)("<html>Couldn't configure kotlin-gradle plugin automatically.<br/>" + (message2 != null ? message2 + "<br/>" : "") + "<br/>See manual installation instructions <a href=\"https://kotlinlang.org/docs/reference/using-gradle.html\">here</a>.</html>"), (String)"Configure Kotlin-Gradle Plugin");
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

