/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExternalLibraryDescriptor;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.DummyLibraryProperties;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.roots.libraries.LibraryType;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.Consumer;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmSuppressWildcards;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.KotlinFacetSettings;
import org.jetbrains.kotlin.config.KotlinFacetSettingsProvider;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.idea.KotlinPluginUtil;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinStatus;
import org.jetbrains.kotlin.idea.configuration.KotlinProjectConfigurator;
import org.jetbrains.kotlin.idea.configuration.ModuleSourceRootGroup;
import org.jetbrains.kotlin.idea.configuration.NotificationMessageCollector;
import org.jetbrains.kotlin.idea.configuration.NotificationMessageCollectorKt;
import org.jetbrains.kotlin.idea.facet.KotlinVersionInfoProviderKt;
import org.jetbrains.kotlin.idea.framework.ui.CreateLibraryDialogWithModules;
import org.jetbrains.kotlin.idea.framework.ui.FileUIUtils;
import org.jetbrains.kotlin.idea.quickfix.EnableUnsupportedFeatureFixKt;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.idea.util.projectStructure.ProjectStructureUtilKt;
import org.jetbrains.kotlin.idea.versions.KotlinRuntimeLibraryUtilKt;
import org.jetbrains.kotlin.idea.versions.LibraryJarDescriptor;
import org.jetbrains.kotlin.idea.versions.OutdatedKotlinRuntimeCheckerKt;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u00b6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 e2\u00020\u0001:\u0002efB\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0002J.\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%H\u0016J\u001e\u0010'\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020\u000f2\u0006\u0010(\u001a\u00020)J\u0018\u0010*\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010+\u001a\u00020,H\u0016J\u001e\u0010-\u001a\u00020\u001d2\u0006\u0010.\u001a\u00020/2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u001f01H\u0017J\u0016\u00102\u001a\u00020\u001d2\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u001f0%H\u0014J.\u00104\u001a\u00020\u001d2\u0006\u0010\"\u001a\u0002052\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u00020\u00042\u0006\u00109\u001a\u00020&2\u0006\u0010(\u001a\u00020)J>\u0010:\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010;\u001a\u00020\u00042\u0006\u0010<\u001a\u00020\u00042\u0006\u0010(\u001a\u00020)2\n\b\u0002\u0010=\u001a\u0004\u0018\u0001072\b\b\u0002\u0010>\u001a\u00020\u0010H\u0016J*\u0010:\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010?\u001a\u00020\u00042\b\u0010@\u001a\u0004\u0018\u00010\u00042\u0006\u0010(\u001a\u00020)H\u0004J>\u0010A\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010;\u001a\u00020\u00042\u0006\u0010<\u001a\u00020\u00042\u0006\u0010(\u001a\u00020)2\n\b\u0002\u0010=\u001a\u0004\u0018\u0001072\b\b\u0002\u0010>\u001a\u00020\u0010H\u0002J\u0010\u0010B\u001a\u00020\u001d2\u0006\u0010.\u001a\u00020/H\u0007J$\u0010C\u001a\u0004\u0018\u00010D2\b\u0010E\u001a\u0004\u0018\u00010D2\u0006\u0010F\u001a\u00020\u00042\u0006\u0010(\u001a\u00020)H\u0007J\u0016\u0010G\u001a\u00020\u000f2\u0006\u0010.\u001a\u00020/2\u0006\u0010(\u001a\u00020)J\u001a\u0010H\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010(\u001a\u00020)H\u0014J\u0010\u0010I\u001a\u00020\u00042\u0006\u0010.\u001a\u00020/H\u0016J(\u0010J\u001a\u0002072\u0006\u0010.\u001a\u00020/2\u0006\u0010K\u001a\u00020D2\u0006\u0010L\u001a\u00020M2\u0006\u0010>\u001a\u00020\u0010H\u0004J\u0010\u0010N\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0010\u0010N\u001a\u0004\u0018\u00010\u000f2\u0006\u0010.\u001a\u00020/J\u0018\u0010O\u001a\b\u0012\u0004\u0012\u00020&0%2\b\u0010P\u001a\u0004\u0018\u00010QH&J\u001a\u0010R\u001a\u0004\u0018\u00010\u00042\u0006\u0010.\u001a\u00020/2\u0006\u0010S\u001a\u00020MH\u0004J*\u0010T\u001a\u00020\u00042\u0006\u0010.\u001a\u00020/2\u0006\u0010L\u001a\u00020M2\u0006\u0010U\u001a\u00020\u00042\b\u0010@\u001a\u0004\u0018\u00010\u0004H\u0002J\u0010\u0010V\u001a\u00020W2\u0006\u0010X\u001a\u00020YH\u0016J\u0010\u0010Z\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001fH\u0014J\u0010\u0010[\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001fH&J\u0010\u0010\\\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020\u000fH\u0002J\u0010\u0010]\u001a\u00020\u00102\u0006\u0010.\u001a\u00020/H\u0002J\u0010\u0010^\u001a\u00020\u00102\u0006\u0010.\u001a\u00020/H\u0004J4\u0010_\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010`\u001a\u0004\u0018\u00010\u00042\b\u0010a\u001a\u0004\u0018\u00010\u00042\u0006\u0010b\u001a\u00020c2\u0006\u0010d\u001a\u00020\u0010H\u0016R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\u0004X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u001a\u0010\t\u001a\b\u0012\u0002\b\u0003\u0018\u00010\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001e\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0012\u0010\u0013\u001a\u00020\u0004X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0006R\u001c\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0012\u0010\u001a\u001a\u00020\u0004X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0006\u00a8\u0006g"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator;", "Lorg/jetbrains/kotlin/idea/configuration/KotlinProjectConfigurator;", "()V", "dialogTitle", "", "getDialogTitle", "()Ljava/lang/String;", "libraryCaption", "getLibraryCaption", "libraryKind", "Lcom/intellij/openapi/roots/libraries/PersistentLibraryKind;", "getLibraryKind", "()Lcom/intellij/openapi/roots/libraries/PersistentLibraryKind;", "libraryMatcher", "Lkotlin/Function1;", "Lcom/intellij/openapi/roots/libraries/Library;", "", "getLibraryMatcher", "()Lkotlin/jvm/functions/Function1;", "libraryName", "getLibraryName", "libraryType", "Lcom/intellij/openapi/roots/libraries/LibraryType;", "Lcom/intellij/openapi/roots/libraries/DummyLibraryProperties;", "getLibraryType", "()Lcom/intellij/openapi/roots/libraries/LibraryType;", "messageForOverrideDialog", "getMessageForOverrideDialog", "addLibraryDependency", "", "module", "Lcom/intellij/openapi/module/Module;", "element", "Lcom/intellij/psi/PsiElement;", "library", "Lcom/intellij/openapi/roots/ExternalLibraryDescriptor;", "libraryJarDescriptors", "", "Lorg/jetbrains/kotlin/idea/versions/LibraryJarDescriptor;", "addLibraryToModuleIfNeeded", "collector", "Lorg/jetbrains/kotlin/idea/configuration/NotificationMessageCollector;", "changeCoroutineConfiguration", "state", "Lorg/jetbrains/kotlin/config/LanguageFeature$State;", "configure", "project", "Lcom/intellij/openapi/project/Project;", "excludeModules", "", "configureKotlinSettings", "modules", "configureLibraryJar", "Lcom/intellij/openapi/roots/libraries/Library$ModifiableModel;", "jarState", "Lorg/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator$FileState;", "dirToCopyJarTo", "libraryJarDescriptor", "configureModule", "classesPath", "sourcesPath", "forceJarState", "useBundled", "defaultPath", "pathFromDialog", "configureModuleWithLibrary", "configureSilently", "copyFileToDir", "Ljava/io/File;", "file", "toDir", "createNewLibrary", "findAndFixBrokenKotlinLibrary", "getDefaultPathToJarFile", "getJarState", "targetFile", "jarType", "Lcom/intellij/openapi/roots/OrderRootType;", "getKotlinLibrary", "getLibraryJarDescriptors", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "getPathFromLibrary", "type", "getPathToCopyFileTo", "defaultDir", "getStatus", "Lorg/jetbrains/kotlin/idea/configuration/ConfigureKotlinStatus;", "moduleSourceRootGroup", "Lorg/jetbrains/kotlin/idea/configuration/ModuleSourceRootGroup;", "isApplicable", "isConfigured", "isKotlinLibrary", "isProjectLibraryPresent", "needToChooseJarPath", "updateLanguageVersion", "languageVersion", "apiVersion", "requiredStdlibVersion", "Lorg/jetbrains/kotlin/config/ApiVersion;", "forTests", "Companion", "FileState", "idea"})
public abstract class KotlinWithLibraryConfigurator
implements KotlinProjectConfigurator {
    @Nullable
    private final LibraryType<DummyLibraryProperties> libraryType;
    @Nullable
    private final PersistentLibraryKind<?> libraryKind;
    @NotNull
    private static final String DEFAULT_LIBRARY_DIR = "lib";
    public static final Companion Companion = new Companion(null);

    @NotNull
    protected abstract String getLibraryName();

    @NotNull
    protected abstract String getMessageForOverrideDialog();

    @NotNull
    protected abstract String getDialogTitle();

    @NotNull
    protected abstract String getLibraryCaption();

    @Nullable
    public LibraryType<DummyLibraryProperties> getLibraryType() {
        return this.libraryType;
    }

    @Nullable
    protected final PersistentLibraryKind<?> getLibraryKind() {
        return this.libraryKind;
    }

    @Override
    @NotNull
    public ConfigureKotlinStatus getStatus(@NotNull ModuleSourceRootGroup moduleSourceRootGroup) {
        Intrinsics.checkParameterIsNotNull((Object)moduleSourceRootGroup, (String)"moduleSourceRootGroup");
        Module module = moduleSourceRootGroup.getBaseModule();
        if (!this.isApplicable(module)) {
            return ConfigureKotlinStatus.NON_APPLICABLE;
        }
        if (this.isConfigured(module)) {
            return ConfigureKotlinStatus.CONFIGURED;
        }
        return ConfigureKotlinStatus.CAN_BE_CONFIGURED;
    }

    public abstract boolean isConfigured(@NotNull Module var1);

    @Override
    @JvmSuppressWildcards
    public void configure(@NotNull Project project, @NotNull Collection<Module> excludeModules) {
        List<Module> list2;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull(excludeModules, (String)"excludeModules");
        String defaultPathToJar = this.getDefaultPathToJarFile(project);
        boolean showPathToJarPanel = this.needToChooseJarPath(project);
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        if (!application.isUnitTestMode()) {
            list2 = ConfigureKotlinInProjectUtilsKt.getCanBeConfiguredModules(project, this);
        } else {
            ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
            Intrinsics.checkExpressionValueIsNotNull((Object)moduleManager, (String)"ModuleManager.getInstance(project)");
            Module[] moduleArray = moduleManager.getModules();
            list2 = Arrays.asList(Arrays.copyOf(moduleArray, moduleArray.length));
        }
        List<Module> nonConfiguredModules = list2;
        List<Module> modulesToConfigure = nonConfiguredModules = CollectionsKt.minus((Iterable)nonConfiguredModules, (Iterable)excludeModules);
        String copyLibraryIntoPath = null;
        if (nonConfiguredModules.size() > 1 || showPathToJarPanel) {
            CreateLibraryDialogWithModules dialog2 = new CreateLibraryDialogWithModules(project, this, defaultPathToJar, showPathToJarPanel, this.getDialogTitle(), this.getLibraryCaption(), excludeModules);
            Application application2 = ApplicationManager.getApplication();
            Intrinsics.checkExpressionValueIsNotNull((Object)application2, (String)"ApplicationManager.getApplication()");
            if (!application2.isUnitTestMode()) {
                dialog2.show();
                if (!dialog2.isOK()) {
                    return;
                }
            } else {
                dialog2.close(0);
            }
            modulesToConfigure = dialog2.getModulesToConfigure();
            copyLibraryIntoPath = dialog2.getCopyIntoPath();
        }
        NotificationMessageCollector collector2 = NotificationMessageCollectorKt.createConfigureKotlinNotificationCollector(project);
        for (Module module : modulesToConfigure) {
            this.configureModule(module, defaultPathToJar, copyLibraryIntoPath, collector2);
        }
        List<Module> list3 = modulesToConfigure;
        Intrinsics.checkExpressionValueIsNotNull((Object)list3, (String)"modulesToConfigure");
        this.configureKotlinSettings((List<? extends Module>)list3);
        collector2.showNotification();
    }

    public final void configureSilently(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        String defaultPathToJar = this.getDefaultPathToJarFile(project);
        NotificationMessageCollector collector2 = NotificationMessageCollectorKt.createConfigureKotlinNotificationCollector(project);
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleManager, (String)"ModuleManager.getInstance(project)");
        Module[] moduleArray = moduleManager.getModules();
        for (int i = 0; i < moduleArray.length; ++i) {
            Module module;
            Module module2 = module = moduleArray[i];
            Intrinsics.checkExpressionValueIsNotNull((Object)module2, (String)"module");
            this.configureModule(module2, defaultPathToJar, null, collector2);
        }
    }

    protected final void configureModule(@NotNull Module module, @NotNull String defaultPath, @Nullable String pathFromDialog, @NotNull NotificationMessageCollector collector2) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Intrinsics.checkParameterIsNotNull((Object)defaultPath, (String)"defaultPath");
        Intrinsics.checkParameterIsNotNull((Object)collector2, (String)"collector");
        Project project = module.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"module.project");
        OrderRootType orderRootType = OrderRootType.CLASSES;
        Intrinsics.checkExpressionValueIsNotNull((Object)orderRootType, (String)"OrderRootType.CLASSES");
        String classesPath = this.getPathToCopyFileTo(project, orderRootType, defaultPath, pathFromDialog);
        Project project2 = module.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"module.project");
        OrderRootType orderRootType2 = OrderRootType.SOURCES;
        Intrinsics.checkExpressionValueIsNotNull((Object)orderRootType2, (String)"OrderRootType.SOURCES");
        String sourcesPath = this.getPathToCopyFileTo(project2, orderRootType2, defaultPath, pathFromDialog);
        KotlinWithLibraryConfigurator.configureModule$default(this, module, classesPath, sourcesPath, collector2, null, pathFromDialog == null, 16, null);
    }

    public void configureModule(@NotNull Module module, @NotNull String classesPath, @NotNull String sourcesPath, @NotNull NotificationMessageCollector collector2, @Nullable FileState forceJarState, boolean useBundled) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Intrinsics.checkParameterIsNotNull((Object)classesPath, (String)"classesPath");
        Intrinsics.checkParameterIsNotNull((Object)sourcesPath, (String)"sourcesPath");
        Intrinsics.checkParameterIsNotNull((Object)collector2, (String)"collector");
        this.configureModuleWithLibrary(module, classesPath, sourcesPath, collector2, forceJarState, useBundled);
    }

    public static /* bridge */ /* synthetic */ void configureModule$default(KotlinWithLibraryConfigurator kotlinWithLibraryConfigurator, Module module, String string, String string2, NotificationMessageCollector notificationMessageCollector, FileState fileState, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: configureModule");
        }
        if ((n & 0x10) != 0) {
            fileState = null;
        }
        if ((n & 0x20) != 0) {
            bl = false;
        }
        kotlinWithLibraryConfigurator.configureModule(module, string, string2, notificationMessageCollector, fileState, bl);
    }

    private final void configureModuleWithLibrary(Module module, String classesPath, String sourcesPath, NotificationMessageCollector collector2, FileState forceJarState, boolean useBundled) {
        Library library2;
        Library library3;
        Project project = module.getProject();
        Library library4 = this.findAndFixBrokenKotlinLibrary(module, collector2);
        if (library4 == null) {
            library4 = library3 = this.getKotlinLibrary(module);
        }
        if (library4 == null) {
            Project project2 = project;
            Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
            library3 = library2 = this.getKotlinLibrary(project2);
        }
        if (library3 == null) {
            Project project3 = project;
            Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"project");
            library2 = this.createNewLibrary(project3, collector2);
        }
        Library library5 = library2;
        Sdk sdk = ProjectStructureUtilKt.getSdk(module);
        Library.ModifiableModel model = library5.getModifiableModel();
        for (LibraryJarDescriptor descriptor2 : this.getLibraryJarDescriptors(sdk)) {
            String dirToCopyJar = Intrinsics.areEqual((Object)descriptor2.getOrderRootType(), (Object)OrderRootType.SOURCES) ? sourcesPath : classesPath;
            FileState fileState = forceJarState;
            if (fileState == null) {
                Project project4 = project;
                Intrinsics.checkExpressionValueIsNotNull((Object)project4, (String)"project");
                fileState = this.getJarState(project4, new File(dirToCopyJar, descriptor2.getJarName()), descriptor2.getOrderRootType(), useBundled);
            }
            FileState runtimeState = fileState;
            Library.ModifiableModel modifiableModel = model;
            Intrinsics.checkExpressionValueIsNotNull((Object)modifiableModel, (String)"model");
            this.configureLibraryJar(modifiableModel, runtimeState, dirToCopyJar, descriptor2, collector2);
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable(model){
            final /* synthetic */ Library.ModifiableModel $model;

            public final void run() {
                this.$model.commit();
            }
            {
                this.$model = modifiableModel;
            }
        });
        this.addLibraryToModuleIfNeeded(module, library5, collector2);
    }

    static /* bridge */ /* synthetic */ void configureModuleWithLibrary$default(KotlinWithLibraryConfigurator kotlinWithLibraryConfigurator, Module module, String string, String string2, NotificationMessageCollector notificationMessageCollector, FileState fileState, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: configureModuleWithLibrary");
        }
        if ((n & 0x10) != 0) {
            fileState = null;
        }
        if ((n & 0x20) != 0) {
            bl = false;
        }
        kotlinWithLibraryConfigurator.configureModuleWithLibrary(module, string, string2, notificationMessageCollector, fileState, bl);
    }

    public final void configureLibraryJar(@NotNull Library.ModifiableModel library2, @NotNull FileState jarState, @NotNull String dirToCopyJarTo, @NotNull LibraryJarDescriptor libraryJarDescriptor, @NotNull NotificationMessageCollector collector2) {
        VirtualFile jarVFile;
        File jarFile;
        Intrinsics.checkParameterIsNotNull((Object)library2, (String)"library");
        Intrinsics.checkParameterIsNotNull((Object)((Object)jarState), (String)"jarState");
        Intrinsics.checkParameterIsNotNull((Object)dirToCopyJarTo, (String)"dirToCopyJarTo");
        Intrinsics.checkParameterIsNotNull((Object)((Object)libraryJarDescriptor), (String)"libraryJarDescriptor");
        Intrinsics.checkParameterIsNotNull((Object)collector2, (String)"collector");
        File file2 = jarFile = Intrinsics.areEqual((Object)((Object)jarState), (Object)((Object)FileState.DO_NOT_COPY)) ? libraryJarDescriptor.getPathInPlugin() : new File(dirToCopyJarTo, libraryJarDescriptor.getJarName());
        if (Intrinsics.areEqual((Object)((Object)jarState), (Object)((Object)FileState.COPY))) {
            this.copyFileToDir(libraryJarDescriptor.getPathInPlugin(), dirToCopyJarTo, collector2);
        }
        if ((jarVFile = LocalFileSystem.getInstance().findFileByIoFile(jarFile)) == null) {
            collector2.addMessage("Can't find library JAR file " + jarFile);
            return;
        }
        VirtualFile jarRoot = JarFileSystem.getInstance().getJarRootForLocalFile(jarVFile);
        if (jarRoot == null) {
            collector2.addMessage("Couldn't configure library; JAR file " + jarVFile + " may be corrupted");
            return;
        }
        VirtualFile[] virtualFileArray = library2.getFiles(libraryJarDescriptor.getOrderRootType());
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFileArray, (String)"library.getFiles(library\u2026Descriptor.orderRootType)");
        if (!ArraysKt.contains((Object[])virtualFileArray, (Object)jarRoot)) {
            library2.addRoot(jarRoot, libraryJarDescriptor.getOrderRootType());
            collector2.addMessage("Added " + jarFile + " to library configuration");
        }
    }

    @Nullable
    public final Library getKotlinLibrary(@NotNull Project project) {
        Library library2;
        Object v2;
        Library p1;
        Object element$iv;
        Object[] $receiver$iv;
        int n;
        KotlinWithLibraryConfigurator kotlinWithLibraryConfigurator;
        block3: {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            LibraryTable libraryTable = LibraryTablesRegistrar.getInstance().getLibraryTable(project);
            Intrinsics.checkExpressionValueIsNotNull((Object)libraryTable, (String)"LibraryTablesRegistrar.g\u2026.getLibraryTable(project)");
            Library[] libraryArray = libraryTable.getLibraries();
            Intrinsics.checkExpressionValueIsNotNull((Object)libraryArray, (String)"LibraryTablesRegistrar.g\u2026yTable(project).libraries");
            Object[] objectArray = libraryArray;
            kotlinWithLibraryConfigurator = this;
            for (n = 0; n < $receiver$iv.length; ++n) {
                element$iv = $receiver$iv[n];
                p1 = (Library)element$iv;
                if (!kotlinWithLibraryConfigurator.isKotlinLibrary(p1)) continue;
                v2 = element$iv;
                break block3;
            }
            v2 = null;
        }
        if ((library2 = (Library)v2) == null) {
            Object object;
            block4: {
                LibraryTablesRegistrar libraryTablesRegistrar = LibraryTablesRegistrar.getInstance();
                Intrinsics.checkExpressionValueIsNotNull((Object)libraryTablesRegistrar, (String)"LibraryTablesRegistrar.getInstance()");
                LibraryTable libraryTable = libraryTablesRegistrar.getLibraryTable();
                Intrinsics.checkExpressionValueIsNotNull((Object)libraryTable, (String)"LibraryTablesRegistrar.getInstance().libraryTable");
                Library[] libraryArray = libraryTable.getLibraries();
                Intrinsics.checkExpressionValueIsNotNull((Object)libraryArray, (String)"LibraryTablesRegistrar.g\u2026().libraryTable.libraries");
                $receiver$iv = libraryArray;
                kotlinWithLibraryConfigurator = this;
                for (n = 0; n < $receiver$iv.length; ++n) {
                    element$iv = $receiver$iv[n];
                    p1 = (Library)element$iv;
                    if (!kotlinWithLibraryConfigurator.isKotlinLibrary(p1)) continue;
                    object = element$iv;
                    break block4;
                }
                object = null;
            }
            library2 = (Library)object;
        }
        return library2;
    }

    @Contract(value="!null, _, _ -> !null")
    @Nullable
    public final File copyFileToDir(@Nullable File file2, @NotNull String toDir, @NotNull NotificationMessageCollector collector2) {
        Intrinsics.checkParameterIsNotNull((Object)toDir, (String)"toDir");
        Intrinsics.checkParameterIsNotNull((Object)collector2, (String)"collector");
        if (file2 == null) {
            return null;
        }
        File copy = FileUIUtils.copyWithOverwriteDialog(this.getMessageForOverrideDialog(), toDir, file2);
        if (copy != null) {
            collector2.addMessage(file2.getName() + " was copied to " + toDir);
        }
        return copy;
    }

    @Nullable
    protected final String getPathFromLibrary(@NotNull Project project, @NotNull OrderRootType type2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
        return Companion.getPathFromLibrary(this.getKotlinLibrary(project), type2);
    }

    public final void addLibraryToModuleIfNeeded(@NotNull Module module, @NotNull Library library2, @NotNull NotificationMessageCollector collector2) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Intrinsics.checkParameterIsNotNull((Object)library2, (String)"library");
        Intrinsics.checkParameterIsNotNull((Object)collector2, (String)"collector");
        DependencyScope expectedDependencyScope = KotlinWithLibraryConfigurator.Companion.getDependencyScope(module);
        Library kotlinLibrary = this.getKotlinLibrary(module);
        if (kotlinLibrary == null) {
            ModuleRootModificationUtil.addDependency((Module)module, (Library)library2, (DependencyScope)expectedDependencyScope, (boolean)false);
            collector2.addMessage(library2.getName() + " library was added to module " + module.getName());
        } else {
            DependencyScope libraryDependencyScope;
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
            Intrinsics.checkExpressionValueIsNotNull((Object)moduleRootManager, (String)"ModuleRootManager.getInstance(module)");
            OrderEntry[] orderEntryArray = moduleRootManager.getOrderEntries();
            Intrinsics.checkExpressionValueIsNotNull((Object)orderEntryArray, (String)"ModuleRootManager.getInstance(module).orderEntries");
            LibraryOrderEntry libraryEntry = KotlinWithLibraryConfigurator.Companion.findLibraryOrderEntry(orderEntryArray, kotlinLibrary);
            if (libraryEntry != null && Intrinsics.areEqual((Object)expectedDependencyScope, (Object)(libraryDependencyScope = libraryEntry.getScope())) ^ true) {
                libraryEntry.setScope(expectedDependencyScope);
                collector2.addMessage(kotlinLibrary.getName() + " library scope has changed from " + libraryDependencyScope + " to " + expectedDependencyScope + " for module " + module.getName());
            }
        }
    }

    @NotNull
    public final Library createNewLibrary(@NotNull Project project, @NotNull NotificationMessageCollector collector2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)collector2, (String)"collector");
        LibraryTable table = LibraryTablesRegistrar.getInstance().getLibraryTable(project);
        Library library2 = (Library)ApplicationUtilsKt.runWriteAction((Function0)new Function0<Library>(this, table){
            final /* synthetic */ KotlinWithLibraryConfigurator this$0;
            final /* synthetic */ LibraryTable $table;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Library invoke() {
                void var3_3;
                LibraryTable.ModifiableModel modifiableModel;
                LibraryTable libraryTable = this.$table;
                Intrinsics.checkExpressionValueIsNotNull((Object)libraryTable, (String)"table");
                LibraryTable.ModifiableModel $receiver = modifiableModel = libraryTable.getModifiableModel();
                Library library2 = $receiver.createLibrary(this.this$0.getLibraryName(), this.this$0.getLibraryKind());
                $receiver.commit();
                return var3_3;
            }
            {
                this.this$0 = kotlinWithLibraryConfigurator;
                this.$table = libraryTable;
                super(0);
            }
        });
        StringBuilder stringBuilder = new StringBuilder();
        Library library3 = library2;
        Intrinsics.checkExpressionValueIsNotNull((Object)library3, (String)"library");
        String string = library3.getName();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        collector2.addMessage(stringBuilder.append(string).append(" library was created").toString());
        return library2;
    }

    private final boolean isProjectLibraryPresent(Project project) {
        Library library2 = this.getKotlinLibrary(project);
        return library2 != null && ((Object[])library2.getUrls(OrderRootType.CLASSES)).length > 0;
    }

    @NotNull
    protected abstract Function1<Library, Boolean> getLibraryMatcher();

    @Nullable
    public final Library getKotlinLibrary(@NotNull Module module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        return OutdatedKotlinRuntimeCheckerKt.findKotlinRuntimeLibrary(module, (Function1<? super Library, Boolean>)((Function1)new Function1<Library, Boolean>(this){

            public final boolean invoke(@NotNull Library p1) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                return KotlinWithLibraryConfigurator.access$isKotlinLibrary((KotlinWithLibraryConfigurator)this.receiver, p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(KotlinWithLibraryConfigurator.class);
            }

            public final String getName() {
                return "isKotlinLibrary";
            }

            public final String getSignature() {
                return "isKotlinLibrary(Lcom/intellij/openapi/roots/libraries/Library;)Z";
            }
        }));
    }

    private final boolean isKotlinLibrary(Library library2) {
        return Intrinsics.areEqual((Object)library2.getName(), (Object)this.getLibraryName()) || (Boolean)this.getLibraryMatcher().invoke((Object)library2) != false;
    }

    protected final boolean needToChooseJarPath(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        String defaultPath = this.getDefaultPathToJarFile(project);
        return !this.isProjectLibraryPresent(project) && !new File(defaultPath, ((LibraryJarDescriptor)((Object)CollectionsKt.first(this.getLibraryJarDescriptors(null)))).getJarName()).exists();
    }

    @NotNull
    public String getDefaultPathToJarFile(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        String string = FileUIUtils.createRelativePath(project, project.getBaseDir(), Companion.getDEFAULT_LIBRARY_DIR());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"FileUIUtils.createRelati\u2026Dir, DEFAULT_LIBRARY_DIR)");
        return string;
    }

    @NotNull
    protected final FileState getJarState(@NotNull Project project, @NotNull File targetFile, @NotNull OrderRootType jarType, boolean useBundled) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)targetFile, (String)"targetFile");
        Intrinsics.checkParameterIsNotNull((Object)jarType, (String)"jarType");
        return targetFile.exists() ? FileState.EXISTS : (this.getPathFromLibrary(project, jarType) != null ? FileState.COPY : (useBundled ? FileState.DO_NOT_COPY : FileState.COPY));
    }

    private final String getPathToCopyFileTo(Project project, OrderRootType jarType, String defaultDir, String pathFromDialog) {
        if (pathFromDialog != null) {
            return pathFromDialog;
        }
        String pathFromLibrary = this.getPathFromLibrary(project, jarType);
        if (pathFromLibrary != null) {
            return pathFromLibrary;
        }
        return defaultDir;
    }

    @NotNull
    public abstract List<LibraryJarDescriptor> getLibraryJarDescriptors(@Nullable Sdk var1);

    protected void configureKotlinSettings(@NotNull List<? extends Module> modules) {
        Intrinsics.checkParameterIsNotNull(modules, (String)"modules");
    }

    @Nullable
    protected Library findAndFixBrokenKotlinLibrary(@NotNull Module module, @NotNull NotificationMessageCollector collector2) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Intrinsics.checkParameterIsNotNull((Object)collector2, (String)"collector");
        return null;
    }

    protected boolean isApplicable(@NotNull Module module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        return !KotlinPluginUtil.isAndroidGradleModule(module) && !KotlinPluginUtil.isMavenModule(module) && !KotlinPluginUtil.isGradleModule(module);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void changeCoroutineConfiguration(@NotNull Module module, @NotNull LanguageFeature.State state) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        if (!(Intrinsics.areEqual((Object)state, (Object)LanguageFeature.State.DISABLED) ^ true)) ** GOTO lbl-1000
        v0 = KotlinVersionInfoProviderKt.getRuntimeLibraryVersion(module);
        if (v0 != null ? StringsKt.startsWith$default((String)v0, (String)"1.0", (boolean)false, (int)2, null) : false) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = runtimeUpdateRequired = false;
        }
        if (runtimeUpdateRequired && !EnableUnsupportedFeatureFixKt.askUpdateRuntime(module, LanguageFeature.Coroutines.getSinceApiVersion())) {
            return;
        }
        v2 = module.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"module.project");
        facetSettings = KotlinFacetSettingsProvider.Companion.getInstance(v2).getInitializedSettings(module);
        ModuleRootModificationUtil.updateModel((Module)module, (Consumer)((Consumer)new Consumer<ModifiableRootModel>(facetSettings, state){
            final /* synthetic */ KotlinFacetSettings $facetSettings;
            final /* synthetic */ LanguageFeature.State $state;

            public final void consume(ModifiableRootModel it) {
                this.$facetSettings.setCoroutineSupport(this.$state);
                this.$facetSettings.setApiLevel(LanguageVersion.KOTLIN_1_1);
                this.$facetSettings.setLanguageLevel(LanguageVersion.KOTLIN_1_1);
            }
            {
                this.$facetSettings = kotlinFacetSettings;
                this.$state = state;
            }
        }));
    }

    @Override
    public void updateLanguageVersion(@NotNull Module module, @Nullable String languageVersion, @Nullable String apiVersion, @NotNull ApiVersion requiredStdlibVersion, boolean forTests) {
        boolean runtimeUpdateRequired;
        Object runtimeVersion;
        Object object;
        String it;
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Intrinsics.checkParameterIsNotNull((Object)requiredStdlibVersion, (String)"requiredStdlibVersion");
        Object object2 = KotlinVersionInfoProviderKt.getRuntimeLibraryVersion(module);
        boolean bl = object2 != null && (object2 = ApiVersion.Companion.parse(it = (object = object2))) != null ? ((ApiVersion)(runtimeVersion = (object = object2))).compareTo(requiredStdlibVersion) < 0 : (runtimeUpdateRequired = false);
        if (runtimeUpdateRequired && !EnableUnsupportedFeatureFixKt.askUpdateRuntime(module, requiredStdlibVersion)) {
            return;
        }
        Project project = module.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"module.project");
        KotlinFacetSettings facetSettings = KotlinFacetSettingsProvider.Companion.getInstance(project).getInitializedSettings(module);
        ModuleRootModificationUtil.updateModel((Module)module, (Consumer)((Consumer)new Consumer<ModifiableRootModel>(facetSettings, languageVersion, apiVersion){
            final /* synthetic */ KotlinFacetSettings $facetSettings;
            final /* synthetic */ String $languageVersion;
            final /* synthetic */ String $apiVersion;

            public final void consume(ModifiableRootModel it) {
                KotlinFacetSettings kotlinFacetSettings;
                KotlinFacetSettings $receiver = kotlinFacetSettings = this.$facetSettings;
                if (this.$languageVersion != null) {
                    $receiver.setLanguageLevel(LanguageVersion.Companion.fromVersionString(this.$languageVersion));
                }
                if (this.$apiVersion != null) {
                    $receiver.setApiLevel(LanguageVersion.Companion.fromVersionString(this.$apiVersion));
                }
            }
            {
                this.$facetSettings = kotlinFacetSettings;
                this.$languageVersion = string;
                this.$apiVersion = string2;
            }
        }));
    }

    @Override
    public void addLibraryDependency(@NotNull Module module, @NotNull PsiElement element3, @NotNull ExternalLibraryDescriptor library2, @NotNull List<? extends LibraryJarDescriptor> libraryJarDescriptors) {
        Project project;
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)library2, (String)"library");
        Intrinsics.checkParameterIsNotNull(libraryJarDescriptors, (String)"libraryJarDescriptors");
        Project project2 = project = module.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        NotificationMessageCollector collector2 = NotificationMessageCollectorKt.createConfigureKotlinNotificationCollector(project2);
        Iterator iterator2 = KotlinRuntimeLibraryUtilKt.findAllUsedLibraries(project).keySet().iterator();
        while (iterator2.hasNext()) {
            VirtualFile runtimeJar;
            Library library3;
            Library library4 = library3 = (Library)iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)library4, (String)"library");
            if (LibraryJarDescriptor.RUNTIME_JAR.findExistingJar(library4) == null) {
                continue;
            }
            Library.ModifiableModel model = library3.getModifiableModel();
            File file2 = VfsUtilCore.virtualToIoFile((VirtualFile)runtimeJar);
            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"VfsUtilCore.virtualToIoFile(runtimeJar)");
            String libFilesDir = file2.getParent();
            for (LibraryJarDescriptor libraryJarDescriptor : libraryJarDescriptors) {
                File copied;
                File libFile;
                if (libraryJarDescriptor.findExistingJar(library3) != null || !(libFile = libraryJarDescriptor.getPathInPlugin()).exists()) continue;
                File libIoFile = new File(libFilesDir, libraryJarDescriptor.getJarName());
                if (libIoFile.exists()) {
                    model.addRoot(VfsUtil.getUrlForLibraryRoot((File)libIoFile), libraryJarDescriptor.getOrderRootType());
                    continue;
                }
                String string = libFilesDir;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"libFilesDir");
                if (this.copyFileToDir(libFile, string, collector2) == null) {
                    Intrinsics.throwNpe();
                }
                model.addRoot(VfsUtil.getUrlForLibraryRoot((File)copied), libraryJarDescriptor.getOrderRootType());
            }
            model.commit();
        }
        collector2.showNotification();
    }

    public KotlinWithLibraryConfigurator() {
        LibraryType<DummyLibraryProperties> libraryType = this.getLibraryType();
        this.libraryKind = libraryType != null ? libraryType.getKind() : null;
    }

    static {
        DEFAULT_LIBRARY_DIR = DEFAULT_LIBRARY_DIR;
    }

    public static final /* synthetic */ boolean access$isKotlinLibrary(KotlinWithLibraryConfigurator $this, @NotNull Library library2) {
        return $this.isKotlinLibrary(library2);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator$FileState;", "", "(Ljava/lang/String;I)V", "EXISTS", "COPY", "DO_NOT_COPY", "idea"})
    public static final class FileState
    extends Enum<FileState> {
        public static final /* enum */ FileState EXISTS;
        public static final /* enum */ FileState COPY;
        public static final /* enum */ FileState DO_NOT_COPY;
        private static final /* synthetic */ FileState[] $VALUES;

        static {
            FileState[] fileStateArray = new FileState[3];
            FileState[] fileStateArray2 = fileStateArray;
            fileStateArray[0] = EXISTS = new FileState();
            fileStateArray[1] = COPY = new FileState();
            fileStateArray[2] = DO_NOT_COPY = new FileState();
            $VALUES = fileStateArray;
        }

        public static FileState[] values() {
            return (FileState[])$VALUES.clone();
        }

        public static FileState valueOf(String string) {
            return Enum.valueOf(FileState.class, string);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J%\u0010\u0007\u001a\u0004\u0018\u00010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00042\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0014\u001a\u00020\u0015J\u001b\u0010\u0016\u001a\u0004\u0018\u00010\u00042\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\n\u00a2\u0006\u0002\u0010\u0018R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator$Companion;", "", "()V", "DEFAULT_LIBRARY_DIR", "", "getDEFAULT_LIBRARY_DIR", "()Ljava/lang/String;", "findLibraryOrderEntry", "Lcom/intellij/openapi/roots/LibraryOrderEntry;", "orderEntries", "", "Lcom/intellij/openapi/roots/OrderEntry;", "library", "Lcom/intellij/openapi/roots/libraries/Library;", "([Lcom/intellij/openapi/roots/OrderEntry;Lcom/intellij/openapi/roots/libraries/Library;)Lcom/intellij/openapi/roots/LibraryOrderEntry;", "getDependencyScope", "Lcom/intellij/openapi/roots/DependencyScope;", "module", "Lcom/intellij/openapi/module/Module;", "getPathFromLibrary", "type", "Lcom/intellij/openapi/roots/OrderRootType;", "getPathFromLibraryUrls", "libraryFiles", "([Ljava/lang/String;)Ljava/lang/String;", "idea"})
    public static final class Companion {
        @NotNull
        public final String getDEFAULT_LIBRARY_DIR() {
            return DEFAULT_LIBRARY_DIR;
        }

        @Nullable
        public final String getPathFromLibrary(@Nullable Library library2, @NotNull OrderRootType type2) {
            Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
            if (library2 == null) {
                return null;
            }
            String[] libraryFiles = library2.getUrls(type2);
            Intrinsics.checkExpressionValueIsNotNull((Object)libraryFiles, (String)"libraryFiles");
            return this.getPathFromLibraryUrls(libraryFiles);
        }

        @Nullable
        public final String getPathFromLibraryUrls(@NotNull String[] libraryFiles) {
            Intrinsics.checkParameterIsNotNull((Object)libraryFiles, (String)"libraryFiles");
            if (((Object[])libraryFiles).length < 1) {
                return null;
            }
            String pathToJarInLib = VfsUtilCore.urlToPath((String)libraryFiles[0]);
            String string = VfsUtil.getParentDir((String)VfsUtil.getParentDir((String)pathToJarInLib));
            if (string == null) {
                return null;
            }
            String parentDir = string;
            File parentDirFile = new File(parentDir);
            if (!parentDirFile.exists() && !parentDirFile.mkdirs()) {
                return null;
            }
            return parentDir;
        }

        private final LibraryOrderEntry findLibraryOrderEntry(OrderEntry[] orderEntries, Library library2) {
            for (int i = 0; i < orderEntries.length; ++i) {
                OrderEntry orderEntry = orderEntries[i];
                if (!(orderEntry instanceof LibraryOrderEntry) || !Intrinsics.areEqual((Object)library2, (Object)((LibraryOrderEntry)orderEntry).getLibrary())) continue;
                return (LibraryOrderEntry)orderEntry;
            }
            return null;
        }

        private final DependencyScope getDependencyScope(Module module) {
            if (ConfigureKotlinInProjectUtilsKt.hasKotlinFilesOnlyInTests(module)) {
                return DependencyScope.TEST;
            }
            return DependencyScope.COMPILE;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

