/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.script;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.psi.search.NonClasspathDirectoriesScope;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.script.experimental.dependencies.ScriptDependencies;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.core.script.ScriptDependenciesCache;
import org.jetbrains.kotlin.idea.core.script.ScriptDependenciesManager;
import org.jetbrains.kotlin.idea.core.script.ScriptDependenciesUpdater;
import org.jetbrains.kotlin.script.KotlinScriptDefinition;
import org.jetbrains.kotlin.script.KotlinScriptDefinitionProvider;
import org.jetbrains.kotlin.script.ScriptTemplateProviderExtensionPointKt;
import org.jetbrains.kotlin.script.ScriptTemplatesProvider;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B'\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fJ\u0006\u0010\u000e\u001a\u00020\u000fJ\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\fJ\u0006\u0010\u0011\u001a\u00020\u000fJ\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0013\u001a\u00020\rJ\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\rJ\b\u0010\u0016\u001a\u00020\u0017H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/ScriptDependenciesManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "scriptDefinitionProvider", "Lorg/jetbrains/kotlin/script/KotlinScriptDefinitionProvider;", "cacheUpdater", "Lorg/jetbrains/kotlin/idea/core/script/ScriptDependenciesUpdater;", "cache", "Lorg/jetbrains/kotlin/idea/core/script/ScriptDependenciesCache;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/kotlin/script/KotlinScriptDefinitionProvider;Lorg/jetbrains/kotlin/idea/core/script/ScriptDependenciesUpdater;Lorg/jetbrains/kotlin/idea/core/script/ScriptDependenciesCache;)V", "getAllLibrarySources", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "getAllLibrarySourcesScope", "Lcom/intellij/psi/search/NonClasspathDirectoriesScope;", "getAllScriptsClasspath", "getAllScriptsClasspathScope", "getScriptClasspath", "file", "getScriptDependencies", "Lkotlin/script/experimental/dependencies/ScriptDependencies;", "reloadScriptDefinitions", "", "Companion", "idea-core"})
public final class ScriptDependenciesManager {
    private final Project project;
    private final KotlinScriptDefinitionProvider scriptDefinitionProvider;
    private final ScriptDependenciesUpdater cacheUpdater;
    private final ScriptDependenciesCache cache;
    @NotNull
    private static final Logger log;
    public static final Companion Companion;

    @NotNull
    public final List<VirtualFile> getScriptClasspath(@NotNull VirtualFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        return Companion.toVfsRoots(this.cacheUpdater.getCurrentDependencies(file2).getClasspath());
    }

    @NotNull
    public final ScriptDependencies getScriptDependencies(@NotNull VirtualFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        return this.cacheUpdater.getCurrentDependencies(file2);
    }

    private final void reloadScriptDefinitions() {
        List<KotlinScriptDefinition> def2 = ScriptTemplateProviderExtensionPointKt.makeScriptDefsFromTemplatesProviderExtensions(this.project, (Function2<? super ScriptTemplatesProvider, ? super Throwable, Unit>)((Function2)reloadScriptDefinitions.def.1.INSTANCE));
        this.scriptDefinitionProvider.setScriptDefinitions(def2);
    }

    @NotNull
    public final NonClasspathDirectoriesScope getAllScriptsClasspathScope() {
        return this.cache.getAllScriptsClasspathScope().get();
    }

    @NotNull
    public final NonClasspathDirectoriesScope getAllLibrarySourcesScope() {
        return this.cache.getAllLibrarySourcesScope().get();
    }

    @NotNull
    public final List<VirtualFile> getAllLibrarySources() {
        return this.cache.getAllLibrarySourcesCache().get();
    }

    @NotNull
    public final List<VirtualFile> getAllScriptsClasspath() {
        return this.cache.getAllScriptsClasspathCache().get();
    }

    public ScriptDependenciesManager(@NotNull Project project, @NotNull KotlinScriptDefinitionProvider scriptDefinitionProvider, @NotNull ScriptDependenciesUpdater cacheUpdater, @NotNull ScriptDependenciesCache cache2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)scriptDefinitionProvider, (String)"scriptDefinitionProvider");
        Intrinsics.checkParameterIsNotNull((Object)cacheUpdater, (String)"cacheUpdater");
        Intrinsics.checkParameterIsNotNull((Object)cache2, (String)"cache");
        this.project = project;
        this.scriptDefinitionProvider = scriptDefinitionProvider;
        this.cacheUpdater = cacheUpdater;
        this.cache = cache2;
        this.reloadScriptDefinitions();
    }

    static {
        Companion = new Companion(null);
        log = Logger.getInstance(ScriptDependenciesManager.class);
    }

    @JvmStatic
    @NotNull
    public static final ScriptDependenciesManager getInstance(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return Companion.getInstance(project);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0007J\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011J\u0018\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\nH\u0007J\u000e\u0010\u0015\u001a\u0004\u0018\u00010\u000f*\u00020\u0012H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/ScriptDependenciesManager$Companion;", "", "()V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "getLog$idea_core", "()Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lorg/jetbrains/kotlin/idea/core/script/ScriptDependenciesManager;", "project", "Lcom/intellij/openapi/project/Project;", "reloadScriptDefinitions", "", "toVfsRoots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "roots", "", "Ljava/io/File;", "updateScriptDependenciesSynchronously", "virtualFile", "classpathEntryToVfs", "idea-core"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final ScriptDependenciesManager getInstance(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Object object = ServiceManager.getService((Project)project, ScriptDependenciesManager.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ServiceManager.getServic\u2026nciesManager::class.java)");
            return (ScriptDependenciesManager)object;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<VirtualFile> toVfsRoots(@NotNull Iterable<? extends File> roots) {
            void $receiver$iv$iv;
            Iterable<? extends File> $receiver$iv;
            Intrinsics.checkParameterIsNotNull(roots, (String)"roots");
            Iterable<? extends File> iterable = $receiver$iv = roots;
            Collection destination$iv$iv = new ArrayList();
            void $receiver$iv$iv$iv = $receiver$iv$iv;
            for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
                VirtualFile virtualFile2;
                Object element$iv$iv = element$iv$iv$iv;
                File it = (File)element$iv$iv;
                if (Companion.classpathEntryToVfs(it) == null) continue;
                VirtualFile it$iv$iv = virtualFile2;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        private final VirtualFile classpathEntryToVfs(@NotNull File $receiver) {
            Object object;
            if (!$receiver.exists()) {
                object = null;
            } else if ($receiver.isDirectory()) {
                VirtualFileSystem virtualFileSystem = StandardFileSystems.local();
                object = virtualFileSystem != null ? virtualFileSystem.findFileByPath($receiver.getCanonicalPath()) : null;
            } else if ($receiver.isFile()) {
                VirtualFileSystem virtualFileSystem = StandardFileSystems.jar();
                object = virtualFileSystem != null ? virtualFileSystem.findFileByPath($receiver.getCanonicalPath() + "!/") : null;
            } else {
                object = null;
            }
            VirtualFile res2 = object;
            return res2;
        }

        @NotNull
        public final Logger getLog$idea_core() {
            return log;
        }

        public final void updateScriptDependenciesSynchronously(@NotNull VirtualFile virtualFile2, @NotNull Project project) {
            ScriptDependenciesManager scriptDependenciesManager;
            Intrinsics.checkParameterIsNotNull((Object)virtualFile2, (String)"virtualFile");
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            ScriptDependenciesManager $receiver = scriptDependenciesManager = this.getInstance(project);
            KotlinScriptDefinitionProvider kotlinScriptDefinitionProvider = KotlinScriptDefinitionProvider.Companion.getInstance(project);
            if (kotlinScriptDefinitionProvider == null) {
                Intrinsics.throwNpe();
            }
            KotlinScriptDefinition kotlinScriptDefinition = kotlinScriptDefinitionProvider.findScriptDefinition(virtualFile2);
            if (kotlinScriptDefinition == null) {
                Intrinsics.throwNpe();
            }
            KotlinScriptDefinition scriptDefinition2 = kotlinScriptDefinition;
            $receiver.cacheUpdater.updateSync(virtualFile2, scriptDefinition2);
            $receiver.cacheUpdater.notifyRootsChanged();
        }

        public final void reloadScriptDefinitions(@NotNull Project project) {
            ScriptDependenciesManager scriptDependenciesManager;
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            ScriptDependenciesManager $receiver = scriptDependenciesManager = this.getInstance(project);
            $receiver.reloadScriptDefinitions();
            $receiver.cacheUpdater.clear();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

