/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.stepping;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.CompoundPositionManager;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.NamedMethodFilter;
import com.intellij.psi.PsiElement;
import com.intellij.util.Range;
import com.intellij.util.SofterReference;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.functions.FunctionInvokeDescriptor;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.DescriptorUtilsKt;
import org.jetbrains.kotlin.idea.debugger.stepping.KotlinBasicStepMethodFilter;
import org.jetbrains.kotlin.idea.debugger.stepping.KotlinBasicStepMethodFilter$WhenMappings;
import org.jetbrains.kotlin.idea.debugger.stepping.KotlinBasicStepMethodFilterKt;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.DescriptorUtils;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\b\u0010\r\u001a\u00020\u000bH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/stepping/KotlinBasicStepMethodFilter;", "Lcom/intellij/debugger/engine/NamedMethodFilter;", "targetDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "myCallingExpressionLines", "Lcom/intellij/util/Range;", "", "(Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;Lcom/intellij/util/Range;)V", "_targetDescriptor", "Lcom/intellij/util/SofterReference;", "myTargetMethodName", "", "getCallingExpressionLines", "getMethodName", "locationMatches", "", "process", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "location", "Lcom/sun/jdi/Location;", "idea"})
public final class KotlinBasicStepMethodFilter
implements NamedMethodFilter {
    private final String myTargetMethodName;
    private final SofterReference<CallableMemberDescriptor> _targetDescriptor;
    private final Range<Integer> myCallingExpressionLines;

    @NotNull
    public Range<Integer> getCallingExpressionLines() {
        return this.myCallingExpressionLines;
    }

    @NotNull
    public String getMethodName() {
        return this.myTargetMethodName;
    }

    public boolean locationMatches(@NotNull DebugProcessImpl process2, @NotNull Location location2) {
        boolean bl;
        block23: {
            boolean bl2;
            Iterable $receiver$iv;
            Collection baseDescriptors2;
            DeclarationDescriptor currentDescriptor2;
            block21: {
                Collection collection;
                Intrinsics.checkParameterIsNotNull((Object)process2, (String)"process");
                Intrinsics.checkParameterIsNotNull((Object)location2, (String)"location");
                CallableMemberDescriptor callableMemberDescriptor = (CallableMemberDescriptor)this._targetDescriptor.get();
                if (callableMemberDescriptor == null) {
                    return true;
                }
                CallableMemberDescriptor targetDescriptor = callableMemberDescriptor;
                Method method = location2.method();
                if (Intrinsics.areEqual((Object)this.myTargetMethodName, (Object)method.name()) ^ true) {
                    return false;
                }
                CompoundPositionManager positionManager = process2.getPositionManager();
                DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)ApplicationUtilsKt.runReadAction((Function0)new Function0<DeclarationDescriptor>(positionManager, location2, method){
                    final /* synthetic */ CompoundPositionManager $positionManager;
                    final /* synthetic */ Location $location;
                    final /* synthetic */ Method $method;

                    @Nullable
                    public final DeclarationDescriptor invoke() {
                        DeclarationDescriptor declarationDescriptor;
                        KtDeclaration declaration2;
                        PsiElement elementAt;
                        SourcePosition sourcePosition = this.$positionManager.getSourcePosition(this.$location);
                        PsiElement psiElement2 = elementAt = sourcePosition != null ? sourcePosition.getElementAt() : null;
                        KtDeclaration ktDeclaration = declaration2 = psiElement2 != null ? (KtDeclaration)PsiUtilsKt.getParentOfTypesAndPredicate(psiElement2, false, new Class[]{KtDeclaration.class}, locationMatches.currentDescriptor.declaration.1.INSTANCE) : null;
                        if (declaration2 instanceof KtClass && Intrinsics.areEqual((Object)this.$method.name(), (Object)"<init>")) {
                            DeclarationDescriptor declarationDescriptor2 = ResolutionUtils.resolveToDescriptorIfAny$default(declaration2, null, 1, null);
                            if (!(declarationDescriptor2 instanceof ClassDescriptor)) {
                                declarationDescriptor2 = null;
                            }
                            ClassDescriptor classDescriptor = (ClassDescriptor)declarationDescriptor2;
                            declarationDescriptor = classDescriptor != null ? classDescriptor.getUnsubstitutedPrimaryConstructor() : null;
                        } else {
                            KtDeclaration ktDeclaration2 = declaration2;
                            declarationDescriptor = ktDeclaration2 != null ? ResolutionUtils.resolveToDescriptorIfAny$default(ktDeclaration2, null, 1, null) : null;
                        }
                        return declarationDescriptor;
                    }
                    {
                        this.$positionManager = compoundPositionManager;
                        this.$location = location2;
                        this.$method = method;
                        super(0);
                    }
                });
                if (declarationDescriptor == null) {
                    return false;
                }
                currentDescriptor2 = declarationDescriptor;
                if (!(currentDescriptor2 instanceof CallableMemberDescriptor)) {
                    return false;
                }
                if (Intrinsics.areEqual((Object)((Object)((CallableMemberDescriptor)currentDescriptor2).getKind()), (Object)((Object)CallableMemberDescriptor.Kind.DECLARATION)) ^ true) {
                    return false;
                }
                if (targetDescriptor instanceof FunctionInvokeDescriptor) {
                    return true;
                }
                CallableMemberDescriptor callableMemberDescriptor2 = targetDescriptor;
                Intrinsics.checkExpressionValueIsNotNull((Object)callableMemberDescriptor2, (String)"targetDescriptor");
                if (KotlinBasicStepMethodFilterKt.access$compareDescriptors(currentDescriptor2, callableMemberDescriptor2)) {
                    return true;
                }
                switch (KotlinBasicStepMethodFilter$WhenMappings.$EnumSwitchMapping$0[targetDescriptor.getKind().ordinal()]) {
                    case 1: 
                    case 2: {
                        collection = DescriptorUtilsKt.getDirectlyOverriddenDeclarations(targetDescriptor);
                        break;
                    }
                    case 3: 
                    case 4: {
                        collection = CollectionsKt.listOf((Object)targetDescriptor);
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                baseDescriptors2 = collection;
                $receiver$iv = baseDescriptors2;
                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $receiver$iv) {
                        CallableMemberDescriptor baseOfTarget;
                        CallableMemberDescriptor callableMemberDescriptor3 = baseOfTarget = (CallableMemberDescriptor)element$iv;
                        Intrinsics.checkExpressionValueIsNotNull((Object)callableMemberDescriptor3, (String)"baseOfTarget");
                        if (!KotlinBasicStepMethodFilterKt.access$compareDescriptors(callableMemberDescriptor3, currentDescriptor2)) continue;
                        bl2 = true;
                        break block21;
                    }
                    bl2 = false;
                }
            }
            if (bl2) {
                return true;
            }
            Set<CallableDescriptor> set2 = DescriptorUtils.getAllOverriddenDescriptors((CallableDescriptor)currentDescriptor2);
            Intrinsics.checkExpressionValueIsNotNull(set2, (String)"DescriptorUtils.getAllOv\u2026iptors(currentDescriptor)");
            $receiver$iv = set2;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    boolean bl3;
                    block22: {
                        CallableMemberDescriptor baseOfCurrent = (CallableMemberDescriptor)element$iv;
                        Iterable $receiver$iv2 = baseDescriptors2;
                        if ($receiver$iv2 instanceof Collection && ((Collection)$receiver$iv2).isEmpty()) {
                            bl3 = false;
                        } else {
                            for (Object element$iv2 : $receiver$iv2) {
                                CallableMemberDescriptor baseOfTarget = (CallableMemberDescriptor)element$iv2;
                                CallableMemberDescriptor callableMemberDescriptor = baseOfCurrent;
                                Intrinsics.checkExpressionValueIsNotNull((Object)callableMemberDescriptor, (String)"baseOfCurrent");
                                DeclarationDescriptor declarationDescriptor = callableMemberDescriptor;
                                CallableMemberDescriptor callableMemberDescriptor4 = baseOfTarget;
                                Intrinsics.checkExpressionValueIsNotNull((Object)callableMemberDescriptor4, (String)"baseOfTarget");
                                if (!KotlinBasicStepMethodFilterKt.access$compareDescriptors(declarationDescriptor, callableMemberDescriptor4)) continue;
                                bl3 = true;
                                break block22;
                            }
                            bl3 = false;
                        }
                    }
                    if (!bl3) continue;
                    bl = true;
                    break block23;
                }
                bl = false;
            }
        }
        return bl;
    }

    public KotlinBasicStepMethodFilter(@NotNull CallableMemberDescriptor targetDescriptor, @NotNull Range<Integer> myCallingExpressionLines) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)targetDescriptor, (String)"targetDescriptor");
        Intrinsics.checkParameterIsNotNull(myCallingExpressionLines, (String)"myCallingExpressionLines");
        this.myCallingExpressionLines = myCallingExpressionLines;
        CallableMemberDescriptor callableMemberDescriptor = targetDescriptor;
        if (callableMemberDescriptor instanceof ClassDescriptor || callableMemberDescriptor instanceof ConstructorDescriptor) {
            string = "<init>";
        } else if (callableMemberDescriptor instanceof PropertyAccessorDescriptor) {
            PropertyDescriptor propertyDescriptor = ((PropertyAccessorDescriptor)targetDescriptor).getCorrespondingProperty();
            Intrinsics.checkExpressionValueIsNotNull((Object)propertyDescriptor, (String)"targetDescriptor.correspondingProperty");
            String string2 = JvmAbi.getterName(propertyDescriptor.getName().asString());
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"JvmAbi.getterName(target\u2026Property.name.asString())");
        } else {
            String string3 = targetDescriptor.getName().asString();
            string = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"targetDescriptor.name.asString()");
        }
        this.myTargetMethodName = string;
        this._targetDescriptor = new SofterReference((Object)targetDescriptor);
    }
}

