/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters1;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.idea.core.quickfix.QuickFixUtil;
import org.jetbrains.kotlin.idea.intentions.SpecifyTypeExplicitlyIntention;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u0000 \u001b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u001b\u001cB\u000f\b\u0012\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004B%\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016J\"\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\"\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0016H\u0016J \u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u0006H\u0002R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/RemovePartsFromPropertyFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtProperty;", "element", "(Lorg/jetbrains/kotlin/psi/KtProperty;)V", "removeInitializer", "", "removeGetter", "removeSetter", "(Lorg/jetbrains/kotlin/psi/KtProperty;ZZZ)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "isAvailable", "Lcom/intellij/psi/PsiFile;", "partsToRemove", "getter", "setter", "initializer", "Companion", "LateInitFactory", "idea"})
public class RemovePartsFromPropertyFix
extends KotlinQuickFixAction<KtProperty> {
    private final boolean removeInitializer;
    private final boolean removeGetter;
    private final boolean removeSetter;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getText() {
        return "Remove " + this.partsToRemove(this.removeGetter, this.removeSetter, this.removeInitializer) + " from property";
    }

    @NotNull
    public String getFamilyName() {
        return "Remove parts from property";
    }

    @Override
    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull PsiFile file2) {
        KotlinType type2;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        if (!super.isAvailable(project, editor, file2)) {
            return false;
        }
        KotlinType kotlinType = QuickFixUtil.getDeclarationReturnType((KtNamedDeclaration)this.getElement());
        if (kotlinType == null) {
            return false;
        }
        KotlinType kotlinType2 = type2 = kotlinType;
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"type");
        return !KotlinTypeKt.isError(kotlinType2);
    }

    @Override
    public void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file2) {
        KtProperty replaceElement;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        KtProperty ktProperty = (KtProperty)this.getElement();
        Object object = ktProperty != null ? ktProperty.copy() : null;
        if (!(object instanceof KtProperty)) {
            object = null;
        }
        KtProperty ktProperty2 = (KtProperty)object;
        if (ktProperty2 == null) {
            return;
        }
        KtProperty newElement = ktProperty2;
        KtPropertyAccessor getter = newElement.getGetter();
        if (this.removeGetter && getter != null) {
            newElement.deleteChildInternal(getter.getNode());
        }
        KtPropertyAccessor setter = newElement.getSetter();
        if (this.removeSetter && setter != null) {
            newElement.deleteChildInternal(setter.getNode());
        }
        KtExpression initializer2 = newElement.getInitializer();
        KotlinType typeToAdd = null;
        if (this.removeInitializer && initializer2 != null) {
            PsiElement nextSibling;
            PsiElement psiElement2 = newElement.getNameIdentifier();
            Object object2 = nextSibling = psiElement2 != null ? psiElement2.getNextSibling() : null;
            if (nextSibling != null) {
                newElement.deleteChildRange(nextSibling, (PsiElement)initializer2);
                KotlinType type2 = QuickFixUtil.getDeclarationReturnType((KtNamedDeclaration)this.getElement());
                if (newElement.getTypeReference() == null && type2 != null) {
                    typeToAdd = type2;
                }
            }
        }
        KtProperty ktProperty3 = (KtProperty)this.getElement();
        PsiElement psiElement3 = ktProperty3 != null ? ktProperty3.replace(newElement) : null;
        if (!(psiElement3 instanceof KtProperty)) {
            psiElement3 = null;
        }
        if ((replaceElement = (KtProperty)psiElement3) != null && typeToAdd != null) {
            SpecifyTypeExplicitlyIntention.Companion.addTypeAnnotation(editor, replaceElement, typeToAdd);
        }
    }

    private final String partsToRemove(boolean getter, boolean setter, boolean initializer2) {
        StringBuilder stringBuilder;
        StringBuilder $receiver = stringBuilder = new StringBuilder();
        if (getter) {
            $receiver.append("getter");
            if (setter && initializer2) {
                $receiver.append(", ");
            } else if (setter || initializer2) {
                $receiver.append(" and ");
            }
        }
        if (setter) {
            $receiver.append("setter");
            if (initializer2) {
                $receiver.append(" and ");
            }
        }
        if (initializer2) {
            $receiver.append("initializer");
        }
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    public RemovePartsFromPropertyFix(@NotNull KtProperty element3, boolean removeInitializer, boolean removeGetter, boolean removeSetter) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        super((PsiElement)element3);
        this.removeInitializer = removeInitializer;
        this.removeGetter = removeGetter;
        this.removeSetter = removeSetter;
    }

    private RemovePartsFromPropertyFix(KtProperty element3) {
        KtPropertyAccessor ktPropertyAccessor = element3.getGetter();
        KtPropertyAccessor ktPropertyAccessor2 = element3.getSetter();
        this(element3, element3.hasInitializer(), (ktPropertyAccessor != null ? ktPropertyAccessor.getBodyExpression() : null) != null, (ktPropertyAccessor2 != null ? ktPropertyAccessor2.getBodyExpression() : null) != null);
    }

    public /* synthetic */ RemovePartsFromPropertyFix(@NotNull KtProperty element3, DefaultConstructorMarker $constructor_marker) {
        this(element3);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/RemovePartsFromPropertyFix$LateInitFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtProperty;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "idea"})
    public static final class LateInitFactory
    extends KotlinSingleIntentionActionFactory {
        public static final LateInitFactory INSTANCE;

        @Override
        @Nullable
        public KotlinQuickFixAction<KtProperty> createAction(@NotNull Diagnostic diagnostic) {
            boolean hasSetter;
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            Object d = Errors.INAPPLICABLE_LATEINIT_MODIFIER.cast(diagnostic);
            Intrinsics.checkExpressionValueIsNotNull(d, (String)"Errors.INAPPLICABLE_LATE\u2026MODIFIER.cast(diagnostic)");
            Object element3 = ((DiagnosticWithParameters1)d).getPsiElement();
            KtProperty ktProperty = (KtProperty)PsiTreeUtil.getParentOfType(element3, KtProperty.class);
            if (ktProperty == null) {
                return null;
            }
            KtProperty property2 = ktProperty;
            boolean hasInitializer = property2.hasInitializer();
            KtProperty ktProperty2 = property2;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktProperty2, (String)"property");
            KtPropertyAccessor ktPropertyAccessor = ktProperty2.getGetter();
            boolean hasGetter = (ktPropertyAccessor != null ? ktPropertyAccessor.getBodyExpression() : null) != null;
            KtPropertyAccessor ktPropertyAccessor2 = property2.getSetter();
            boolean bl = hasSetter = (ktPropertyAccessor2 != null ? ktPropertyAccessor2.getBodyExpression() : null) != null;
            if (!(hasInitializer || hasGetter || hasSetter)) {
                return null;
            }
            return new RemovePartsFromPropertyFix(property2, hasInitializer, hasGetter, hasSetter);
        }

        private LateInitFactory() {
        }

        static {
            LateInitFactory lateInitFactory;
            INSTANCE = lateInitFactory = new LateInitFactory();
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/RemovePartsFromPropertyFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtProperty;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "idea"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        @Override
        @Nullable
        protected KotlinQuickFixAction<KtProperty> createAction(@NotNull Diagnostic diagnostic) {
            KtProperty property2;
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            PsiElement element3 = diagnostic.getPsiElement();
            KtProperty ktProperty = (KtProperty)PsiTreeUtil.getParentOfType((PsiElement)element3, KtProperty.class);
            if (ktProperty == null) {
                return null;
            }
            KtProperty ktProperty2 = property2 = ktProperty;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktProperty2, (String)"property");
            return new RemovePartsFromPropertyFix(ktProperty2, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

