/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.PsiElementPlaceholderArgumentType;
import org.jetbrains.kotlin.psi.psiUtil.PsiChildRange;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c2\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/psi/PsiChildRangeArgumentType;", "Lorg/jetbrains/kotlin/psi/PsiElementPlaceholderArgumentType;", "Lorg/jetbrains/kotlin/psi/psiUtil/PsiChildRange;", "Lorg/jetbrains/kotlin/psi/KtElement;", "()V", "replacePlaceholderElement", "placeholder", "argument", "frontend"})
final class PsiChildRangeArgumentType
extends PsiElementPlaceholderArgumentType<PsiChildRange, KtElement> {
    public static final PsiChildRangeArgumentType INSTANCE;

    @Override
    @NotNull
    public PsiChildRange replacePlaceholderElement(@NotNull KtElement placeholder, @NotNull PsiChildRange argument2) {
        PsiChildRange psiChildRange;
        Intrinsics.checkParameterIsNotNull((Object)placeholder, (String)"placeholder");
        Intrinsics.checkParameterIsNotNull((Object)argument2, (String)"argument");
        Project project = placeholder.getProject();
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
        if (!argument2.isEmpty()) {
            PsiElement psiElement2 = placeholder.getParent();
            PsiElement psiElement3 = argument2.getFirst();
            if (psiElement3 == null) {
                Intrinsics.throwNpe();
            }
            PsiElement psiElement4 = argument2.getLast();
            if (psiElement4 == null) {
                Intrinsics.throwNpe();
            }
            PsiElement first = psiElement2.addRangeBefore(psiElement3, psiElement4, (PsiElement)placeholder);
            PsiElement last = placeholder.getPrevSibling();
            placeholder.delete();
            PsiElement psiElement5 = first;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement5, (String)"first");
            ASTNode aSTNode = psiElement5.getNode();
            Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"first.node");
            codeStyleManager.reformatNewlyAddedElement(aSTNode.getTreeParent(), first.getNode());
            if (Intrinsics.areEqual((Object)last, (Object)first) ^ true) {
                PsiElement psiElement6 = last;
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement6, (String)"last");
                ASTNode aSTNode2 = psiElement6.getNode();
                Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode2, (String)"last.node");
                codeStyleManager.reformatNewlyAddedElement(aSTNode2.getTreeParent(), last.getNode());
            }
            psiChildRange = new PsiChildRange(first, last);
        } else {
            placeholder.delete();
            psiChildRange = PsiChildRange.Companion.getEMPTY();
        }
        return psiChildRange;
    }

    private PsiChildRangeArgumentType() {
        super(PsiChildRange.class, KtElement.class);
    }

    static {
        PsiChildRangeArgumentType psiChildRangeArgumentType;
        INSTANCE = psiChildRangeArgumentType = new PsiChildRangeArgumentType();
    }
}

