/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.functions.FunctionInvokeDescriptor;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.LambdaArgument;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.ValueArgumentName;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.OverrideResolver;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.DefaultValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ExpressionValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.MutableResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VarargValueArgument;
import org.jetbrains.kotlin.resolve.calls.tasks.TracingStrategy;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

public class ValueArgumentsToParametersMapper {
    public static <D extends CallableDescriptor> Status mapValueArgumentsToParameters(@NotNull Call call2, @NotNull TracingStrategy tracing, @NotNull MutableResolvedCall<D> candidateCall) {
        Processor processor2 = new Processor(call2, candidateCall, tracing);
        processor2.process();
        return processor2.status;
    }

    private ValueArgumentsToParametersMapper() {
    }

    private static class Processor<D extends CallableDescriptor> {
        private final Call call;
        private final TracingStrategy tracing;
        private final MutableResolvedCall<D> candidateCall;
        private final List<ValueParameterDescriptor> parameters;
        private final Map<Name, ValueParameterDescriptor> parameterByName;
        private Map<Name, ValueParameterDescriptor> parameterByNameInOverriddenMethods;
        private final Map<ValueParameterDescriptor, VarargValueArgument> varargs = Maps.newHashMap();
        private final Set<ValueParameterDescriptor> usedParameters = Sets.newHashSet();
        private Status status = Status.OK;
        private final ProcessorState positionedOnly = new ProcessorState(){
            private int currentParameter = 0;

            private int numberOfParametersForPositionedArguments() {
                return call.getCallType() == Call.CallType.ARRAY_SET_METHOD ? parameters.size() - 1 : parameters.size();
            }

            @Nullable
            public ValueParameterDescriptor nextValueParameter() {
                if (this.currentParameter >= this.numberOfParametersForPositionedArguments()) {
                    return null;
                }
                ValueParameterDescriptor head = (ValueParameterDescriptor)parameters.get(this.currentParameter);
                if (head.getVarargElementType() == null) {
                    ++this.currentParameter;
                }
                return head;
            }

            @Override
            public ProcessorState processNamedArgument(@NotNull ValueArgument argument2) {
                return positionedThenNamed.processNamedArgument(argument2);
            }

            @Override
            public ProcessorState processPositionedArgument(@NotNull ValueArgument argument2) {
                this.processArgument(argument2, this.nextValueParameter());
                return positionedOnly;
            }

            @Override
            public ProcessorState processArraySetRHS(@NotNull ValueArgument argument2) {
                this.processArgument(argument2, (ValueParameterDescriptor)CollectionsKt.lastOrNull((List)parameters));
                return positionedOnly;
            }

            private void processArgument(@NotNull ValueArgument argument2, @Nullable ValueParameterDescriptor parameter) {
                if (parameter != null) {
                    usedParameters.add(parameter);
                    this.putVararg(parameter, argument2);
                } else {
                    this.report(Errors.TOO_MANY_ARGUMENTS.on((PsiElement)argument2.asElement(), (CallableDescriptor)candidateCall.getCandidateDescriptor()));
                    this.setStatus(Status.WEAK_ERROR);
                }
            }
        };
        private final ProcessorState positionedThenNamed = new ProcessorState(){

            @Override
            public ProcessorState processNamedArgument(@NotNull ValueArgument argument2) {
                assert (argument2.isNamed());
                Object candidate = candidateCall.getCandidateDescriptor();
                ValueArgumentName argumentName2 = argument2.getArgumentName();
                assert (argumentName2 != null);
                ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)parameterByName.get(argumentName2.getAsName());
                KtSimpleNameExpression nameReference = argumentName2.getReferenceExpression();
                KtPsiUtilKt.checkReservedYield(nameReference, candidateCall.getTrace());
                if (nameReference != null) {
                    if (candidate instanceof MemberDescriptor && ((MemberDescriptor)candidate).isExpect() && candidate.getContainingDeclaration() instanceof ClassDescriptor) {
                        this.report(Errors.NAMED_ARGUMENTS_NOT_ALLOWED.on((PsiElement)nameReference, Errors.BadNamedArgumentsTarget.EXPECTED_CLASS_MEMBER));
                    } else if (!candidate.hasStableParameterNames()) {
                        this.report(Errors.NAMED_ARGUMENTS_NOT_ALLOWED.on((PsiElement)nameReference, candidate instanceof FunctionInvokeDescriptor ? Errors.BadNamedArgumentsTarget.INVOKE_ON_FUNCTION_TYPE : Errors.BadNamedArgumentsTarget.NON_KOTLIN_FUNCTION));
                    }
                }
                if (candidate.hasStableParameterNames() && nameReference != null && candidate instanceof CallableMemberDescriptor && ((CallableMemberDescriptor)candidate).getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE) {
                    if (valueParameterDescriptor == null) {
                        valueParameterDescriptor = this.getParameterByNameInOverriddenMethods(argumentName2.getAsName());
                    }
                    if (valueParameterDescriptor != null) {
                        for (ValueParameterDescriptor parameterFromSuperclass : valueParameterDescriptor.getOverriddenDescriptors()) {
                            if (!OverrideResolver.Companion.shouldReportParameterNameOverrideWarning(valueParameterDescriptor, parameterFromSuperclass)) continue;
                            this.report(Errors.NAME_FOR_AMBIGUOUS_PARAMETER.on(nameReference));
                        }
                    }
                }
                if (valueParameterDescriptor == null) {
                    if (nameReference != null) {
                        this.report(Errors.NAMED_PARAMETER_NOT_FOUND.on(nameReference, nameReference));
                    }
                    this.setStatus(Status.WEAK_ERROR);
                } else {
                    if (nameReference != null) {
                        candidateCall.getTrace().record(BindingContext.REFERENCE_TARGET, nameReference, valueParameterDescriptor);
                    }
                    if (!usedParameters.add(valueParameterDescriptor)) {
                        if (nameReference != null) {
                            this.report(Errors.ARGUMENT_PASSED_TWICE.on(nameReference));
                        }
                        this.setStatus(Status.WEAK_ERROR);
                    } else {
                        this.putVararg(valueParameterDescriptor, argument2);
                    }
                }
                return positionedThenNamed;
            }

            @Override
            public ProcessorState processPositionedArgument(@NotNull ValueArgument argument2) {
                this.report(Errors.MIXING_NAMED_AND_POSITIONED_ARGUMENTS.on((PsiElement)argument2.asElement()));
                this.setStatus(Status.WEAK_ERROR);
                return positionedThenNamed;
            }

            @Override
            public ProcessorState processArraySetRHS(@NotNull ValueArgument argument2) {
                throw new IllegalStateException("Array set RHS cannot appear after a named argument syntactically: " + argument2);
            }
        };

        private Processor(@NotNull Call call2, @NotNull MutableResolvedCall<D> candidateCall, @NotNull TracingStrategy tracing) {
            this.call = call2;
            this.tracing = tracing;
            this.candidateCall = candidateCall;
            this.parameters = candidateCall.getCandidateDescriptor().getValueParameters();
            this.parameterByName = Maps.newHashMap();
            for (ValueParameterDescriptor valueParameter : this.parameters) {
                this.parameterByName.put(valueParameter.getName(), valueParameter);
            }
        }

        @Nullable
        private ValueParameterDescriptor getParameterByNameInOverriddenMethods(Name name2) {
            if (this.parameterByNameInOverriddenMethods == null) {
                this.parameterByNameInOverriddenMethods = Maps.newHashMap();
                for (ValueParameterDescriptor valueParameter : this.parameters) {
                    for (ValueParameterDescriptor parameterDescriptor : valueParameter.getOverriddenDescriptors()) {
                        this.parameterByNameInOverriddenMethods.put(parameterDescriptor.getName(), valueParameter);
                    }
                }
            }
            return this.parameterByNameInOverriddenMethods.get(name2);
        }

        public void process() {
            ProcessorState state = this.positionedOnly;
            boolean isArraySetMethod = this.call.getCallType() == Call.CallType.ARRAY_SET_METHOD;
            List<ValueArgument> argumentsInParentheses = CallUtilKt.getValueArgumentsInParentheses(this.call);
            Iterator<ValueArgument> iterator2 = argumentsInParentheses.iterator();
            while (iterator2.hasNext()) {
                ValueArgument valueArgument = iterator2.next();
                if (valueArgument.isNamed()) {
                    state = state.processNamedArgument(valueArgument);
                    continue;
                }
                if (isArraySetMethod && !iterator2.hasNext()) {
                    state = state.processArraySetRHS(valueArgument);
                    continue;
                }
                state = state.processPositionedArgument(valueArgument);
            }
            for (Map.Entry<ValueParameterDescriptor, VarargValueArgument> entry : this.varargs.entrySet()) {
                this.candidateCall.recordValueArgument(entry.getKey(), entry.getValue());
            }
            this.processFunctionLiteralArguments();
            this.reportUnmappedParameters();
        }

        private void processFunctionLiteralArguments() {
            List<? extends LambdaArgument> functionLiteralArguments = this.call.getFunctionLiteralArguments();
            if (functionLiteralArguments.isEmpty()) {
                return;
            }
            LambdaArgument lambdaArgument = functionLiteralArguments.get(0);
            KtExpression possiblyLabeledFunctionLiteral = lambdaArgument.getArgumentExpression();
            if (this.parameters.isEmpty()) {
                this.report(Errors.TOO_MANY_ARGUMENTS.on((PsiElement)possiblyLabeledFunctionLiteral, (CallableDescriptor)this.candidateCall.getCandidateDescriptor()));
                this.setStatus(Status.ERROR);
            } else {
                ValueParameterDescriptor lastParameter = (ValueParameterDescriptor)CollectionsKt.last(this.parameters);
                if (lastParameter.getVarargElementType() != null) {
                    this.report(Errors.VARARG_OUTSIDE_PARENTHESES.on(possiblyLabeledFunctionLiteral));
                    this.setStatus(Status.ERROR);
                } else if (!this.usedParameters.add(lastParameter)) {
                    this.report(Errors.TOO_MANY_ARGUMENTS.on((PsiElement)possiblyLabeledFunctionLiteral, (CallableDescriptor)this.candidateCall.getCandidateDescriptor()));
                    this.setStatus(Status.WEAK_ERROR);
                } else {
                    this.putVararg(lastParameter, lambdaArgument);
                }
            }
            for (int i = 1; i < functionLiteralArguments.size(); ++i) {
                KtExpression argument2 = functionLiteralArguments.get(i).getArgumentExpression();
                this.report(Errors.MANY_LAMBDA_EXPRESSION_ARGUMENTS.on(argument2));
                this.setStatus(Status.WEAK_ERROR);
            }
        }

        private void reportUnmappedParameters() {
            for (ValueParameterDescriptor valueParameter : this.parameters) {
                if (this.usedParameters.contains(valueParameter)) continue;
                if (DescriptorUtilsKt.hasDefaultValue(valueParameter)) {
                    this.candidateCall.recordValueArgument(valueParameter, DefaultValueArgument.DEFAULT);
                    continue;
                }
                if (valueParameter.getVarargElementType() != null) {
                    this.candidateCall.recordValueArgument(valueParameter, new VarargValueArgument());
                    continue;
                }
                this.tracing.noValueForParameter(this.candidateCall.getTrace(), valueParameter);
                this.setStatus(Status.ERROR);
            }
        }

        private void putVararg(ValueParameterDescriptor valueParameterDescriptor, ValueArgument valueArgument) {
            if (valueParameterDescriptor.getVarargElementType() != null) {
                VarargValueArgument vararg = this.varargs.computeIfAbsent(valueParameterDescriptor, k -> new VarargValueArgument());
                vararg.addArgument(valueArgument);
            } else {
                LeafPsiElement spread = valueArgument.getSpreadElement();
                if (spread != null) {
                    this.candidateCall.getTrace().report(Errors.NON_VARARG_SPREAD.on(spread));
                    this.setStatus(Status.WEAK_ERROR);
                }
                ExpressionValueArgument argument2 = new ExpressionValueArgument(valueArgument);
                this.candidateCall.recordValueArgument(valueParameterDescriptor, argument2);
            }
        }

        private void setStatus(@NotNull Status newStatus) {
            this.status = this.status.compose(newStatus);
        }

        private void report(Diagnostic diagnostic) {
            this.candidateCall.getTrace().report(diagnostic);
        }

        private static interface ProcessorState {
            public ProcessorState processNamedArgument(@NotNull ValueArgument var1);

            public ProcessorState processPositionedArgument(@NotNull ValueArgument var1);

            public ProcessorState processArraySetRHS(@NotNull ValueArgument var1);
        }
    }

    public static enum Status {
        ERROR(false),
        WEAK_ERROR(false),
        OK(true);

        private final boolean success;

        private Status(boolean success2) {
            this.success = success2;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public Status compose(Status other) {
            if (this == ERROR || other == ERROR) {
                return ERROR;
            }
            if (this == WEAK_ERROR || other == WEAK_ERROR) {
                return WEAK_ERROR;
            }
            return this;
        }
    }
}

