/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.osgi.model;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanEffectiveTypeProvider;
import com.intellij.spring.model.xml.beans.SpringValue;
import com.intellij.spring.osgi.model.xml.BaseOsgiReference;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ReferenceEffectiveTypeProvider
extends SpringBeanEffectiveTypeProvider {
    @NonNls
    private final String[] UnboxingReferencesClassNames = new String[]{"org.osgi.framework.ServiceReference"};

    public void processEffectiveTypes(@NotNull CommonSpringBean bean, Collection<PsiType> result) {
        if (bean == null) {
            ReferenceEffectiveTypeProvider.$$$reportNull$$$0(0);
        }
        if (!(bean instanceof BaseOsgiReference)) {
            return;
        }
        result.clear();
        Project project = bean.getPsiManager().getProject();
        BaseOsgiReference reference = (BaseOsgiReference)bean;
        PsiClass psiClass = (PsiClass)reference.getInterface().getValue();
        if (psiClass != null) {
            result.add((PsiType)PsiTypesUtil.getClassType((PsiClass)psiClass));
        }
        for (SpringValue value : reference.getInterfaces().getValues()) {
            ReferenceEffectiveTypeProvider.addClass(result, project, value.getStringValue());
        }
        for (String className : this.UnboxingReferencesClassNames) {
            ReferenceEffectiveTypeProvider.addClass(result, project, className);
        }
    }

    private static void addClass(Collection<PsiType> classes, Project project, String className) {
        PsiClass aClass;
        if (!StringUtil.isEmptyOrSpaces((String)className) && (aClass = JavaPsiFacade.getInstance((Project)project).findClass(className, GlobalSearchScope.allScope((Project)project))) != null) {
            classes.add((PsiType)PsiTypesUtil.getClassType((PsiClass)aClass));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bean", "com/intellij/spring/osgi/model/ReferenceEffectiveTypeProvider", "processEffectiveTypes"));
    }
}

