/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.tslint.config;

import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.linter.JSLinterConfigFileUtil;
import com.intellij.lang.javascript.linter.JSLinterConfiguration;
import com.intellij.lang.javascript.linter.JSLinterDescriptor;
import com.intellij.lang.javascript.linter.JSLinterGuesser;
import com.intellij.lang.javascript.linter.JSLinterUtil;
import com.intellij.lang.javascript.linter.tslint.config.TsLintConfigWrapperCache;
import com.intellij.lang.javascript.linter.tslint.config.TsLintConfiguration;
import com.intellij.lang.javascript.linter.tslint.config.style.rules.TsLintConfigWrapper;
import com.intellij.lang.javascript.linter.tslint.config.style.rules.TsLintSimpleRule;
import com.intellij.lang.javascript.linter.tslint.ide.TsLintConfigFileType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public final class TsLintDescriptor
extends JSLinterDescriptor {
    public static final String PACKAGE_NAME = "tslint";

    @NotNull
    public String getDisplayName() {
        String string = JSBundle.message((String)"settings.javascript.linters.tslint.configurable.name", (Object[])new Object[0]);
        if (string == null) {
            TsLintDescriptor.$$$reportNull$$$0(0);
        }
        return string;
    }

    public String packageName() {
        return PACKAGE_NAME;
    }

    public boolean hasConfigFiles(@NotNull Project project) {
        if (project == null) {
            TsLintDescriptor.$$$reportNull$$$0(1);
        }
        return JSLinterConfigFileUtil.projectHasConfigFiles((Project)project, (FileType)TsLintConfigFileType.INSTANCE);
    }

    public boolean usesLanguageService() {
        return true;
    }

    public boolean enable(@NotNull Project project) {
        PackageJsonData packageJson;
        if (project == null) {
            TsLintDescriptor.$$$reportNull$$$0(2);
        }
        if ((packageJson = PackageJsonUtil.getTopLevelPackageJsonData((Project)project)) != null && packageJson.getAllDependencies().contains("tslint-language-service")) {
            return false;
        }
        return super.enable(project);
    }

    public void postEnable(@NotNull Project project, @NotNull JSLinterGuesser.EnableCase enableCase) {
        if (project == null) {
            TsLintDescriptor.$$$reportNull$$$0(3);
        }
        if (enableCase == null) {
            TsLintDescriptor.$$$reportNull$$$0(4);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        VirtualFile config = JSLinterConfigFileUtil.findDistinctConfigInContentRoots((Project)project, Collections.singleton("tslint.json"));
        if (config == null) {
            return;
        }
        PsiFile file = PsiManager.getInstance((Project)project).findFile(config);
        TsLintConfigWrapperCache service = TsLintConfigWrapperCache.Companion.getService(project);
        TsLintConfigWrapper wrapper = service.getWrapper(file);
        if (wrapper == null) {
            return;
        }
        Collection<TsLintSimpleRule<?>> rules = wrapper.getRulesToApply(project);
        if (rules.isEmpty()) {
            return;
        }
        Map<TsLintSimpleRule<?>, Object> oldValues = wrapper.getCurrentSettings(project, rules);
        wrapper.applyRules(project, rules);
        Set appliedRules = rules.stream().map(el -> el.getOptionId()).collect(Collectors.toSet());
        String message = JSBundle.message((String)"settings.javascript.linters.tslint.configurable.name", (Object[])new Object[0]);
        JSLinterUtil.reportCodeStyleSettingsImported((Project)project, (String)message, (VirtualFile)config, appliedRules, () -> {
            if (project == null) {
                TsLintDescriptor.$$$reportNull$$$0(6);
            }
            wrapper.applyValues(project, oldValues);
        });
    }

    @NotNull
    public Class<? extends JSLinterConfiguration> getConfigurationClass() {
        if (TsLintConfiguration.class == null) {
            TsLintDescriptor.$$$reportNull$$$0(5);
        }
        return TsLintConfiguration.class;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/tslint/config/TsLintDescriptor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enableCase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/tslint/config/TsLintDescriptor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationClass";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "hasConfigFiles";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "enable";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "postEnable";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "lambda$postEnable$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

