/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.tslint.execution;

import com.intellij.lang.javascript.linter.tslint.config.TsLintState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SystemProperties;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TsLintConfigFileSearcher {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.javascript.linter.tslint.TsLint");

    public VirtualFile getConfig(@NotNull TsLintState state, @NotNull VirtualFile virtualFile) {
        if (state == null) {
            TsLintConfigFileSearcher.$$$reportNull$$$0(0);
        }
        if (virtualFile == null) {
            TsLintConfigFileSearcher.$$$reportNull$$$0(1);
        }
        if (state.isCustomConfigFileUsed()) {
            String configFilePath = state.getCustomConfigFilePath();
            if (StringUtil.isEmptyOrSpaces((String)configFilePath)) {
                return null;
            }
            File configFile = new File(configFilePath);
            return VfsUtil.findFileByIoFile((File)configFile, (boolean)false);
        }
        return TsLintConfigFileSearcher.lookupParentConfig(virtualFile);
    }

    @Nullable
    private static VirtualFile lookupParentConfig(@NotNull VirtualFile vf) {
        VirtualFile virtualFile;
        if (vf == null) {
            TsLintConfigFileSearcher.$$$reportNull$$$0(2);
        }
        for (VirtualFile current = vf.getParent(); current != null; current = current.getParent()) {
            VirtualFile child = current.findChild("tslint.json");
            if (child == null || !child.isValid() || child.isDirectory()) continue;
            return child;
        }
        File file = new File(SystemProperties.getUserHome());
        if (file.exists() && (virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file)) == null) {
            LOG.debug("Could not find virtual file for config file, though config file exists: " + file.getAbsolutePath());
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vf";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/linter/tslint/execution/TsLintConfigFileSearcher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getConfig";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "lookupParentConfig";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

