/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ee.websocket.highlighting;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.ee.websocket.highlighting.WebSocketBaseInspection;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.containers.hash.HashSet;
import com.intellij.websocket.jam.WebSocketEndpoint;
import com.intellij.websocket.resources.WebSocketInspectionBundle;
import com.intellij.websocket.utils.WebSocketCommonUtils;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class IncorrectOnMessageMethodsInspection
extends WebSocketBaseInspection {
    @Override
    protected void checkClass(PsiClass aClass, ProblemsHolder holder, @NotNull Module module) {
        WebSocketEndpoint endpoint;
        if (module == null) {
            IncorrectOnMessageMethodsInspection.$$$reportNull$$$0(0);
        }
        if ((endpoint = WebSocketCommonUtils.getWebsocketEndpoint(aClass)) == null && !InheritanceUtil.isInheritor((PsiClass)aClass, (String)"javax.websocket.Endpoint")) {
            return;
        }
        for (PsiMethod method : aClass.getMethods()) {
            PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)method, Collections.singleton("javax.websocket.OnMessage"));
            if (annotation == null) continue;
            IncorrectOnMessageMethodsInspection.checkParameters(method, holder, endpoint != null ? endpoint.getDecoders() : Collections.emptySet());
            IncorrectOnMessageMethodsInspection.checkReturnType(method, holder, endpoint != null ? endpoint.getEncoders() : Collections.emptySet());
        }
    }

    private static void checkParameters(@NotNull PsiMethod method, ProblemsHolder holder, Set<PsiClass> decoders) {
        PsiIdentifier identifier;
        PsiParameter[] parameters;
        if (method == null) {
            IncorrectOnMessageMethodsInspection.$$$reportNull$$$0(1);
        }
        if ((parameters = method.getParameterList().getParameters()).length == 0 && (identifier = method.getNameIdentifier()) != null) {
            holder.registerProblem((PsiElement)identifier, WebSocketInspectionBundle.message("IncorrectOnMessageMethodsInspection.incorrect.on.message.no.parameter", new Object[0]), new LocalQuickFix[0]);
        }
        HashSet textMessageParameters = new HashSet();
        HashSet binaryMessageParameters = new HashSet();
        HashSet pongMessageParameters = new HashSet();
        HashSet sessionMessageParameters = new HashSet();
        HashSet unknownTypeParameters = new HashSet();
        for (PsiParameter parameter : parameters) {
            if (AnnotationUtil.isAnnotated((PsiModifierListOwner)parameter, (String)"javax.websocket.server.PathParam", (boolean)true)) {
                IncorrectOnMessageMethodsInspection.checkPathParamParameter(parameter, holder);
                continue;
            }
            PsiType type = parameter.getType();
            if (WebSocketCommonUtils.isTextMessageParameterType(type, parameter.getProject(), decoders)) {
                textMessageParameters.add(parameter);
                continue;
            }
            if (WebSocketCommonUtils.isBinaryMessageParameterType(type, parameter.getProject(), decoders)) {
                binaryMessageParameters.add(parameter);
                continue;
            }
            if (WebSocketCommonUtils.isPongMessageParameterType(type)) {
                pongMessageParameters.add(parameter);
                continue;
            }
            if (InheritanceUtil.isInheritor((PsiType)type, (String)"javax.websocket.Session")) {
                sessionMessageParameters.add(parameter);
                continue;
            }
            unknownTypeParameters.add(parameter);
        }
        IncorrectOnMessageMethodsInspection.checkMultipleParameters(holder, (Set<PsiParameter>)textMessageParameters, "text");
        IncorrectOnMessageMethodsInspection.checkMultipleParameters(holder, (Set<PsiParameter>)binaryMessageParameters, "binary");
        IncorrectOnMessageMethodsInspection.checkMultipleParameters(holder, (Set<PsiParameter>)pongMessageParameters, "pong");
        IncorrectOnMessageMethodsInspection.checkMultipleParameters(holder, (Set<PsiParameter>)sessionMessageParameters, "Session");
        for (PsiParameter unknownTypeParameter : unknownTypeParameters) {
            PsiTypeElement typeElement = unknownTypeParameter.getTypeElement();
            if (typeElement == null) continue;
            holder.registerProblem((PsiElement)typeElement, WebSocketInspectionBundle.message("IncorrectOnMessageMethodsInspection.incorrect.on.message.parameter.type", new Object[0]), new LocalQuickFix[0]);
        }
    }

    private static void checkMultipleParameters(@NotNull ProblemsHolder holder, @NotNull Set<PsiParameter> textMessageParameters, @NotNull String type) {
        if (holder == null) {
            IncorrectOnMessageMethodsInspection.$$$reportNull$$$0(2);
        }
        if (textMessageParameters == null) {
            IncorrectOnMessageMethodsInspection.$$$reportNull$$$0(3);
        }
        if (type == null) {
            IncorrectOnMessageMethodsInspection.$$$reportNull$$$0(4);
        }
        if (textMessageParameters.size() > 1) {
            for (PsiParameter parameter : textMessageParameters) {
                PsiTypeElement typeElement = parameter.getTypeElement();
                if (typeElement == null) continue;
                holder.registerProblem((PsiElement)typeElement, WebSocketInspectionBundle.message("IncorrectOnMessageMethodsInspection.incorrect.on.message.multiple.parameter.type", type), new LocalQuickFix[0]);
            }
        }
    }

    private static void checkPathParamParameter(PsiParameter parameter, ProblemsHolder holder) {
        PsiType type = parameter.getType();
        if (type instanceof PsiPrimitiveType || PsiPrimitiveType.getUnboxedType((PsiType)type) != null) {
            return;
        }
        if ("java.lang.String".equals(type.getCanonicalText())) {
            return;
        }
        holder.registerProblem((PsiElement)parameter, WebSocketInspectionBundle.message("IncorrectOnMessageMethodsInspection.incorrect.on.message.path.parameter.type", new Object[0]), new LocalQuickFix[0]);
    }

    private static void checkReturnType(@NotNull PsiMethod method, ProblemsHolder holder, Set<PsiClass> encoders) {
        PsiType type;
        if (method == null) {
            IncorrectOnMessageMethodsInspection.$$$reportNull$$$0(5);
        }
        if ((type = method.getReturnType()) == null) {
            return;
        }
        if (type instanceof PsiPrimitiveType || PsiPrimitiveType.getUnboxedType((PsiType)type) != null) {
            return;
        }
        if ("java.lang.String".equals(type.getCanonicalText())) {
            return;
        }
        if (InheritanceUtil.isInheritor((PsiType)type, (String)"java.nio.ByteBuffer")) {
            return;
        }
        if (type instanceof PsiArrayType && ((PsiArrayType)type).getComponentType().equals(PsiType.BYTE)) {
            return;
        }
        if (WebSocketCommonUtils.hasEncoderForType(type, encoders, method.getProject())) {
            return;
        }
        PsiTypeElement typeElement = method.getReturnTypeElement();
        if (typeElement != null) {
            holder.registerProblem((PsiElement)typeElement, WebSocketInspectionBundle.message("IncorrectOnMessageMethodsInspection.incorrect.on.message.return.type", new Object[0]), new LocalQuickFix[0]);
        }
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = WebSocketInspectionBundle.message("inspection.name.incorrect.on.message.methods.errors", new Object[0]);
        if (string == null) {
            IncorrectOnMessageMethodsInspection.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("IncorrectOnMessageMethodsInspection" == null) {
            IncorrectOnMessageMethodsInspection.$$$reportNull$$$0(7);
        }
        return "IncorrectOnMessageMethodsInspection";
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            IncorrectOnMessageMethodsInspection.$$$reportNull$$$0(8);
        }
        return highlightDisplayLevel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textMessageParameters";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ee/websocket/highlighting/IncorrectOnMessageMethodsInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ee/websocket/highlighting/IncorrectOnMessageMethodsInspection";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkClass";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "checkParameters";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkMultipleParameters";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkReturnType";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

