/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.websocket.view;

import com.intellij.codeInsight.documentation.DocumentationComponent;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.ui.FinderRecursivePanel;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.websocket.WebSocketProjectComponent;
import com.intellij.websocket.jam.WebSocketEndpoint;
import com.intellij.websocket.jam.WebSocketJamModel;
import com.intellij.websocket.view.WebSocketViewFrameworkProvider;
import com.intellij.websocket.view.WebSocketViewSettings;
import com.intellij.websocket.view.actions.CheckWebsocketTypeAction;
import com.intellij.websocket.view.actions.ShowResourcesAction;
import icons.WebSocketIcons;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebsocketFinderRecursivePanel
extends FinderRecursivePanel<WebSocketEndpoint> {
    private final Module myModule;
    private final DefaultActionGroup myActions;
    private ShowResourcesAction myShowResourcesAction;
    private CheckWebsocketTypeAction.Server myShowServerAction;
    private CheckWebsocketTypeAction.Client myShowClientAction;

    public WebsocketFinderRecursivePanel(@NotNull FinderRecursivePanel parent, @Nullable Module module, DefaultActionGroup actions) {
        if (parent == null) {
            WebsocketFinderRecursivePanel.$$$reportNull$$$0(0);
        }
        super(parent);
        this.myModule = module;
        this.myActions = actions;
        this.initAdditionalActions(actions);
    }

    private void initAdditionalActions(DefaultActionGroup actions) {
        this.myShowResourcesAction = new ShowResourcesAction(this);
        this.myShowServerAction = new CheckWebsocketTypeAction.Server(this);
        this.myShowClientAction = new CheckWebsocketTypeAction.Client(this);
        actions.add((AnAction)this.myShowResourcesAction);
        actions.add((AnAction)this.myShowServerAction);
        actions.add((AnAction)this.myShowClientAction);
    }

    @Nullable
    protected JComponent createRightComponent(WebSocketEndpoint endpoint) {
        PsiElement element;
        if (this.hasChildren(endpoint)) {
            // empty if block
        }
        if ((element = WebsocketFinderRecursivePanel.getPsiElement(endpoint)) != null) {
            DocumentationManager manager = DocumentationManager.getInstance((Project)this.getProject());
            DocumentationComponent component = new DocumentationComponent(manager);
            manager.fetchDocInfo(element, component);
            Disposer.register((Disposable)this, (Disposable)component);
            return component;
        }
        return super.createRightComponent((Object)endpoint);
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        WebSocketEndpoint jamElement = (WebSocketEndpoint)this.getSelectedValue();
        PsiElement element = WebsocketFinderRecursivePanel.getPsiElement(jamElement);
        if (CommonDataKeys.NAVIGATABLE.is(dataId) && element != null) {
            return element;
        }
        return super.getData(dataId);
    }

    @Nullable
    private static PsiElement getPsiElement(WebSocketEndpoint jamElement) {
        if (jamElement == null) {
            return null;
        }
        return jamElement.getPsiElement();
    }

    @NotNull
    protected String getItemText(WebSocketEndpoint endpoint) {
        String string = endpoint.getPath();
        if (string == null) {
            WebsocketFinderRecursivePanel.$$$reportNull$$$0(1);
        }
        return string;
    }

    protected void doCustomizeCellRenderer(SimpleColoredComponent comp, JList list, WebSocketEndpoint value, int index, boolean selected, boolean hasFocus) {
        comp.clear();
        comp.setIcon(this.getItemIcon(value));
        String endpointValue = value.getPath();
        String className = StringUtil.getShortName((String)value.getPsiElement().getQualifiedName());
        String annoName = StringUtil.getShortName((String)value.getJamAnnotationMeta().getAnnoName());
        if (this.isShowResourcesView()) {
            if (!StringUtil.isEmptyOrSpaces((String)endpointValue)) {
                comp.append("\"" + endpointValue + "\"");
                comp.append(" (" + className + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
            } else {
                comp.append(className);
            }
            comp.append(" @" + annoName + " ", SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
        } else {
            comp.append(className);
            if (!StringUtil.isEmptyOrSpaces((String)endpointValue)) {
                comp.append(" (\"" + endpointValue + "\")", SimpleTextAttributes.GRAY_ATTRIBUTES);
            }
            comp.append(" @" + annoName + " ", SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
        }
    }

    @Nullable
    protected Icon getItemIcon(WebSocketEndpoint path) {
        return WebSocketIcons.WebSocketFramework;
    }

    public void dispose() {
        super.dispose();
        this.myActions.remove((AnAction)this.myShowClientAction);
        this.myActions.remove((AnAction)this.myShowResourcesAction);
        this.myActions.remove((AnAction)this.myShowServerAction);
    }

    @NotNull
    protected List<WebSocketEndpoint> getListItems() {
        WebSocketJamModel model = WebSocketJamModel.getModel(this.getProject());
        List<WebSocketEndpoint> allEndpoints = this.myModule != null ? model.getEndpoints(this.myModule) : model.getEndpoints(this.getProject());
        List<WebSocketEndpoint> filteredEndpoints = WebSocketViewFrameworkProvider.getFilteredEndpoints(allEndpoints, this.getProject());
        Collections.sort(filteredEndpoints, (o1, o2) -> {
            String value1 = o1.getPath();
            String value2 = o2.getPath();
            return value1.compareTo(value2);
        });
        List<WebSocketEndpoint> list = filteredEndpoints;
        if (list == null) {
            WebsocketFinderRecursivePanel.$$$reportNull$$$0(2);
        }
        return list;
    }

    protected boolean hasChildren(WebSocketEndpoint endpoint) {
        return false;
    }

    public Module getModule() {
        return this.myModule;
    }

    public boolean isShowResourcesView() {
        WebSocketViewSettings viewSettings = WebSocketProjectComponent.getInstance(this.getProject()).getState();
        return viewSettings == null || viewSettings.showResources;
    }

    public boolean isShowServerEndpoints() {
        WebSocketViewSettings viewSettings = WebSocketProjectComponent.getInstance(this.getProject()).getState();
        return viewSettings == null || viewSettings.server;
    }

    public boolean isShowClientEndpoints() {
        WebSocketViewSettings viewSettings = WebSocketProjectComponent.getInstance(this.getProject()).getState();
        return viewSettings == null || viewSettings.client;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/websocket/view/WebsocketFinderRecursivePanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/websocket/view/WebsocketFinderRecursivePanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getItemText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getListItems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

