/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.impl;

import com.intellij.database.remote.jdbc.impl.JdbcRemoteObject;
import com.intellij.database.remote.jdbc.impl.ReflectionHelper;
import com.intellij.openapi.util.Getter;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.text.VersionComparatorUtil;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;
import java.util.TimeZone;
import org.jetbrains.annotations.NotNull;

public class OracleHelper {
    public static final String TIMESTAMPTZ_CLASS_NAME = "oracle.sql.TIMESTAMPTZ";
    private static final int MIN_OFFSET_INDEX = "0000-00-00".length() - 1;
    private static boolean ourIsInitialized;
    private static boolean ourIsLtzTimestampInGmt;
    private static boolean ourIsTimestampInGmt;
    private static TimeZone ourSessionTimeZone;

    public static void init(Getter<Connection> connectionGetter) {
        String driverVersion;
        if (ourIsInitialized) {
            return;
        }
        try {
            DatabaseMetaData metaData = ((Connection)connectionGetter.get()).getMetaData();
            driverVersion = metaData.getDriverVersion();
        }
        catch (SQLException e) {
            driverVersion = "";
        }
        if (VersionComparatorUtil.compare((String)driverVersion, (String)"11.1.0.7") < 0) {
            ourIsTimestampInGmt = false;
        } else {
            Object p = ReflectionHelper.tryInvokeMethod(connectionGetter.get(), "getProperties", null, null);
            if (p instanceof Properties) {
                String timestampTzInGmtPropStr = ((Properties)p).getProperty("oracle.jdbc.timestampTzInGmt", "true");
                ourIsTimestampInGmt = timestampTzInGmtPropStr.equalsIgnoreCase("true");
            } else {
                ourIsTimestampInGmt = true;
            }
            ourIsLtzTimestampInGmt = VersionComparatorUtil.compare((String)driverVersion, (String)"11.2.0.2") >= 0;
        }
        Object value = ReflectionHelper.tryInvokeMethod(connectionGetter.get(), "getSessionTimeZone", null, null);
        ourSessionTimeZone = value instanceof String ? TimeZone.getTimeZone((String)value) : null;
        ourIsInitialized = true;
    }

    public static boolean isLtzTimestampInGmt(Getter<Connection> connection) {
        OracleHelper.init(connection);
        return ourIsLtzTimestampInGmt;
    }

    public static boolean isTimestampInGmt(Getter<Connection> connection) {
        OracleHelper.init(connection);
        return ourIsTimestampInGmt;
    }

    public static Object convertValue(JdbcRemoteObject remoteObject, String className, Object o, Getter<Connection> connectionGetter) throws RemoteException, SQLException {
        Object opaqueTypeName;
        Object value;
        if (className.startsWith("oracle.xdb.XMLType") && (value = OracleHelper.tryMethodWithConnection(o, "getString", null)) != null) {
            return value;
        }
        if (className.equals(TIMESTAMPTZ_CLASS_NAME)) {
            value = OracleHelper.tryMethodWithConnection(o, "timestampValue", connectionGetter);
            if (value instanceof Timestamp) {
                Calendar calendar;
                TimeZone timeZone = OracleHelper.extractTimeZone(o);
                if (OracleHelper.isTimestampInGmt(connectionGetter)) {
                    calendar = Calendar.getInstance(timeZone);
                    calendar.setTime((Date)value);
                } else {
                    calendar = Calendar.getInstance();
                    calendar.setTime((Date)value);
                    if (timeZone != null) {
                        calendar.getTimeZone().setID(timeZone.getID());
                        calendar.getTimeZone().setRawOffset(timeZone.getRawOffset());
                    }
                }
                value = new Timestamp(calendar.getTimeInMillis());
            }
        } else if (className.equals("oracle.sql.TIMESTAMPLTZ")) {
            value = ReflectionHelper.tryInvokeMethod(null, o.getClass(), "toTimestamp", new Class[]{Connection.class, byte[].class}, new Object[]{connectionGetter.get(), ReflectionHelper.tryInvokeMethod(o, "toBytes", null, null)});
            if (value instanceof Timestamp) {
                Calendar calendar = ourSessionTimeZone != null ? Calendar.getInstance(ourSessionTimeZone) : Calendar.getInstance();
                if (OracleHelper.isLtzTimestampInGmt(connectionGetter)) {
                    calendar.setTimeInMillis(((Timestamp)value).getTime());
                } else {
                    Calendar localCalendar = Calendar.getInstance();
                    localCalendar.setTime((Date)value);
                    calendar.set(localCalendar.get(1), localCalendar.get(2), localCalendar.get(5), localCalendar.get(11), localCalendar.get(12), localCalendar.get(13));
                    calendar.set(14, ((Timestamp)value).getNanos() / 1000000);
                }
                value = new Timestamp(calendar.getTimeInMillis());
            }
        } else if (className.equals("oracle.sql.STRUCT")) {
            Object attributes = ReflectionHelper.tryInvokeMethod(o, o.getClass(), "getAttributes", new Class[0], new Object[0]);
            value = remoteObject.wrapIfNeeded(attributes, connectionGetter);
        } else {
            value = OracleHelper.tryMethodWithConnection(o, "toJdbc", null);
            if (value == null) {
                value = OracleHelper.tryMethodWithConnection(o, "stringValue", null);
            }
        }
        if (value != null) {
            return value;
        }
        Object object = opaqueTypeName = className.equals("oracle.sql.OPAQUE") ? ReflectionHelper.tryInvokeMethod(ReflectionHelper.tryInvokeMethod(o, "getDescriptor", null, null), "getName", null, null) : null;
        if (opaqueTypeName instanceof String) {
            return "<failed to load> " + className + "\n" + ("SYS.XMLTYPE".equalsIgnoreCase((String)opaqueTypeName) ? "Oracle XML DB library" : className + " support library") + " is missing in the database driver";
        }
        return null;
    }

    private static Object tryMethodWithConnection(Object o, String methodName, Getter<Connection> connectionGetter) {
        Object[] objectArray;
        Class[] classArray;
        if (connectionGetter == null) {
            classArray = ArrayUtilRt.EMPTY_CLASS_ARRAY;
        } else {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = Connection.class;
        }
        if (connectionGetter == null) {
            objectArray = ArrayUtilRt.EMPTY_OBJECT_ARRAY;
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = connectionGetter.get();
        }
        Object value = ReflectionHelper.tryInvokeMethod(o, methodName, classArray, objectArray);
        return value != null && value.getClass().getClassLoader() == null ? value : null;
    }

    public static TimeZone extractTimeZone(Object o) {
        String regionName;
        Object b = ReflectionHelper.tryInvokeMethod(o, "toBytes", null, null);
        if (!(b instanceof byte[])) {
            return null;
        }
        byte[] bytes = (byte[])b;
        if ((bytes[11] & 0xFFFFFF80) != 0) {
            int regionCode = (bytes[11] & 0x7F) << 6;
            regionName = (String)ReflectionHelper.tryInvokeMethod("oracle.sql.ZONEIDMAP", "getRegion", new Class[]{Integer.TYPE}, new Object[]{regionCode += (bytes[12] & 0xFC) >> 2});
        } else {
            int hourOffset = bytes[11] - 20;
            int minuteOffset = bytes[12] - 60;
            regionName = String.format("GMT%+03d:%02d", hourOffset, Math.abs(minuteOffset));
        }
        return TimeZone.getTimeZone(regionName);
    }

    @NotNull
    static String normalizeTimestamp(@NotNull String string, @NotNull Timestamp timestamp) {
        int zoneStart;
        if (string == null) {
            OracleHelper.$$$reportNull$$$0(0);
        }
        if (timestamp == null) {
            OracleHelper.$$$reportNull$$$0(1);
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(timestamp);
        int era = calendar.get(0);
        int plusIndex = string.lastIndexOf("+");
        int n = zoneStart = plusIndex == -1 ? string.lastIndexOf("-") : plusIndex;
        if (zoneStart == -1 || zoneStart <= MIN_OFFSET_INDEX) {
            String string2 = string + OracleHelper.getEraString(era);
            if (string2 == null) {
                OracleHelper.$$$reportNull$$$0(2);
            }
            return string2;
        }
        String withoutZone = string.substring(0, zoneStart);
        String zone = string.substring(zoneStart);
        String[] hoursMinutes = zone.split(":");
        if (hoursMinutes.length == 0) {
            String string3 = string + OracleHelper.getEraString(era);
            if (string3 == null) {
                OracleHelper.$$$reportNull$$$0(3);
            }
            return string3;
        }
        String minutes = hoursMinutes.length == 2 ? hoursMinutes[1] : null;
        String sign = hoursMinutes[0].length() > 1 ? hoursMinutes[0].substring(0, 1) : "+";
        String hours = hoursMinutes[0].substring(1);
        String normalizedHours = hours.length() == 1 ? "0" + hours : hours;
        String string4 = withoutZone + sign + normalizedHours + ":" + (minutes == null ? "" : minutes) + OracleHelper.getEraString(era);
        if (string4 == null) {
            OracleHelper.$$$reportNull$$$0(4);
        }
        return string4;
    }

    @NotNull
    private static String getEraString(int era) {
        String string = era == 1 ? "" : " BC";
        if (string == null) {
            OracleHelper.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timestamp";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/remote/jdbc/impl/OracleHelper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/remote/jdbc/impl/OracleHelper";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizeTimestamp";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getEraString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "normalizeTimestamp";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

