/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.yfilesGraph;

import com.intellij.jsf.model.xml.FacesConfig;
import com.intellij.jsf.model.xml.navigationRules.NavigationCase;
import com.intellij.jsf.model.xml.navigationRules.NavigationRule;
import com.intellij.jsf.yfilesGraph.FacesBuildersFactory;
import com.intellij.jsf.yfilesGraph.GraphNavigationProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataConstants;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.base.Edge;
import com.intellij.openapi.graph.base.EdgeCursor;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.graph.impl.builder.GraphBuilderImpl;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomEventListener;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.events.DomEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FacesNavigationGraphComponent
extends JPanel
implements Disposable {
    private final GraphBuilderImpl<String, NavigationCase> myBuilder;
    private final GraphNavigationProvider myNavigationProvider;

    public FacesNavigationGraphComponent(@NotNull FacesConfig facesConfig) {
        if (facesConfig == null) {
            FacesNavigationGraphComponent.$$$reportNull$$$0(0);
        }
        this.myBuilder = FacesBuildersFactory.createNavigationBuilder(facesConfig, GraphManager.getGraphManager().createGraph2D(), GraphManager.getGraphManager().createGraph2DView());
        this.addHelpDataProvider();
        this.myNavigationProvider = new GraphNavigationProvider(this.myBuilder);
        this.setLayout(new BorderLayout());
        this.add((Component)GraphViewUtil.createCommonToolbarPane((GraphBuilder)this.getBuilder()), "North");
        this.add(this.getBuilder().getView().getComponent(), "Center");
        Disposer.register((Disposable)this, this.myBuilder);
        DomManager.getDomManager((Project)this.myBuilder.getProject()).addDomEventListener(new DomEventListener(){

            public void eventOccured(DomEvent event) {
                if (FacesNavigationGraphComponent.this.isShowing()) {
                    FacesNavigationGraphComponent.this.myBuilder.queueUpdate();
                }
            }
        }, (Disposable)this);
    }

    private void addHelpDataProvider() {
        GraphViewUtil.addDataProvider((Graph2DView)this.myBuilder.getView(), (DataProvider)new DataProvider(){

            @Nullable
            public Object getData(@NonNls String dataId) {
                if (dataId.equals(DataConstants.HELP_ID)) {
                    return "jsf.navigation";
                }
                return null;
            }
        });
    }

    public GraphBuilderImpl getBuilder() {
        return this.myBuilder;
    }

    public void dispose() {
    }

    public void setSelectedDomElement(DomElement domElement) {
        this.myNavigationProvider.navigate(domElement, true);
    }

    @Nullable
    public DomElement getSelectedDomElement() {
        for (Node node : this.myBuilder.getGraph().getNodeArray()) {
            NavigationCase aCase;
            if (!this.myBuilder.getGraph().getRealizer(node).isSelected()) continue;
            EdgeCursor ec = node.outEdges();
            if (ec.ok() && (aCase = (NavigationCase)this.myBuilder.getEdgeObject(ec.edge())) != null) {
                return ((NavigationRule)aCase.getParentOfType(NavigationRule.class, true)).getFromViewId();
            }
            ec = node.inEdges();
            if (!ec.ok() || (aCase = (NavigationCase)this.myBuilder.getEdgeObject(ec.edge())) == null) continue;
            return aCase.getToViewId();
        }
        for (Node node : this.myBuilder.getGraph().getEdgeArray()) {
            if (!this.myBuilder.getGraph().getRealizer((Edge)node).isSelected()) continue;
            NavigationCase aCase = (NavigationCase)this.myBuilder.getEdgeObject((Edge)node);
            ((NavigationRule)aCase.getParentOfType(NavigationRule.class, true)).getFromViewId();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facesConfig", "com/intellij/jsf/yfilesGraph/FacesNavigationGraphComponent", "<init>"));
    }
}

