/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.osgi.bnd.run;

import aQute.bnd.build.ProjectLauncher;
import aQute.bnd.build.Run;
import aQute.bnd.build.Workspace;
import aQute.bnd.osgi.Processor;
import com.intellij.execution.CantRunException;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.util.JavaParametersUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.osgi.bnd.run.BndRunConfigurationBase;

public class BndLaunchUtil {
    @NotNull
    public static Run getRun(@NotNull File runFile) throws Exception {
        if (runFile == null) {
            BndLaunchUtil.$$$reportNull$$$0(0);
        }
        Workspace ws = Workspace.getWorkspaceWithoutException((File)runFile.getParentFile().getParentFile());
        Run run = Run.createRun((Workspace)ws, (File)runFile);
        if (run == null) {
            BndLaunchUtil.$$$reportNull$$$0(1);
        }
        return run;
    }

    @NotNull
    public static JavaParameters createJavaParameters(@NotNull BndRunConfigurationBase configuration, @NotNull ProjectLauncher launcher) throws CantRunException {
        if (configuration == null) {
            BndLaunchUtil.$$$reportNull$$$0(2);
        }
        if (launcher == null) {
            BndLaunchUtil.$$$reportNull$$$0(3);
        }
        Project project = configuration.getProject();
        JavaParameters parameters = new JavaParameters();
        File launcherDir = launcher.getCwd();
        parameters.setWorkingDirectory(launcherDir != null ? launcherDir.getPath() : project.getBasePath());
        String jreHome = configuration.useAlternativeJre ? configuration.alternativeJrePath : null;
        JavaParametersUtil.configureProject((Project)project, (JavaParameters)parameters, (int)1, (String)jreHome);
        parameters.getEnv().putAll(launcher.getRunEnv());
        parameters.getVMParametersList().addAll(BndLaunchUtil.asList(launcher.getRunVM()));
        parameters.getClassPath().addAll(BndLaunchUtil.asList(launcher.getClasspath()));
        parameters.setMainClass(launcher.getMainTypeName());
        parameters.getProgramParametersList().addAll(BndLaunchUtil.asList(launcher.getRunProgramArgs()));
        JavaParameters javaParameters = parameters;
        if (javaParameters == null) {
            BndLaunchUtil.$$$reportNull$$$0(4);
        }
        return javaParameters;
    }

    private static List<String> asList(Collection<String> c) {
        return c instanceof List ? (List)c : ContainerUtil.newArrayList(c);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static Boolean hasTestCases(@NotNull String path) {
        File file;
        if (path == null) {
            BndLaunchUtil.$$$reportNull$$$0(5);
        }
        if (!(file = new File(FileUtil.toSystemDependentName((String)path))).isFile()) return null;
        try (Processor processor = new Processor();){
            File projectFile;
            processor.setProperties(file);
            if (processor.get("-runfw") == null) return null;
            if (!"bnd.bnd".equals(file.getName()) && (projectFile = new File(file.getParent(), "bnd.bnd")).isFile()) {
                Processor project = new Processor();
                project.setProperties(projectFile);
                processor.setParent(project);
            }
            boolean hasTestCases = processor.get("Test-Cases") != null;
            Boolean bl = hasTestCases ? Boolean.TRUE : Boolean.FALSE;
            return bl;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static String message(Throwable t) {
        String message = t.getMessage();
        return StringUtil.isEmptyOrSpaces((String)message) ? t.getClass().getSimpleName() : t.getClass().getSimpleName() + ": " + message;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runFile";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/osgi/bnd/run/BndLaunchUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launcher";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/osgi/bnd/run/BndLaunchUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRun";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createJavaParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRun";
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createJavaParameters";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "hasTestCases";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

