/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc;

import aQute.bnd.build.Workspace;
import com.intellij.ProjectTopics;
import com.intellij.execution.RunManager;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.BaseComponent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.osgi.bnd.imp.BndProjectImporter;
import org.osmorc.frameworkintegration.FrameworkInstanceDefinition;
import org.osmorc.i18n.OsmorcBundle;
import org.osmorc.run.OsgiConfigurationType;
import org.osmorc.run.OsgiRunConfiguration;
import org.osmorc.run.ui.SelectedBundle;
import org.osmorc.settings.FrameworkDefinitionListener;
import org.osmorc.settings.ProjectSettings;

public class OsmorcProjectComponent
implements BaseComponent {
    public static final NotificationGroup IMPORTANT_NOTIFICATIONS = new NotificationGroup("OSGi Important Messages", NotificationDisplayType.STICKY_BALLOON, true);
    private final OsgiConfigurationType myConfigurationType;
    private final Project myProject;
    private final ProjectSettings myProjectSettings;
    private final MergingUpdateQueue myQueue;
    private final AtomicBoolean myReimportNotification;

    public OsmorcProjectComponent(@NotNull OsgiConfigurationType configurationType, @NotNull Project project, @NotNull ProjectSettings projectSettings) {
        if (configurationType == null) {
            OsmorcProjectComponent.$$$reportNull$$$0(0);
        }
        if (project == null) {
            OsmorcProjectComponent.$$$reportNull$$$0(1);
        }
        if (projectSettings == null) {
            OsmorcProjectComponent.$$$reportNull$$$0(2);
        }
        this.myReimportNotification = new AtomicBoolean(false);
        this.myConfigurationType = configurationType;
        this.myProject = project;
        this.myProjectSettings = projectSettings;
        this.myQueue = new MergingUpdateQueue(this.getComponentName(), 500, true, MergingUpdateQueue.ANY_COMPONENT, (Disposable)this.myProject);
    }

    public void initComponent() {
        MessageBusConnection connection = this.myProject.getMessageBus().connect();
        connection.subscribe(FrameworkDefinitionListener.TOPIC, (Object)new MyFrameworkDefinitionListener());
        connection.subscribe(ProjectTopics.MODULES, (Object)new MyModuleRenameHandler());
        Workspace workspace = BndProjectImporter.findWorkspace(this.myProject);
        if (workspace != null) {
            connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new MyVfsListener());
        }
    }

    private void scheduleImportNotification() {
        this.myQueue.queue(new Update("reimport"){

            public void run() {
                if (OsmorcProjectComponent.this.myProjectSettings.isBndAutoImport()) {
                    BndProjectImporter.reimportWorkspace(OsmorcProjectComponent.this.myProject);
                    return;
                }
                if (OsmorcProjectComponent.this.myReimportNotification.getAndSet(true)) {
                    return;
                }
                String title = OsmorcBundle.message("bnd.reimport.title", new Object[0]);
                String text = OsmorcBundle.message("bnd.reimport.text", new Object[0]);
                BndProjectImporter.NOTIFICATIONS.createNotification(title, text, NotificationType.INFORMATION, (NotificationListener)new NotificationListener.Adapter(){

                    protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
                        if (notification == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (e == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        notification.expire();
                        if (e.getDescription().equals("auto")) {
                            OsmorcProjectComponent.this.myProjectSettings.setBndAutoImport(true);
                        }
                        BndProjectImporter.reimportWorkspace(OsmorcProjectComponent.this.myProject);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "notification";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "e";
                                break;
                            }
                        }
                        objectArray[1] = "org/osmorc/OsmorcProjectComponent$1$1";
                        objectArray[2] = "hyperlinkActivated";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                }).whenExpired(() -> OsmorcProjectComponent.this.myReimportNotification.set(false)).notify(OsmorcProjectComponent.this.myProject);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "configurationType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "projectSettings";
                break;
            }
        }
        objectArray[1] = "org/osmorc/OsmorcProjectComponent";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class MyVfsListener
    implements BulkFileListener {
        private MyVfsListener() {
        }

        public void after(@NotNull List<? extends VFileEvent> events) {
            if (events == null) {
                MyVfsListener.$$$reportNull$$$0(0);
            }
            for (VFileEvent vFileEvent : events) {
                String name;
                VirtualFile file;
                if (!(vFileEvent instanceof VFileContentChangeEvent) || (file = vFileEvent.getFile()) == null || !"bnd.bnd".equals(name = file.getName()) && !"build.bnd".equals(name)) continue;
                OsmorcProjectComponent.this.scheduleImportNotification();
                break;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "org/osmorc/OsmorcProjectComponent$MyVfsListener", "after"));
        }
    }

    private class MyModuleRenameHandler
    implements ModuleListener {
        private MyModuleRenameHandler() {
        }

        public void modulesRenamed(@NotNull Project project, @NotNull List<Module> modules, @NotNull Function<Module, String> oldNameProvider) {
            if (project == null) {
                MyModuleRenameHandler.$$$reportNull$$$0(0);
            }
            if (modules == null) {
                MyModuleRenameHandler.$$$reportNull$$$0(1);
            }
            if (oldNameProvider == null) {
                MyModuleRenameHandler.$$$reportNull$$$0(2);
            }
            List pairs = ContainerUtil.newSmartList();
            for (Module module : modules) {
                String oldName = (String)oldNameProvider.fun((Object)module);
                block1: for (RunConfiguration runConfiguration : RunManager.getInstance((Project)OsmorcProjectComponent.this.myProject).getConfigurationsList((ConfigurationType)OsmorcProjectComponent.this.myConfigurationType)) {
                    for (SelectedBundle bundle : ((OsgiRunConfiguration)runConfiguration).getBundlesToDeploy()) {
                        if (!bundle.isModule() || !bundle.getName().equals(oldName)) continue;
                        pairs.add(Pair.create((Object)bundle, (Object)module.getName()));
                        continue block1;
                    }
                }
            }
            if (!pairs.isEmpty()) {
                ApplicationManager.getApplication().runWriteAction(() -> {
                    for (Pair pair : pairs) {
                        ((SelectedBundle)pair.first).setName((String)pair.second);
                    }
                });
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "modules";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "oldNameProvider";
                    break;
                }
            }
            objectArray[1] = "org/osmorc/OsmorcProjectComponent$MyModuleRenameHandler";
            objectArray[2] = "modulesRenamed";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyFrameworkDefinitionListener
    implements FrameworkDefinitionListener {
        private MyFrameworkDefinitionListener() {
        }

        @Override
        public void definitionsChanged(@NotNull List<Pair<FrameworkInstanceDefinition, FrameworkInstanceDefinition>> changes) {
            if (changes == null) {
                MyFrameworkDefinitionListener.$$$reportNull$$$0(0);
            }
            for (Pair<FrameworkInstanceDefinition, FrameworkInstanceDefinition> pair : changes) {
                if (pair.first == null) continue;
                for (RunConfiguration runConfiguration : RunManager.getInstance((Project)OsmorcProjectComponent.this.myProject).getConfigurationsList((ConfigurationType)OsmorcProjectComponent.this.myConfigurationType)) {
                    OsgiRunConfiguration osgiRunConfiguration = (OsgiRunConfiguration)runConfiguration;
                    if (!((FrameworkInstanceDefinition)((Object)pair.first)).equals((Object)osgiRunConfiguration.getInstanceToUse())) continue;
                    osgiRunConfiguration.setInstanceToUse((FrameworkInstanceDefinition)((Object)pair.second));
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "org/osmorc/OsmorcProjectComponent$MyFrameworkDefinitionListener", "definitionsChanged"));
        }
    }
}

