/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.impl;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleServiceManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.osmorc.facet.OsmorcFacet;
import org.osmorc.facet.OsmorcFacetConfiguration;

public class AdditionalJARContentsWatcherManager {
    private final LocalFileSystem myFileSystem;
    private final Module myModule;
    private final List<VirtualFile> myAdditionalBundleJARContents;
    private final List<LocalFileSystem.WatchRequest> myWatchRequests;

    public static AdditionalJARContentsWatcherManager getInstance(@NotNull Module module) {
        if (module == null) {
            AdditionalJARContentsWatcherManager.$$$reportNull$$$0(0);
        }
        return (AdditionalJARContentsWatcherManager)ModuleServiceManager.getService((Module)module, AdditionalJARContentsWatcherManager.class);
    }

    public AdditionalJARContentsWatcherManager(LocalFileSystem fileSystem, Module module) {
        this.myFileSystem = fileSystem;
        this.myModule = module;
        this.myAdditionalBundleJARContents = new ArrayList<VirtualFile>();
        this.myWatchRequests = new ArrayList<LocalFileSystem.WatchRequest>();
        this.updateWatcherSetup();
    }

    public void updateWatcherSetup() {
        OsmorcFacet osmorcFacet = OsmorcFacet.getInstance(this.myModule);
        if (osmorcFacet != null) {
            Object file;
            ArrayList<VirtualFile> newAdditionalJARContents = new ArrayList<VirtualFile>();
            OsmorcFacetConfiguration osmorcFacetConfiguration = (OsmorcFacetConfiguration)osmorcFacet.getConfiguration();
            List<Pair<String, String>> jarContents = osmorcFacetConfiguration.getAdditionalJARContents();
            for (Pair<String, String> jarContent : jarContents) {
                file = this.myFileSystem.findFileByPath((String)jarContent.getFirst());
                if (file == null) continue;
                newAdditionalJARContents.add((VirtualFile)file);
            }
            ArrayList<LocalFileSystem.WatchRequest> toRemove = new ArrayList<LocalFileSystem.WatchRequest>();
            Iterator<VirtualFile> jarContentsIterator = this.myAdditionalBundleJARContents.iterator();
            while (jarContentsIterator.hasNext()) {
                file = jarContentsIterator.next();
                if (newAdditionalJARContents.contains(file)) continue;
                jarContentsIterator.remove();
                Iterator<LocalFileSystem.WatchRequest> watchIterator = this.myWatchRequests.iterator();
                while (watchIterator.hasNext()) {
                    LocalFileSystem.WatchRequest watchRequest = watchIterator.next();
                    if (!Comparing.strEqual((String)file.getPath(), (String)watchRequest.getRootPath())) continue;
                    toRemove.add(watchRequest);
                    watchIterator.remove();
                }
            }
            ArrayList<String> toAdd = new ArrayList<String>();
            for (VirtualFile newAdditionalJARContent : newAdditionalJARContents) {
                if (this.myAdditionalBundleJARContents.contains(newAdditionalJARContent)) continue;
                toAdd.add(newAdditionalJARContent.getPath());
                this.myAdditionalBundleJARContents.add(newAdditionalJARContent);
            }
            Set requests = this.myFileSystem.replaceWatchedRoots(toRemove, toAdd, null);
            this.myWatchRequests.addAll(requests);
        } else {
            this.cleanup();
        }
    }

    public void cleanup() {
        this.myFileSystem.removeWatchedRoots(this.myWatchRequests);
        this.myWatchRequests.clear();
        this.myAdditionalBundleJARContents.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/osmorc/impl/AdditionalJARContentsWatcherManager", "getInstance"));
    }
}

