/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.manifest.lang.psi;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.lang.manifest.psi.Header;
import org.jetbrains.lang.manifest.psi.HeaderValuePart;
import org.jetbrains.lang.manifest.psi.ManifestFile;
import org.jetbrains.osgi.project.BundleManifest;
import org.jetbrains.osgi.project.BundleManifestCache;
import org.osmorc.i18n.OsmorcBundle;

public class BundleReference
extends PsiReferenceBase<HeaderValuePart>
implements EmptyResolveMessageProvider {
    private static final ResolveCache.AbstractResolver<BundleReference, PsiElement> RESOLVER = new ResolveCache.AbstractResolver<BundleReference, PsiElement>(){

        public PsiElement resolve(@NotNull BundleReference reference, boolean incompleteCode) {
            Module module;
            if (reference == null) {
                1.$$$reportNull$$$0(0);
            }
            String text = reference.getCanonicalText();
            HeaderValuePart refElement = (HeaderValuePart)reference.getElement();
            if (!StringUtil.isEmptyOrSpaces((String)text) && refElement.isValid() && (module = ModuleUtilCore.findModuleForPsiElement((PsiElement)refElement)) != null) {
                Ref result = Ref.create();
                String refText = text.replaceAll("\\s", "");
                BundleManifestCache cache = BundleManifestCache.getInstance(module.getProject());
                ModuleRootManager manager = ModuleRootManager.getInstance((Module)module);
                manager.orderEntries().forEachModule(module1 -> {
                    BundleManifest manifest = cache.getManifest((Module)module1);
                    if (manifest != null && refText.equals(manifest.getBundleSymbolicName())) {
                        result.set((Object)this.getTarget(manifest));
                        return false;
                    }
                    return true;
                });
                if (!result.isNull()) {
                    return (PsiElement)result.get();
                }
                manager.orderEntries().forEachLibrary(library -> {
                    for (VirtualFile libRoot : library.getFiles(OrderRootType.CLASSES)) {
                        BundleManifest manifest = cache.getManifest(libRoot);
                        if (manifest == null || !refText.equals(manifest.getBundleSymbolicName())) continue;
                        result.set((Object)this.getTarget(manifest));
                        return false;
                    }
                    return true;
                });
                if (!result.isNull()) {
                    return (PsiElement)result.get();
                }
            }
            return null;
        }

        private PsiElement getTarget(BundleManifest manifest) {
            Header header;
            PsiFile source = manifest.getSource();
            if (source instanceof ManifestFile && (header = ((ManifestFile)source).getHeader("Bundle-SymbolicName")) != null) {
                return header;
            }
            return source;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "org/osmorc/manifest/lang/psi/BundleReference$1", "resolve"));
        }
    };

    public BundleReference(@NotNull HeaderValuePart element) {
        if (element == null) {
            BundleReference.$$$reportNull$$$0(0);
        }
        super((PsiElement)element);
    }

    @Nullable
    public PsiElement resolve() {
        return (PsiElement)ResolveCache.getInstance((Project)((HeaderValuePart)this.myElement).getProject()).resolveWithCaching((PsiReference)this, RESOLVER, false, false);
    }

    @NotNull
    public Object[] getVariants() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            BundleReference.$$$reportNull$$$0(1);
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        String string = OsmorcBundle.message("cannot.resolve.bundle", this.getCanonicalText());
        if (string == null) {
            BundleReference.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/osmorc/manifest/lang/psi/BundleReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/osmorc/manifest/lang/psi/BundleReference";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedMessagePattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

