/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.obrimport;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.ui.Messages;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.net.HttpConfigurable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.osmorc.obrimport.Obr;
import org.osmorc.obrimport.ObrProvider;
import org.osmorc.obrimport.QueryType;
import org.osmorc.obrimport.springsource.ObrMavenResult;

public class ObrSearchPanel
extends ProgressIndicatorBase {
    private JTextField _queryString;
    private JList _resultList;
    private JPanel _rootPanel;
    private JProgressBar _progressBar;
    private JButton _searchButton;
    private JButton _cancelButton;
    private JLabel _statusLabel;
    private JComboBox _obrBox;
    private final QueryType _queryType;
    private final List<PropertyChangeListener> propertyChangeListeners;

    public ObrSearchPanel(QueryType queryType) {
        this.$$$setupUI$$$();
        this.propertyChangeListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this._queryType = queryType;
        this._searchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ObrSearchPanel.this.search();
            }
        });
        this._cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ObrSearchPanel.this.cancel();
            }
        });
        this._obrBox.setRenderer(new ListCellRendererWrapper<Obr>(){

            public void customize(JList list, Obr value, int index, boolean selected, boolean hasFocus) {
                this.setText(value.getDisplayName());
            }
        });
        this._resultList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ObrSearchPanel.this.firePropertyChangeEvent("hasResult", null, null);
            }
        });
        this.updateObrs();
        this.onRunningChange();
        this.onProgressChange();
    }

    private void search() {
        Thread t = new Thread(() -> {
            Obr selectedObr = (Obr)this._obrBox.getSelectedItem();
            if (selectedObr != null) {
                this.start();
                switch (this._queryType) {
                    case Maven: {
                        List<ObrMavenResult> result = null;
                        try {
                            result = Arrays.asList(selectedObr.queryForMavenArtifact(this._queryString.getText(), (ProgressIndicator)this));
                            this.setResults(result);
                            break;
                        }
                        catch (IOException e1) {
                            SwingUtilities.invokeLater(() -> {
                                int dialogResult = Messages.showDialog((Component)this._rootPanel, (String)("Could not connect to " + selectedObr.getDisplayName() + ".\n" + e1.getMessage() + "."), (String)"Connection error", (String[])new String[]{"Retry", "Cancel", "Proxy Settings"}, (int)0, null);
                                switch (dialogResult) {
                                    case 2: {
                                        HttpConfigurable.editConfigurable((JComponent)this._rootPanel);
                                    }
                                    case 0: {
                                        this.search();
                                        break;
                                    }
                                }
                            });
                        }
                    }
                }
                this.stop();
            }
        }, "Obr search");
        t.start();
    }

    public JPanel getRootPanel() {
        return this._rootPanel;
    }

    public void setQueryString(String queryString) {
        this._queryString.setText(queryString);
    }

    private void setResults(List results) {
        SwingUtilities.invokeLater(() -> this._resultList.setModel(new CollectionListModel(results)));
    }

    protected void onProgressChange() {
        SwingUtilities.invokeLater(() -> {
            this._progressBar.setIndeterminate(this.isIndeterminate());
            this._progressBar.setValue((int)(100.0 * this.getFraction()));
            this._statusLabel.setText(this.getText());
            this._cancelButton.setEnabled(this.isRunning() && this.isCancelable());
        });
    }

    protected void onRunningChange() {
        SwingUtilities.invokeLater(() -> {
            this._progressBar.setEnabled(this.isRunning());
            this._statusLabel.setEnabled(this.isRunning());
            this._cancelButton.setEnabled(this.isRunning() && this.isCancelable());
            this._searchButton.setEnabled(!this.isRunning());
        });
    }

    private void updateObrs() {
        ObrProvider provider = (ObrProvider)ServiceManager.getService(ObrProvider.class);
        Obr[] obrs = provider.getAvailableObrs();
        DefaultComboBoxModel<Obr> model = new DefaultComboBoxModel<Obr>();
        block3: for (Obr obr : obrs) {
            switch (this._queryType) {
                case Maven: {
                    if (!obr.supportsMaven()) continue block3;
                    model.addElement(obr);
                }
            }
        }
        this._obrBox.setModel(model);
        if (model.getSize() > 0) {
            this._obrBox.setSelectedIndex(0);
        }
    }

    public Object getResult() {
        return this._resultList.getSelectedValue();
    }

    public boolean isHasResult() {
        return this._resultList.getSelectedValue() != null;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeListeners.add(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeListeners.remove(listener);
    }

    private void firePropertyChangeEvent(String property, Object oldValue, Object newValue) {
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, property, oldValue, newValue);
        for (PropertyChangeListener propertyChangeListener : this.propertyChangeListeners) {
            propertyChangeListener.propertyChange(event);
        }
    }

    public JButton getSearchButton() {
        return this._searchButton;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JComboBox jComboBox;
        JButton jButton;
        JButton jButton2;
        JProgressBar jProgressBar;
        JTextField jTextField;
        JPanel jPanel;
        this._rootPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.setMinimumSize(new Dimension(500, 181));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Query:");
        jPanel.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this._queryString = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel.add((Component)jPanel2, new GridConstraints(2, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder(null, (String)"Results", (int)0, (int)0, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel2.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        JBList jBList = new JBList();
        this._resultList = jBList;
        jBScrollPane.setViewportView((Component)jBList);
        this._progressBar = jProgressBar = new JProgressBar();
        ((Component)jProgressBar).setEnabled(false);
        jPanel.add((Component)jProgressBar, new GridConstraints(4, 0, 1, 2, 0, 1, 6, 0, null, null, null));
        this._searchButton = jButton2 = new JButton();
        jButton2.setText("Search");
        jButton2.setMnemonic('S');
        jButton2.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jButton2, new GridConstraints(1, 2, 1, 1, 0, 1, 3, 0, null, null, null));
        this._cancelButton = jButton = new JButton();
        ((Component)jButton).setEnabled(false);
        jButton.setText("Cancel");
        jButton.setMnemonic('C');
        jButton.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jButton, new GridConstraints(4, 2, 1, 1, 0, 1, 3, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Repository");
        jPanel.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this._obrBox = jComboBox = new JComboBox();
        jPanel.add(jComboBox, new GridConstraints(0, 1, 1, 2, 8, 1, 2, 0, null, null, null));
        this._statusLabel = jLabel = new JLabel();
        ((Component)jLabel).setEnabled(true);
        jLabel.setText("Ready...");
        jPanel.add((Component)jLabel, new GridConstraints(3, 0, 1, 3, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this._rootPanel;
    }
}

