/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.run.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.TreeUIHelper;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.tree.TreeUtil;
import icons.OsmorcIdeaIcons;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.osgi.jps.build.CachingBundleInfoProvider;
import org.osmorc.facet.OsmorcFacet;
import org.osmorc.frameworkintegration.FrameworkInstanceDefinition;
import org.osmorc.frameworkintegration.FrameworkInstanceManager;
import org.osmorc.frameworkintegration.FrameworkIntegrator;
import org.osmorc.frameworkintegration.FrameworkIntegratorRegistry;
import org.osmorc.i18n.OsmorcBundle;
import org.osmorc.run.ui.SelectedBundle;

public class BundleSelector
extends DialogWrapper {
    private JPanel myContentPane;
    private SimpleTree myBundleTree;

    public BundleSelector(@NotNull Project project, @Nullable FrameworkInstanceDefinition instance, @NotNull List<SelectedBundle> selected) {
        if (project == null) {
            BundleSelector.$$$reportNull$$$0(0);
        }
        if (selected == null) {
            BundleSelector.$$$reportNull$$$0(1);
        }
        super(project);
        Object[] objectArray = new Object[]{};
        this.$$$setupUI$$$();
        this.setTitle(OsmorcBundle.message("bundle.selector.title", objectArray));
        this.setModal(true);
        this.myContentPane.setPreferredSize((Dimension)JBUI.size((int)600, (int)400));
        this.myBundleTree.setModel(BundleSelector.createModel(project, instance, selected));
        this.myBundleTree.setCellRenderer((TreeCellRenderer)((Object)new BundleTreeRenderer()));
        this.myBundleTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                BundleSelector.this.setOKActionEnabled(BundleSelector.this.myBundleTree.getSelectionCount() > 0);
            }
        });
        TreeUtil.expandAll((JTree)this.myBundleTree);
        TreeUIHelper.getInstance().installTreeSpeedSearch((JTree)this.myBundleTree);
        this.init();
    }

    private static TreeModel createModel(Project project, FrameworkInstanceDefinition instance, Collection<SelectedBundle> selectedList) {
        FrameworkIntegrator integrator;
        Module[] modules;
        HashSet selected = ContainerUtil.newHashSet(selectedList);
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        DefaultMutableTreeNode moduleNode = new DefaultMutableTreeNode(OsmorcBundle.message("bundle.selector.group.modules", new Object[0]));
        for (Module module : modules = ModuleManager.getInstance((Project)project).getModules()) {
            SelectedBundle bundle;
            if (!OsmorcFacet.hasOsmorcFacet(module) || selected.contains(bundle = new SelectedBundle(SelectedBundle.BundleType.Module, module.getName(), null))) continue;
            moduleNode.add(new DefaultMutableTreeNode(bundle));
        }
        if (moduleNode.getChildCount() > 0) {
            root.add(moduleNode);
        }
        if (instance != null && (integrator = FrameworkIntegratorRegistry.getInstance().findIntegratorByInstanceDefinition(instance)) != null) {
            DefaultMutableTreeNode frameworkNode = new DefaultMutableTreeNode(OsmorcBundle.message("bundle.selector.group.framework", new Object[0]));
            for (SelectedBundle bundle : integrator.getFrameworkInstanceManager().getFrameworkBundles(instance, FrameworkInstanceManager.FrameworkBundleType.OTHER)) {
                if (selected.contains(bundle)) continue;
                frameworkNode.add(new DefaultMutableTreeNode(bundle));
            }
            if (frameworkNode.getChildCount() > 0) {
                root.add(frameworkNode);
            }
        }
        DefaultMutableTreeNode libraryNode = new DefaultMutableTreeNode(OsmorcBundle.message("bundle.selector.group.libraries", new Object[0]));
        List paths = OrderEnumerator.orderEntries((Project)project).librariesOnly().productionOnly().runtimeOnly().classes().getPathsList().getPathList();
        for (String path : paths) {
            SelectedBundle bundle;
            String displayName = CachingBundleInfoProvider.getBundleSymbolicName((String)path);
            if (displayName == null || selected.contains(bundle = new SelectedBundle(SelectedBundle.BundleType.StartLibrary, displayName, path))) continue;
            libraryNode.add(new DefaultMutableTreeNode(bundle));
        }
        if (libraryNode.getChildCount() > 0) {
            root.add(libraryNode);
        }
        return new DefaultTreeModel(root);
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myContentPane;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myBundleTree;
    }

    @NotNull
    public List<SelectedBundle> getSelectedBundles() {
        TreePath[] paths = this.myBundleTree.getSelectionPaths();
        if (paths == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                BundleSelector.$$$reportNull$$$0(2);
            }
            return list;
        }
        ArrayList bundles = ContainerUtil.newArrayListWithCapacity((int)paths.length);
        for (TreePath path : paths) {
            Object object;
            Object last = path.getLastPathComponent();
            if (!(last instanceof DefaultMutableTreeNode) || !((object = ((DefaultMutableTreeNode)last).getUserObject()) instanceof SelectedBundle)) continue;
            bundles.add((SelectedBundle)object);
        }
        ArrayList arrayList = bundles;
        if (arrayList == null) {
            BundleSelector.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selected";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/osmorc/run/ui/BundleSelector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/osmorc/run/ui/BundleSelector";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedBundles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        SimpleTree simpleTree;
        JPanel jPanel;
        this.myContentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myBundleTree = simpleTree = new SimpleTree();
        simpleTree.setRootVisible(false);
        simpleTree.putClientProperty((Object)"JTree.lineStyle", (Object)"Angled");
        jBScrollPane.setViewportView((Component)simpleTree);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }

    private static class BundleTreeRenderer
    extends ColoredTreeCellRenderer {
        private BundleTreeRenderer() {
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Object object;
            if (tree == null) {
                BundleTreeRenderer.$$$reportNull$$$0(0);
            }
            if (value instanceof DefaultMutableTreeNode && (object = ((DefaultMutableTreeNode)value).getUserObject()) instanceof SelectedBundle) {
                SelectedBundle bundle = (SelectedBundle)object;
                if (bundle.isModule()) {
                    this.setIcon(AllIcons.Nodes.Module);
                } else if (bundle.getBundleType() == SelectedBundle.BundleType.FrameworkBundle) {
                    this.setIcon(OsmorcIdeaIcons.Osgi);
                } else {
                    this.setIcon(AllIcons.Nodes.PpJar);
                }
            }
            this.append(value.toString());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "org/osmorc/run/ui/BundleSelector$BundleTreeRenderer", "customizeCellRenderer"));
        }
    }
}

