/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.settings;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.ListUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.osgi.jps.model.LibraryBundlificationRule;
import org.osmorc.settings.ApplicationSettings;
import org.osmorc.settings.ManifestEditor;

public class LibraryBundlingEditorComponent {
    private final Project myProject;
    private JPanel myMainPanel;
    private JPanel myRulesPanel;
    private JBList myRulesList;
    private JTextField myLibraryRegex;
    private ManifestEditor myManifestEditor;
    private JCheckBox myNeverBundle;
    private JCheckBox myStopAfterThisRule;
    private final CollectionListModel<LibraryBundlificationRule> myRulesModel;
    private int myLastSelected;

    public LibraryBundlingEditorComponent(@NotNull Project project) {
        if (project == null) {
            LibraryBundlingEditorComponent.$$$reportNull$$$0(0);
        }
        this.myLastSelected = -1;
        this.myProject = project;
        this.$$$setupUI$$$();
        GuiUtils.replaceJSplitPaneWithIDEASplitter((JComponent)this.myMainPanel);
        ((JBSplitter)this.myMainPanel.getComponent(0)).setProportion(0.4f);
        this.myRulesPanel.add((Component)ToolbarDecorator.createDecorator((JList)this.myRulesList).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                LibraryBundlingEditorComponent.this.updateCurrentRule();
                LibraryBundlingEditorComponent.this.myRulesModel.add((Object)new LibraryBundlificationRule());
                LibraryBundlingEditorComponent.this.myRulesList.setSelectedIndex(LibraryBundlingEditorComponent.this.myRulesModel.getSize() - 1);
                LibraryBundlingEditorComponent.this.updateFields();
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                LibraryBundlingEditorComponent.this.myLastSelected = -1;
                if (LibraryBundlingEditorComponent.this.myRulesModel.getSize() == 1) {
                    LibraryBundlingEditorComponent.this.myRulesModel.setElementAt((Object)new LibraryBundlificationRule(), 0);
                    LibraryBundlingEditorComponent.this.myRulesList.setSelectedIndex(0);
                } else {
                    int index = LibraryBundlingEditorComponent.this.myRulesList.getSelectedIndex();
                    LibraryBundlingEditorComponent.this.myRulesModel.remove(index);
                    LibraryBundlingEditorComponent.this.myRulesList.setSelectedIndex(index > 0 ? index - 1 : 0);
                }
                LibraryBundlingEditorComponent.this.updateFields();
            }
        }).setMoveUpAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                LibraryBundlingEditorComponent.this.updateCurrentRule();
                LibraryBundlingEditorComponent.this.myLastSelected = -1;
                ListUtil.moveSelectedItemsUp((JList)LibraryBundlingEditorComponent.this.myRulesList);
                LibraryBundlingEditorComponent.this.updateFields();
            }
        }).setMoveDownAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                LibraryBundlingEditorComponent.this.updateCurrentRule();
                LibraryBundlingEditorComponent.this.myLastSelected = -1;
                ListUtil.moveSelectedItemsDown((JList)LibraryBundlingEditorComponent.this.myRulesList);
                LibraryBundlingEditorComponent.this.updateFields();
            }
        }).addExtraAction(new AnActionButton("Copy", PlatformIcons.COPY_ICON){

            public void actionPerformed(AnActionEvent e) {
                LibraryBundlingEditorComponent.this.updateCurrentRule();
                int index = LibraryBundlingEditorComponent.this.myRulesList.getSelectedIndex();
                if (index >= 0) {
                    LibraryBundlingEditorComponent.this.myRulesModel.add((Object)((LibraryBundlificationRule)LibraryBundlingEditorComponent.this.myRulesModel.getElementAt(index)).copy());
                    LibraryBundlingEditorComponent.this.myRulesList.setSelectedIndex(LibraryBundlingEditorComponent.this.myRulesModel.getSize() - 1);
                    LibraryBundlingEditorComponent.this.updateFields();
                }
            }

            public boolean isEnabled() {
                return LibraryBundlingEditorComponent.this.myRulesList.getSelectedIndex() >= 0;
            }
        }).createPanel(), "Center");
        this.myRulesModel = new CollectionListModel((Object[])new LibraryBundlificationRule[0]);
        this.myRulesList.setModel(this.myRulesModel);
        this.myRulesList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                LibraryBundlingEditorComponent.this.updateCurrentRule();
                LibraryBundlingEditorComponent.this.updateFields();
            }
        });
    }

    private void createUIComponents() {
        this.myManifestEditor = new ManifestEditor(this.myProject, "");
    }

    private void updateFields() {
        int index = this.myRulesList.getSelectedIndex();
        if (index >= 0 && index != this.myLastSelected) {
            LibraryBundlificationRule rule = (LibraryBundlificationRule)this.myRulesModel.getElementAt(index);
            this.myLibraryRegex.setText(rule.getRuleRegex());
            UIUtil.invokeLaterIfNeeded(() -> this.myManifestEditor.setText(rule.getAdditionalProperties()));
            this.myNeverBundle.setSelected(rule.isDoNotBundle());
            this.myStopAfterThisRule.setSelected(rule.isStopAfterThisRule());
            this.myLastSelected = index;
        }
        this.myLibraryRegex.setEnabled(index >= 0);
        this.myManifestEditor.setEnabled(index >= 0);
        this.myNeverBundle.setEnabled(index >= 0);
        this.myStopAfterThisRule.setEnabled(index >= 0);
    }

    private void updateCurrentRule() {
        if (this.myLastSelected >= 0 && this.myLastSelected < this.myRulesModel.getSize()) {
            LibraryBundlificationRule newRule = new LibraryBundlificationRule();
            newRule.setRuleRegex(this.myLibraryRegex.getText().trim());
            newRule.setAdditionalProperties(this.myManifestEditor.getText().trim());
            newRule.setDoNotBundle(this.myNeverBundle.isSelected());
            newRule.setStopAfterThisRule(this.myStopAfterThisRule.isSelected());
            if (!newRule.equals(this.myRulesModel.getElementAt(this.myLastSelected))) {
                this.myRulesModel.setElementAt((Object)newRule, this.myLastSelected);
            }
        }
    }

    public JPanel getMainPanel() {
        return this.myMainPanel;
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myManifestEditor);
        this.myManifestEditor = null;
    }

    public boolean isModified(ApplicationSettings settings) {
        this.updateCurrentRule();
        List<LibraryBundlificationRule> rules = settings.getLibraryBundlificationRules();
        if (this.myRulesModel.getSize() != rules.size()) {
            return true;
        }
        for (int i = 0; i < rules.size(); ++i) {
            if (rules.get(i).equals(this.myRulesModel.getElementAt(i))) continue;
            return true;
        }
        return false;
    }

    public void resetTo(ApplicationSettings settings) {
        this.myLastSelected = -1;
        this.myRulesModel.replaceAll(settings.getLibraryBundlificationRules());
        this.myRulesList.setSelectedIndex(0);
        this.updateFields();
    }

    public void applyTo(ApplicationSettings settings) throws ConfigurationException {
        this.updateCurrentRule();
        for (int i = 0; i < this.myRulesModel.getSize(); ++i) {
            try {
                ((LibraryBundlificationRule)this.myRulesModel.getElementAt(i)).validate();
                continue;
            }
            catch (IllegalArgumentException e) {
                this.myRulesList.setSelectedIndex(i);
                throw new ConfigurationException(e.getMessage());
            }
        }
        settings.setLibraryBundlificationRules(ContainerUtil.newArrayList((Iterable)this.myRulesModel.getItems()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/osmorc/settings/LibraryBundlingEditorComponent", "<init>"));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JTextField jTextField;
        JBList jBList;
        JPanel jPanel;
        JPanel jPanel2;
        this.createUIComponents();
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JSplitPane jSplitPane = new JSplitPane();
        jPanel2.add((Component)jSplitPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(200, 200), null));
        this.myRulesPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jSplitPane.setLeftComponent(jPanel);
        this.myRulesList = jBList = new JBList();
        jBList.setSelectionMode(0);
        jPanel.add((Component)jBList, "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jSplitPane.setRightComponent(jPanel3);
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Library name pattern:");
        jPanel3.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myLibraryRegex = jTextField = new JTextField();
        jPanel3.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Manifest entries:");
        jPanel3.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        ManifestEditor manifestEditor = this.myManifestEditor;
        jPanel3.add((Component)((Object)manifestEditor), new GridConstraints(2, 0, 1, 2, 0, 1, 3, 3, null, new Dimension(-1, 200), null));
        this.myNeverBundle = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Never bundle");
        jPanel3.add((Component)jCheckBox2, new GridConstraints(3, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myStopAfterThisRule = jCheckBox = new JCheckBox();
        jCheckBox.setText("Process no further rules");
        jPanel3.add((Component)jCheckBox, new GridConstraints(4, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        jBLabel.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

