/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.settings;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerProjectExtension;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.xmlb.XmlSerializerUtil;
import java.util.EventListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="Osmorc")
public class ProjectSettings
implements PersistentStateComponent<ProjectSettings> {
    private EventDispatcher<ProjectSettingsListener> myDispatcher = EventDispatcher.create(ProjectSettingsListener.class);
    private String myFrameworkInstanceName;
    private String myDefaultManifestFileLocation = "META-INF/MANIFEST.MF";
    private String myBundlesOutputPath;
    private boolean myBndAutoImport = false;

    @NotNull
    public static String getDefaultBundlesOutputPath(Project project) {
        VirtualFilePointer compilerOutput;
        CompilerProjectExtension instance = CompilerProjectExtension.getInstance((Project)project);
        if (instance != null && (compilerOutput = instance.getCompilerOutputPointer()) != null) {
            String string = VfsUtilCore.urlToPath((String)compilerOutput.getUrl()) + "/bundles";
            if (string == null) {
                ProjectSettings.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = FileUtil.getTempDirectory();
        if (string == null) {
            ProjectSettings.$$$reportNull$$$0(1);
        }
        return string;
    }

    public static ProjectSettings getInstance(@NotNull Project project) {
        if (project == null) {
            ProjectSettings.$$$reportNull$$$0(2);
        }
        return (ProjectSettings)ServiceManager.getService((Project)project, ProjectSettings.class);
    }

    @Nullable
    public String getBundlesOutputPath() {
        return this.myBundlesOutputPath;
    }

    public void setBundlesOutputPath(@Nullable String bundlesOutputPath) {
        this.myBundlesOutputPath = bundlesOutputPath;
    }

    @Nullable
    public String getFrameworkInstanceName() {
        return this.myFrameworkInstanceName;
    }

    public void setFrameworkInstanceName(@Nullable String frameworkInstanceName) {
        this.myFrameworkInstanceName = frameworkInstanceName;
        ((ProjectSettingsListener)this.myDispatcher.getMulticaster()).projectSettingsChanged();
    }

    @NotNull
    public String getDefaultManifestFileLocation() {
        String string = this.myDefaultManifestFileLocation;
        if (string == null) {
            ProjectSettings.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void setDefaultManifestFileLocation(@NotNull String location) {
        if (location == null) {
            ProjectSettings.$$$reportNull$$$0(4);
        }
        this.myDefaultManifestFileLocation = location.equals("META-INF") ? "META-INF/MANIFEST.MF" : location;
        ((ProjectSettingsListener)this.myDispatcher.getMulticaster()).projectSettingsChanged();
    }

    public boolean isBndAutoImport() {
        return this.myBndAutoImport;
    }

    public void setBndAutoImport(boolean bndAutoImport) {
        this.myBndAutoImport = bndAutoImport;
    }

    @NotNull
    public ProjectSettings getState() {
        ProjectSettings projectSettings = this;
        if (projectSettings == null) {
            ProjectSettings.$$$reportNull$$$0(5);
        }
        return projectSettings;
    }

    public void loadState(@NotNull ProjectSettings state) {
        if (state == null) {
            ProjectSettings.$$$reportNull$$$0(6);
        }
        XmlSerializerUtil.copyBean((Object)state, (Object)this);
    }

    public void addProjectSettingsListener(@NotNull ProjectSettingsListener listener) {
        if (listener == null) {
            ProjectSettings.$$$reportNull$$$0(7);
        }
        this.myDispatcher.addListener((EventListener)listener);
    }

    public void removeProjectSettingsListener(@NotNull ProjectSettingsListener listener) {
        if (listener == null) {
            ProjectSettings.$$$reportNull$$$0(8);
        }
        this.myDispatcher.removeListener((EventListener)listener);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/osmorc/settings/ProjectSettings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultBundlesOutputPath";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "org/osmorc/settings/ProjectSettings";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultManifestFileLocation";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setDefaultManifestFileLocation";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addProjectSettingsListener";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "removeProjectSettingsListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface ProjectSettingsListener
    extends EventListener {
        public void projectSettingsChanged();
    }
}

