/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle;

import com.intellij.openapi.Disposable;
import com.intellij.spring.boot.run.lifecycle.AsyncLiveProperty;
import com.intellij.spring.boot.run.lifecycle.LifecycleErrorHandler;
import com.intellij.spring.boot.run.lifecycle.LiveProperty;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationConnector;

abstract class AsyncApplicationLiveProperty<T>
extends AsyncLiveProperty<T> {
    private final LiveProperty<String> myApplicationAdminJmxName;
    private final int myJmxPort;

    protected AsyncApplicationLiveProperty(LiveProperty<String> applicationAdminJmxName, int jmxPort, LifecycleErrorHandler errorHandler, Disposable parent) {
        this(applicationAdminJmxName, jmxPort, errorHandler, parent, null);
    }

    protected AsyncApplicationLiveProperty(LiveProperty<String> applicationAdminJmxName, int jmxPort, LifecycleErrorHandler errorHandler, Disposable parent, T defaultValue) {
        super(errorHandler, parent, defaultValue);
        this.myApplicationAdminJmxName = applicationAdminJmxName;
        LOG.assertTrue(jmxPort > 0);
        this.myJmxPort = jmxPort;
    }

    protected SpringBootApplicationConnector getApplicationConnector() {
        return new SpringBootApplicationConnector(this.myJmxPort, (String)this.myApplicationAdminJmxName.getValue());
    }

    protected int getJmxPort() {
        return this.myJmxPort;
    }
}

