/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.spring.boot.run.lifecycle.AbstractLiveProperty;
import com.intellij.spring.boot.run.lifecycle.LifecycleErrorHandler;
import com.intellij.spring.boot.run.lifecycle.LifecycleException;
import com.intellij.spring.boot.run.lifecycle.LiveProperty;

abstract class AsyncLiveProperty<T>
extends AbstractLiveProperty<T> {
    protected static final Logger LOG = Logger.getInstance((String)"#com.intellij.spring.boot.run.lifecycle.AsyncLiveProperty");
    private final LifecycleErrorHandler myErrorHandler;
    private volatile boolean myDisposed;

    protected AsyncLiveProperty(LifecycleErrorHandler errorHandler, Disposable parent) {
        this(errorHandler, parent, null);
    }

    protected AsyncLiveProperty(LifecycleErrorHandler errorHandler, Disposable parent, T defaultValue) {
        super(defaultValue);
        this.myErrorHandler = errorHandler;
        if (parent != null) {
            Disposer.register((Disposable)parent, (Disposable)this);
        }
    }

    public void compute() {
        if (this.myDisposed) {
            return;
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (this.myDisposed) {
                return;
            }
            try {
                T value = this.doCompute();
                T oldValue = this.setValue(value);
                if (!Comparing.equal(oldValue, value)) {
                    this.getListeners().forEach(LiveProperty.LivePropertyListener::propertyChanged);
                }
            }
            catch (LifecycleException e) {
                LOG.debug(e.getCause());
                if (e.getMessage() != null) {
                    this.myErrorHandler.handleLifecycleError(e.getMessage());
                }
                this.setValue(null);
                if (e.getCause() instanceof Exception) {
                    Exception cause = (Exception)e.getCause();
                    this.getListeners().forEach(listener -> listener.computationFailed(cause));
                }
            }
            finally {
                this.getListeners().forEach(listener -> listener.computationFinished());
            }
        });
    }

    public void dispose() {
        this.myDisposed = true;
    }

    protected boolean isDisposed() {
        return this.myDisposed;
    }

    protected abstract T doCompute() throws LifecycleException;
}

