/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle.mappings;

import com.intellij.openapi.util.Comparing;
import com.intellij.spring.boot.run.lifecycle.mappings.LiveHandlerMethod;
import com.intellij.spring.boot.run.lifecycle.mappings.LiveHandlerMethodImpl;
import com.intellij.spring.boot.run.lifecycle.mappings.LiveRequestMapping;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LiveRequestMappingImpl
implements LiveRequestMapping {
    private static final String REQUEST_METHODS_PART = ",methods=[";
    private static final String PRODUCES_PART = ",produces=[";
    @NotNull
    private final String myMapping;
    @NotNull
    private final String myPath;
    @Nullable
    private final String myBean;
    @Nullable
    private final LiveHandlerMethod myMethod;
    @NotNull
    private final List<String> myRequestMethods;
    @Nullable
    private final String myProduces;

    LiveRequestMappingImpl(@NotNull String mapping, @NotNull String path, @Nullable String bean, @Nullable String method) {
        if (mapping == null) {
            LiveRequestMappingImpl.$$$reportNull$$$0(0);
        }
        if (path == null) {
            LiveRequestMappingImpl.$$$reportNull$$$0(1);
        }
        this.myMapping = mapping;
        this.myPath = path;
        this.myBean = bean;
        this.myMethod = method != null ? new LiveHandlerMethodImpl(method) : null;
        this.myRequestMethods = LiveRequestMappingImpl.parseRequestMethods(mapping);
        this.myProduces = LiveRequestMappingImpl.parseProduces(mapping);
    }

    @NotNull
    public String getMapping() {
        String string = this.myMapping;
        if (string == null) {
            LiveRequestMappingImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getPath() {
        String string = this.myPath;
        if (string == null) {
            LiveRequestMappingImpl.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public List<String> getRequestMethods() {
        List<String> list = Collections.unmodifiableList(this.myRequestMethods);
        if (list == null) {
            LiveRequestMappingImpl.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Nullable
    public String getProduces() {
        return this.myProduces;
    }

    @Nullable
    public String getBean() {
        return this.myBean;
    }

    @Nullable
    public LiveHandlerMethod getMethod() {
        return this.myMethod;
    }

    public boolean canNavigate() {
        return this.myMethod != null && (this.myRequestMethods.isEmpty() || this.myRequestMethods.contains("GET"));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LiveRequestMappingImpl) {
            LiveRequestMappingImpl liveMapping = (LiveRequestMappingImpl)obj;
            return this.myMapping.equals(liveMapping.myMapping) && this.myPath.equals(liveMapping.myPath) && Comparing.equal((String)this.myBean, (String)liveMapping.myBean) && Comparing.equal((Object)this.myMethod, (Object)liveMapping.myMethod);
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.myMapping.hashCode();
        result = 31 * result + this.myPath.hashCode();
        result = 31 * result + (this.myBean != null ? this.myBean.hashCode() : 0);
        result = 31 * result + (this.myMethod != null ? this.myMethod.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.myMapping;
    }

    @NotNull
    private static List<String> parseRequestMethods(String mapping) {
        int end;
        int requestMethodsIndex = mapping.indexOf(REQUEST_METHODS_PART);
        if (requestMethodsIndex >= 0 && (end = mapping.indexOf(93, requestMethodsIndex)) > requestMethodsIndex) {
            String methods = mapping.substring(requestMethodsIndex + REQUEST_METHODS_PART.length(), end);
            List<String> list = Arrays.stream(methods.split(Pattern.quote("||"))).map(String::trim).collect(Collectors.toList());
            if (list == null) {
                LiveRequestMappingImpl.$$$reportNull$$$0(5);
            }
            return list;
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            LiveRequestMappingImpl.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Nullable
    private static String parseProduces(String mapping) {
        int end;
        int producesIndex = mapping.indexOf(PRODUCES_PART);
        if (producesIndex >= 0 && (end = mapping.indexOf(93, producesIndex)) > producesIndex) {
            return mapping.substring(producesIndex + PRODUCES_PART.length(), end);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/run/lifecycle/mappings/LiveRequestMappingImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/run/lifecycle/mappings/LiveRequestMappingImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMapping";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequestMethods";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "parseRequestMethods";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

