/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle.tabs;

import com.intellij.execution.process.ProcessHandler;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.Disposer;
import com.intellij.spring.SpringApiBundle;
import com.intellij.spring.boot.run.SpringBootApplicationRunConfiguration;
import com.intellij.spring.boot.run.SpringBootRunBundle;
import com.intellij.spring.boot.run.lifecycle.LiveProperty;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationInfo;
import com.intellij.spring.boot.run.lifecycle.tabs.EndpointTab;
import com.intellij.spring.boot.run.lifecycle.tabs.LifecycleFinderRecursivePanel;
import com.intellij.spring.boot.run.lifecycle.tabs.LiveBeansPanel;
import com.intellij.spring.boot.run.lifecycle.tabs.LiveContextsPanel;
import com.intellij.spring.boot.run.lifecycle.tabs.LiveResourcesPanel;
import com.intellij.spring.boot.run.lifecycle.tabs.SpringBootEndpointsTabSettings;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.FinderRecursivePanel;
import icons.SpringApiIcons;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

class LiveBeansTab
extends EndpointTab {
    private static final String TAB_ID = "beans";
    private final JComponent myWrapper;
    private final SimpleToolWindowPanel myMainPanel;
    private LifecycleFinderRecursivePanel myRootPanel;

    LiveBeansTab(@NotNull SpringBootApplicationRunConfiguration runConfiguration, @NotNull ProcessHandler processHandler) {
        if (runConfiguration == null) {
            LiveBeansTab.$$$reportNull$$$0(0);
        }
        if (processHandler == null) {
            LiveBeansTab.$$$reportNull$$$0(1);
        }
        super(runConfiguration, processHandler);
        this.myMainPanel = new SimpleToolWindowPanel(false, true);
        this.refreshContentPanel();
        this.myWrapper = DumbService.getInstance((Project)this.getProject()).wrapGently((JComponent)this.myMainPanel, (Disposable)this);
        this.getProject().getMessageBus().connect((Disposable)this).subscribe(SpringBootEndpointsTabSettings.TOPIC, (Object)new SpringBootEndpointsTabSettings.Listener(){

            @Override
            public void settingsChanged(SpringBootEndpointsTabSettings.ChangeType changeType) {
                switch (changeType) {
                    case BEANS_FULL: {
                        LiveBeansTab.this.performFullUpdate();
                        break;
                    }
                    case BEANS_UPDATE_DETAILS: {
                        LiveBeansTab.this.performDetailsUpdate();
                        break;
                    }
                }
            }
        });
    }

    @Override
    @NotNull
    public String getId() {
        if (TAB_ID == null) {
            LiveBeansTab.$$$reportNull$$$0(2);
        }
        return TAB_ID;
    }

    @Override
    public String getTitle() {
        return SpringBootRunBundle.message("spring.boot.application.endpoints.beans.tab.title", new Object[0]);
    }

    @Override
    public Icon getIcon() {
        return SpringApiIcons.SpringBean;
    }

    @Override
    @NotNull
    protected List<AnAction> getToolbarActions() {
        ArrayList<AnAction> actions = new ArrayList<AnAction>();
        actions.add((AnAction)new EndpointTab.EndpointToggleAction(SpringBootRunBundle.message("spring.boot.application.endpoints.show.context.action.name", new Object[0]), null, SpringApiIcons.FileSet){

            public boolean isSelected(AnActionEvent e) {
                return LiveBeansTab.this.getSettings().isShowContexts();
            }

            public void setSelected(AnActionEvent e, boolean state) {
                SpringBootEndpointsTabSettings settings = LiveBeansTab.this.getSettings();
                settings.setShowContexts(state);
                settings.fireSettingsChanged(SpringBootEndpointsTabSettings.ChangeType.BEANS_FULL);
            }
        });
        actions.add((AnAction)new EndpointTab.EndpointToggleAction(SpringApiBundle.message((String)"spring.beans.view.show.configuration.files", (Object[])new Object[0]), null, SpringApiIcons.SpringConfig){

            public boolean isSelected(AnActionEvent e) {
                return LiveBeansTab.this.getSettings().isShowFiles();
            }

            public void setSelected(AnActionEvent e, boolean state) {
                SpringBootEndpointsTabSettings settings = LiveBeansTab.this.getSettings();
                settings.setShowFiles(state);
                settings.fireSettingsChanged(SpringBootEndpointsTabSettings.ChangeType.BEANS_FULL);
            }
        });
        actions.add((AnAction)Separator.getInstance());
        actions.add((AnAction)new EndpointTab.EndpointToggleAction(SpringApiBundle.message((String)"spring.beans.view.show.bean.documentation.title", (Object[])new Object[0]), null, AllIcons.Toolwindows.Documentation){

            public boolean isSelected(AnActionEvent e) {
                return LiveBeansTab.this.getSettings().isShowDoc();
            }

            public void setSelected(AnActionEvent e, boolean state) {
                SpringBootEndpointsTabSettings settings = LiveBeansTab.this.getSettings();
                settings.setShowDoc(state);
                settings.fireSettingsChanged(SpringBootEndpointsTabSettings.ChangeType.BEANS_UPDATE_DETAILS);
            }
        });
        if (((LiveBeansPanel.LiveBeansPanelContent[])LiveBeansPanel.EP_NAME.getExtensions()).length != 0) {
            actions.add((AnAction)new EndpointTab.EndpointToggleAction(SpringApiBundle.message((String)"spring.beans.view.show.bean.graph.title", (Object[])new Object[0]), null, AllIcons.FileTypes.Diagram){

                public boolean isSelected(AnActionEvent e) {
                    return LiveBeansTab.this.getSettings().isShowLiveBeansGraph();
                }

                public void setSelected(AnActionEvent e, boolean state) {
                    SpringBootEndpointsTabSettings settings = LiveBeansTab.this.getSettings();
                    settings.setShowLiveBeansGraph(state);
                    settings.fireSettingsChanged(SpringBootEndpointsTabSettings.ChangeType.BEANS_UPDATE_DETAILS);
                }
            });
        }
        ArrayList<AnAction> arrayList = actions;
        if (arrayList == null) {
            LiveBeansTab.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @Override
    @NotNull
    protected LiveProperty getLiveProperty(SpringBootApplicationInfo info) {
        LiveProperty liveProperty = info.getLiveBeansModel();
        if (liveProperty == null) {
            LiveBeansTab.$$$reportNull$$$0(4);
        }
        return liveProperty;
    }

    @Override
    @NotNull
    protected JComponent getEndpointComponent() {
        JComponent jComponent = this.myWrapper;
        if (jComponent == null) {
            LiveBeansTab.$$$reportNull$$$0(5);
        }
        return jComponent;
    }

    @Override
    protected void updateComponent() {
        SpringBootApplicationInfo info = this.getInfo();
        long timeStamp = info != null ? info.getLiveBeansModel().getTimeStamp() : -1L;
        AppUIUtil.invokeLaterIfProjectAlive((Project)this.getProject(), () -> {
            this.setTimeStampTooltip(timeStamp);
            this.myRootPanel.updateComponent();
        });
    }

    @Override
    protected String getErrorMessage(String cause) {
        return SpringBootRunBundle.message("spring.boot.application.endpoints.error.failed.to.retrieve.application.beans.snapshot", cause);
    }

    private void refreshContentPanel() {
        this.myRootPanel = this.createRootPanel();
        this.myRootPanel.initPanel();
        this.myMainPanel.setContent((JComponent)((Object)this.myRootPanel));
        Disposer.register((Disposable)this, (Disposable)this.myRootPanel);
    }

    private LifecycleFinderRecursivePanel createRootPanel() {
        if (SpringBootEndpointsTabSettings.getInstance(this.getProject()).isShowContexts()) {
            return new LiveContextsPanel(this.getProject(), this.getRunConfiguration(), this.getProcessHandler());
        }
        if (SpringBootEndpointsTabSettings.getInstance(this.getProject()).isShowFiles()) {
            return new LiveResourcesPanel(this.getProject(), this.getRunConfiguration(), this.getProcessHandler());
        }
        return new LiveBeansPanel(this.getProject(), this.getRunConfiguration(), this.getProcessHandler());
    }

    private void performFullUpdate() {
        ApplicationManager.getApplication().invokeLater(() -> {
            LifecycleFinderRecursivePanel oldPanel = this.myRootPanel;
            this.myMainPanel.remove((Component)((Object)oldPanel));
            Disposer.dispose((Disposable)oldPanel);
            this.refreshContentPanel();
        }, ModalityState.NON_MODAL, o -> Disposer.isDisposed((Disposable)this));
    }

    private void performDetailsUpdate() {
        LifecycleFinderRecursivePanel panel = this.myRootPanel;
        while (true) {
            if (!(panel.getSecondComponent() instanceof FinderRecursivePanel)) break;
            panel = (FinderRecursivePanel)panel.getSecondComponent();
        }
        panel.updateRightComponent(true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/run/lifecycle/tabs/LiveBeansTab";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/run/lifecycle/tabs/LiveBeansTab";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolbarActions";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLiveProperty";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getEndpointComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

