/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle.tabs;

import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.NaturalComparator;
import com.intellij.spring.boot.run.SpringBootApplicationRunConfiguration;
import com.intellij.spring.boot.run.SpringBootRunBundle;
import com.intellij.spring.boot.run.lifecycle.beans.LiveBeansModel;
import com.intellij.spring.boot.run.lifecycle.beans.LiveContext;
import com.intellij.spring.boot.run.lifecycle.tabs.LifecycleFinderRecursivePanel;
import com.intellij.spring.boot.run.lifecycle.tabs.LiveBeansPanel;
import com.intellij.spring.boot.run.lifecycle.tabs.LiveResourcesPanel;
import com.intellij.spring.boot.run.lifecycle.tabs.SpringBootEndpointsTabSettings;
import icons.SpringApiIcons;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LiveContextsPanel
extends LifecycleFinderRecursivePanel<LiveContext> {
    private static final String LIVE_CONTEXTS_PANEL_GROUP_ID = "LiveContextsPanel";

    LiveContextsPanel(@NotNull Project project, @NotNull SpringBootApplicationRunConfiguration runConfiguration, @NotNull ProcessHandler processHandler) {
        if (project == null) {
            LiveContextsPanel.$$$reportNull$$$0(0);
        }
        if (runConfiguration == null) {
            LiveContextsPanel.$$$reportNull$$$0(1);
        }
        if (processHandler == null) {
            LiveContextsPanel.$$$reportNull$$$0(2);
        }
        super(project, null, LIVE_CONTEXTS_PANEL_GROUP_ID, runConfiguration, processHandler);
    }

    @NotNull
    protected List<LiveContext> getListItems() {
        LiveBeansModel model = this.getModel();
        if (model == null) {
            List<LiveContext> list = Collections.emptyList();
            if (list == null) {
                LiveContextsPanel.$$$reportNull$$$0(3);
            }
            return list;
        }
        List contexts = model.getContexts();
        Collections.sort(contexts, Comparator.comparing(LiveContext::getName, NaturalComparator.INSTANCE));
        List list = contexts;
        if (list == null) {
            LiveContextsPanel.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    protected String getItemText(LiveContext context) {
        String string = context.getName();
        if (string == null) {
            LiveContextsPanel.$$$reportNull$$$0(5);
        }
        return string;
    }

    protected boolean hasChildren(LiveContext context) {
        return true;
    }

    @Nullable
    protected Icon getItemIcon(LiveContext context) {
        return SpringApiIcons.FileSet;
    }

    @Nullable
    protected JComponent createRightComponent(LiveContext context) {
        if (SpringBootEndpointsTabSettings.getInstance(this.getProject()).isShowFiles()) {
            return new LiveResourcesPanel(this.getProject(), this, this.getGroupId(), this.getRunConfiguration(), this.getProcessHandler(), context);
        }
        return new LiveBeansPanel(this.getProject(), this, this.getGroupId(), this.getRunConfiguration(), this.getProcessHandler(), context, null);
    }

    protected boolean isEditable() {
        return false;
    }

    @Nullable
    protected String getItemTooltipText(LiveContext context) {
        if (context.getParent() == null) {
            return SpringBootRunBundle.message("spring.boot.application.endpoints.root.context", new Object[0]);
        }
        return SpringBootRunBundle.message("spring.boot.application.endpoints.parent.context", context.getParent().getName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/run/lifecycle/tabs/LiveContextsPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/run/lifecycle/tabs/LiveContextsPanel";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getListItems";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getItemText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

