/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle.tabs;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import com.intellij.util.xmlb.XmlSerializerUtil;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

@State(name="SpringBootEndpointsTabSettings", storages={@Storage(value="$WORKSPACE_FILE$")})
public class SpringBootEndpointsTabSettings
implements PersistentStateComponent<Settings> {
    public static final Topic<Listener> TOPIC = new Topic("Spring Boot Endpoints tab settings", Listener.class);
    private final MessageBus myMessageBus;
    private final Settings mySettings = new Settings();

    public static SpringBootEndpointsTabSettings getInstance(Project project) {
        return (SpringBootEndpointsTabSettings)ServiceManager.getService((Project)project, SpringBootEndpointsTabSettings.class);
    }

    public SpringBootEndpointsTabSettings(MessageBus messageBus) {
        this.myMessageBus = messageBus;
    }

    @Nullable
    public Settings getState() {
        return this.mySettings;
    }

    public void loadState(Settings settings) {
        XmlSerializerUtil.copyBean((Object)settings, (Object)this.mySettings);
    }

    public void fireSettingsChanged(ChangeType changeType) {
        ((Listener)this.myMessageBus.syncPublisher(TOPIC)).settingsChanged(changeType);
    }

    @Nullable
    public String getSelectedTab() {
        return this.mySettings.selectedTab;
    }

    public void setSelectedTab(@Nullable String selectedTab) {
        this.mySettings.selectedTab = selectedTab;
    }

    public boolean isShowDoc() {
        return this.mySettings.showDoc;
    }

    public void setShowDoc(boolean value) {
        this.mySettings.showDoc = value;
    }

    public boolean isShowLiveBeansGraph() {
        return this.mySettings.showLiveBeansGraph;
    }

    public void setShowLiveBeansGraph(boolean value) {
        this.mySettings.showLiveBeansGraph = value;
    }

    public boolean isShowContexts() {
        return this.mySettings.showContexts;
    }

    public void setShowContexts(boolean value) {
        this.mySettings.showContexts = value;
    }

    public boolean isShowFiles() {
        return this.mySettings.showFiles;
    }

    public void setShowFiles(boolean value) {
        this.mySettings.showFiles = value;
    }

    public boolean isShowLibraryMappings() {
        return this.mySettings.showLibraryMappings;
    }

    public void setShowLibraryMappings(boolean value) {
        this.mySettings.showLibraryMappings = value;
    }

    public Set<String> getFilteredRequestMethods() {
        return this.mySettings.filteredRequestMethods;
    }

    public static class Settings {
        public String selectedTab;
        public boolean showDoc = true;
        public boolean showLiveBeansGraph = true;
        public boolean showContexts = true;
        public boolean showFiles = true;
        public boolean showLibraryMappings = true;
        public Set<String> filteredRequestMethods = ContainerUtil.newHashSet();
    }

    public static interface Listener {
        public void settingsChanged(ChangeType var1);
    }

    public static enum ChangeType {
        BEANS_FULL,
        BEANS_UPDATE_DETAILS,
        HEALTH_CHECK,
        REQUEST_MAPPINGS;

    }
}

